
/* adding all properties from definitions and lemmas to the database */
add_defs_and_lemmas :- add_general_defs([]), 
                       write('DEFINITIONS ADDED: '), nl, add_definitions([],0), nl,
                       write('LEMMAS ADDED: '), nl, add_lemmas(0,'GL0',_), nl. 

/* ----------------------------------------------------------------- */

add_general_defs(All) :- general_def(Obj,Props,Rel_obj,GDId),
                         relevant_all(Rel_obj,[]),
                         not_element(Obj,All), !,
                         asserta(def(Obj,Props,GDId)),
                         add_general_defs([Obj|All]).
add_general_defs(_) :- !.     

/* ----------------------------------------------------------------- */

/* adding definitions */
add_definitions(All,N) :- def(Obj,Props,Name), not_element(Obj,All), !,
                          add_defs_to_db(Props,N,N1,Name),
                          open('definicije_nove_wernick1.txt',append,Stream),
                          term_to_atom(Obj,Obj1),
                          term_to_atom(Props,Props1),
                          string_concat('def(',Obj1,P1),
                          string_concat(P1,',',P2),
                          string_concat(P2,Props1,P3),
                          string_concat(P3,',',P4),
                          string_concat(P4,'\'',P5),
                          string_concat(P5,Name,P6),
                          string_concat(P6,'\'',P7),
                          string_concat(P7,').',P8),
                          write(Stream,P8), nl(Stream),
                          close(Stream),
                          add_definitions([Obj|All],N1).
add_definitions(_,N)   :- !, write('Total number of properties derived from definitions: '), 
                          write(N), nl.

/* ----------------------------------------------------------------- */

/* adding all definitions from the list separately to the database; 
   all definitions are printed to the standard output */
add_defs_to_db([],N,N,_).
add_defs_to_db([H|T],N,N1,Name) :-  assertz(def_inst(H,[Name])), N2 is N+1, 
                                    write(def_inst(H,[Name])), nl, 
                                    open('definicije_nove_wernick1.txt',append,Stream),
                                    term_to_atom(H,H1),
                                    string_concat('def_inst(',H1,P1),
                                    string_concat(P1,',[\'',P2),
                                    string_concat(P2,Name,P3),
                                    string_concat(P3,'\']).',P4),
                                    write(Stream,P4), nl(Stream),
                                    close(Stream),
                                    add_defs_to_db(T,N2,N1,Name).

/* ----------------------------------------------------------------- */

/* instantiation of general lemmas */
add_lemmas(N,GLPrev,Derived_objPrev) :- general_lemma(Known_obj,Derived_obj,Unifier,Rel_obj,GLId), 
                 GLPrev@>GLId,
                 functor(Derived_objPrev,Name,Arity),
                 functor(Derived_objGen,Name,Arity),
                 element(Derived_objGen,Known_obj),
                 set_equal(Derived_objPrev,Known_obj),
                 all_defs_or_lemmas(Known_obj,[],ListOfLemmas), 
                 eval(Unifier),
                 relevant_all(Rel_obj,Derived_obj),
                 not_def_nor_lemma(Derived_obj), 
                 /* ovo je dodato zbog homotetije, 
                    da bi se izbeglo generisanje velikih termova  */
                 depth_homothety(Derived_obj), 
                 /* ovo sluzi za izvodjenje incidencija da bi se smanjio
                    broj izvedenih svojstava */
                 /*not_derived_incidence(Derived_obj),*/
                 !,
                 myunion([GLId],ListOfLemmas,ListOfLemmas1),
                 add_lemma_to_db(Derived_obj,ListOfLemmas1), N1 is N+1,
                 add_lemmas(N1,GLId,Derived_obj).
add_lemmas(N,GLPrev,_) :- general_lemma(Known_obj,Derived_obj,Unifier,Rel_obj,GLId), 
                 GLPrev @=< GLId,
                 all_defs_or_lemmas(Known_obj,[],ListOfLemmas), 
                 eval(Unifier),
                 relevant_all(Rel_obj,Derived_obj),
                 not_def_nor_lemma(Derived_obj), 
                 /* ovo je dodato zbog homotetije, 
                    da bi se izbeglo generisanje velikih termova  */
                 depth_homothety(Derived_obj), 
                 /* ovo sluzi za izvodjenje incidencija da bi se smanjio
                    broj izvedenih svojstava */
                 /*not_derived_incidence(Derived_obj), */
                 !,
                 myunion([GLId],ListOfLemmas,ListOfLemmas1),
                 add_lemma_to_db(Derived_obj,ListOfLemmas1), N1 is N+1,
                 add_lemmas(N1,GLId,Derived_obj).
add_lemmas(N,_,_) :- !, write('Total number of instantiated general lemmas: '), write(N), nl.

set_equal(H,[H|_]).
set_equal(H,[_|T]) :- set_equal(H,T).

set_equal2([H|_],[H|_]).
set_equal2(L,[_|T]) :- set_equal2(L,T).
set_equal2([_|T],L) :- set_equal2(T,L).

/* ----------------------------------------------------------------- */

/* if P=Q then not both inc(A,P) and inc(A,Q) are derived */
not_derived_incidence(Obj) :- Obj = inc(A,P), def_or_lemma(inc(A,Q),_), equal_lines(P,Q), 
                              !, fail. 
not_derived_incidence(_). 

/* ----------------------------------------------------------------- */

/* for homothety only terms up to depth 4 are generated */
depth_homothety(Obj) :- Obj = inc(_,homothety(_,_,_,_)), !, 
                        term_depth(Obj,Depth), 
                        Depth < 4.
depth_homothety(Obj) :- Obj = inc_k(_,homothety_circ(_,_,_,_)), !, 
                        term_depth(Obj,Depth), 
                        Depth < 5.
depth_homothety(_).

/* ----------------------------------------------------------------- */

/* evaluating lists of objects */
eval([]).
/* evaluating sum/difference */
eval([(X,L-K),(Y,L1-K1)]) :- !, X is L-K, Y is L1-K1.
eval([(X,L+K),(Y,L1+K1)]) :- !, X is L+K, Y is L1+K1.
eval([(X,L-K)]) :- !, X is L-K.
eval([(X,L+K)]) :- !, X is L+K.

/* evaluating denominator and nominator of the fraction */
eval([(X,L-K),(Y,L)]) :- X is L-K, Y is L, Y > 0, !.
eval([(X,L-K),(Y,L)]) :- X is K-L, Y is -L.
eval([(X,K),(Y,L)]) :- X is K, Y is L, Y > 0, !.
eval([(X,K),(Y,L)]) :- X is -K, Y is -L. 

/* ----------------------------------------------------------------- */

/* adding lemma to the database;
   all lemmas are printed to standard output */
add_lemma_to_db(P,ListOfLemmas) :-  assertz(derived_lemma(P,ListOfLemmas)), 
                                    write(derived_lemma(P,ListOfLemmas)), nl,
                                    open('leme_nove_wernick1.txt',append,Stream),
                                    term_to_atom(P,PA),
                                    string_concat('derived_lemma(',PA,P1),
                                    string_concat(P1,',',P2),
                                    term_to_atom(ListOfLemmas,ListOfLemmas2),
                                    string_concat(P2,ListOfLemmas2,P3),
                                    string_concat(P3,').',P4),
                                    write(Stream,P4), nl(Stream),
                                    close(Stream), !.

/* ----------------------------------------------------------------- */

/*OVDE SE GUSI, ISPROBAVA ZA SVAKO SVOJSTVO JEDNAKOST*/
/*PROBATI STA BI BILO DA SE IZBACI EQUAL.....*/
/* testing if the property is a definition or a lemma */
/*def_or_lemma(P,L) :- def_inst(P1,L), equal(P,P1).
def_or_lemma(P,[L]) :- basic_lemma(P1,L), equal(P,P1).
def_or_lemma(P,L) :- derived_lemma(P1,L), equal(P,P1).*/
def_or_lemma(P,L) :- def_inst(P,L).
def_or_lemma(P,[L]) :- basic_lemma(P,L).
def_or_lemma(P,L) :- derived_lemma(P,L).

/* ----------------------------------------------------------------- */

/* testing if the property is neither definition nor lemma */
not_def_nor_lemma(P) :- def_or_lemma(P,_), !, fail.
not_def_nor_lemma(_).

/* ----------------------------------------------------------------- */

/* testing if all elements of the list are definitions or lemmas */
all_defs_or_lemmas([],L,L)                      :- !.
all_defs_or_lemmas([not_eq_point(P,P1)|T],L,L1)        :- !, notequal(P,P1), all_defs_or_lemmas(T,L,L1). 
all_defs_or_lemmas([not_eq_line(P,P1)|T],L,L1)        :- !, notequal(P,P1), not_equal_lines(P,P1), all_defs_or_lemmas(T,L,L1). 
all_defs_or_lemmas([not_eq_circle(P,P1)|T],L,L1)        :- !, notequal(P,P1), not_equal_circles(P,P1), all_defs_or_lemmas(T,L,L1).
all_defs_or_lemmas([not_true(H)|_],_,_)         :- def_or_lemma(H,_), !, fail.
all_defs_or_lemmas([not_true(_)|T],L,L1)        :- !, all_defs_or_lemmas(T,L,L1).
all_defs_or_lemmas([parallel(A,B)|T],L,L1)      :- !, parallel(A,B), all_defs_or_lemmas(T,L,L1).
all_defs_or_lemmas([not_parallel(A,B)|_],_,_)   :- parallel(A,B), !, fail.
all_defs_or_lemmas([not_parallel(_,_)|T],L,L1)  :- !, all_defs_or_lemmas(T,L,L1).
all_defs_or_lemmas([H|T],L,L1)                  :- def_or_lemma(H,List),
                                                   myunion(L,List,LNew),
                                                   all_defs_or_lemmas(T,LNew,L1). 

/* ----------------------------------------------------------------- */

/* some cases when two lines are equal */
equal_lines(P,Q) :- def_or_lemma(inc(A,P),_), def_or_lemma(inc(A,Q),_), 
                    def_or_lemma(inc(B,P),_), notequal(A,B), def_or_lemma(inc(B,Q),_).
equal_lines(P,Q) :- def_or_lemma(inc(A,P),_),
                    def_or_lemma(inc(A,Q),_), parallel(P,Q).

/* ----------------------------------------------------------------- */

/* when are two lines distinct */
not_equal_lines(P,Q) :- equal_lines(P,Q), !, fail.
not_equal_lines(_,_).

/* ----------------------------------------------------------------- */

/* some cases when two circles are equal */
equal_circles(P,Q) :- def_or_lemma(inc_k(A,P),_), def_or_lemma(inc_k(A,Q),_), 
                      def_or_lemma(inc_k(B,P),_), notequal(A,B),
                      def_or_lemma(inc_k(B,Q),_), def_or_lemma(inc_k(C,P),_), 
                      notequal(A,C), notequal(B,C), def_or_lemma(inc_k(C,Q),_).
equal_circles(circle_center_through(C,P),homothety_circ(C,circle_center_through(C,P),-1,1)). 
equal_circles(homothety_circ(C,circle_center_through(C,P),-1,1),circle_center_through(C,P)). 

/* ----------------------------------------------------------------- */

/* when are two circles distinct */
not_equal_circles(P,Q) :- equal_circles(P,Q), !, fail.
not_equal_circles(_,_).

/* ----------------------------------------------------------------- */

/* when are two lines parallel */
/*MOZDA NE TREBA CUT NA KRAJU SVAKOG PRAVILA? AKO JE POTREBNO NE SAMO ZA TESTIRANJE VEC I ZA GENERISANJE SVOJSTAVA */
parallel(P,P) :- !.
parallel(P,Q) :- def_or_lemma(parallel(P,Q),_), !.
parallel(P,Q) :- def_or_lemma(parallel(Q,P),_), !.
parallel(P,Q) :- def_or_lemma(perp(P,R),_),
                 def_or_lemma(perp(Q,R),_), !.
parallel(P,Q) :- def_or_lemma(perp(P,R),_),
                 def_or_lemma(perp(R,Q),_), !.
parallel(P,Q) :- def_or_lemma(perp(R,P),_),
                 def_or_lemma(perp(Q,R),_), !.
parallel(P,Q) :- def_or_lemma(perp(R,P),_),
                 def_or_lemma(perp(R,Q),_), !.
parallel(homothety(_,L,_,_),Q) :- parallel(L,Q), !.
parallel(at_dist(L,_),Q) :- parallel(L,Q), !.
parallel(Q,at_dist(L,_)) :- parallel(L,Q), !.
parallel(Q,homothety(_,L,_,_)) :- parallel(L,Q), !.
parallel(homothety(_,L,_,_),homothety(_,L1,_,_)) :- parallel(L,L1), !.
parallel(side_bis([A,B]),Q) :- def_or_lemma(perp(Q,R),_), 
                               def_or_lemma(inc(A,R),_), def_or_lemma(inc(B,R),_), !.
parallel(side_bis([A,B]),Q) :- def_or_lemma(perp(R,Q),_), 
                               def_or_lemma(inc(A,R),_), def_or_lemma(inc(B,R),_), !.
parallel(Q,side_bis([A,B])) :- def_or_lemma(perp(Q,R),_), 
                               def_or_lemma(inc(A,R),_), def_or_lemma(inc(B,R),_), !.
parallel(Q,side_bis([A,B])) :- def_or_lemma(perp(R,Q),_), 
                               def_or_lemma(inc(A,R),_), def_or_lemma(inc(B,R),_), !.
 
