﻿     
:- dynamic(a/0).
:- dynamic(p/0).
:- dynamic(i/0).
:- dynamic(q/0).
:- dynamic(r/1).
:- dynamic(c/1).
:- dynamic(p/1).
:- dynamic(x/0).
:- dynamic(miniversion/0).
:- dynamic(gclc_def/2).
:- dynamic(problem_setting/4).

/* ----------------------------------------------------------------- */

/* consulting all files for mini version */
myimport_mini :- i, !.
myimport_mini :- consult('AuxiliaryPredicates.pro'),
                 consult('Defs.pro'),
                 consult('Lemmas.pro'),
                 consult('ConstructionRules.pro'),
                 consult('Preprocessing.pro'),
                 consult('Drawing.pro'),
                 consult('Search.pro'),
                 consult('Verification.pro'),
                 consult('Discussion.pro')
                 ,consult('problemi_wernick.txt')
                 ,consult('problemi_connelly.txt')
                 ,consult('statusi_problema_connelly.pro')
                 ,consult('statusi_problema_wernick.pro')
                 ,assert(i).

/* ----------------------------------------------------------------- */

/* initialization consists of importing other files and lemma generation,
   it is executed only once, before solving the first problem */
init :- p, !.


/*
init :- miniversion, 
          statistics(cputime,TB),
          myimport_mini, 
          add_defs_and_lemmas, 
          generate_all_gclc_definitions([]), nl, nl,
          generate_all_xml_definitions([]), nl, nl,
          statistics(cputime,T1),
          Time is T1-TB,
          write('Time za preprocess: '), 
          format('~1f',[Time]), write(' seconds.'), nl, nl,
          assert(p), !.
*/


/* AKO ZELIMO DA TESTIRAMO SA DEFINICIJAMA I LEMAMA IZ FAJLA*/

init :- miniversion, 
        statistics(cputime,TB),
        myimport_mini, 
        consult('definicije_nove_wernick1.txt'), 
        consult('leme_nove_wernick1.txt'), 
        generate_all_gclc_definitions([]), nl, nl,
        generate_all_xml_definitions([]), nl, nl,
        statistics(cputime,T1),
        Time is T1-TB,
        write('Time za preprocess: '), 
        format('~1f',[Time]), write(' seconds.'), nl, nl,                                     
        assert(p), !.


/* ----------------------------------------------------------------- */

four_digit_name(N,N) :- N>=1000, !.
four_digit_name(N,Name) :- N>=100, !, atom_concat('0',N,Name).
four_digit_name(N,Name) :- N>=10, !, atom_concat('00',N,Name).
four_digit_name(N,Name) :- atom_concat('000',N,Name).

/* ----------------------------------------------------------------- */

/* name of the output files are constructed according to the name of the problem */
output_txt_file_name(N,File) :- four_digit_name(N,Name), atom_concat('constructions/construction_',Name,A), atom_concat(A,'.txt',File).
output_gclc_file_names(N,File0,File02,File,File1,File2) :- four_digit_name(N,Name), atom_concat('constructions/construction1_',Name,A), atom_concat(A,'.gcl',File), 
                                             atom_concat('animations/animation_',Name,E), atom_concat(E,'.gcl',File02),
                                             atom_concat('constructions/construction2_',Name,B), atom_concat(B,'.gcl',File1),
                                             atom_concat('constructions/construction3_',Name,C), atom_concat(C,'.gcl',File2),
                                             atom_concat('constructions/construction0_',Name,D), atom_concat(D,'.gcl',File0).
output_xml_file_names(N,File,File1,File2) :- four_digit_name(N,Name), atom_concat('constructions/construction1_',Name,A), atom_concat(A,'.xml',File),
                                            atom_concat('constructions/construction2_',Name,B), atom_concat(B,'.xml',File1),
                                            atom_concat('constructions/construction3_',Name,C), atom_concat(C,'.xml',File2).
output_tex_file_name(N,File) :- four_digit_name(N,Name), atom_concat('constructions/construction_',Name,A), atom_concat(A,'.tex',File).
output_html_file_name(N,File) :- four_digit_name(N,Name), atom_concat('animations/construction_',Name,A), atom_concat(A,'.html',File).
output_gclc_html_file_name(N,File) :- four_digit_name(N,Name), atom_concat('animations/construction_gclc_',Name,A), atom_concat(A,'.html',File).
output_argoclp_axioms_file_name(N,File) :- four_digit_name(N,Name), atom_concat('constructions/axioms_',Name,A), atom_concat(A,'.txt',File).
output_argoclp_theorem_file_name(N,File) :- four_digit_name(N,Name), atom_concat('constructions/theorem_',Name,A), atom_concat(A,'.txt',File).

/* ----------------------------------------------------------------- */

/* solving N-th problem in our numeration and calculating time */
solve_time(N,Stream,RulesUsed,LemmasUsed,Status) :- assert(miniversion), 
                                             /* asserting executes miniversion, 
                                                commenting this line executes full version */ 
                                             init, 
                                             statistics(cputime,T1),
                                             problem_setting(N,_,Known,_),
                                             write('Problem:'), write(N), write(': '), 
                                             write_tex_list(Known,1), nl, flush, 
                                             write(Stream, N), write(Stream, '. & '), 
                                             write_tex_list(Known,1,Stream),
                                             write(Stream, ' & '),
                                             solve(N,Stream,RulesUsed,LemmasUsed,Status),
                                             tab(Stream,3),
                                             symmetric_problem(N,Stream), /* determining if the problem is symmetric to some of previous problems */
                                             /* proveri koliko ima netrivijalnih tvrdjenja */
                                             /*count_nontrivial(N,0,Br),*/
                                             open('statusi_problema_connelly.pro',append,Str),
                                             write(Str,'status_real('), write(Str,N), write(Str,','),
                                             write(Str,Status), write(Str,').'), nl(Str),
                                             close(Str),
                                             write(Stream, '& '),
                                             /* write(Stream,Br),
                                             write(Stream, ' &   &   &   &  '),*/
                                             /* da se stampa novi red nakon svakog reda */
                                             /*write(Stream, ' \\\\ \\hline'),*/ 
                                             nl(Stream), 
                                             /*write_nl_third(Stream,N), */
                                             statistics(cputime,T2),
                                             Time1 is T2-T1,
                                             write('Time: '), 
                                             format('~1f',[Time1]), write(' seconds.'), nl, nl, 
                                             /*write('KRAJ'),*/ !.
            
/* ----------------------------------------------------------------- */

count_nontrivial(N,X,Y) :- problem_setting(N,_,Known,_),
                           /*write('NONTRIVIAL: '), write(Known),*/
                           count_pom(Known,X,Y).
 
count_pom([],X,X) :- !.
count_pom([obj(point,O)|T],X,Y) :- /*write('O: '), write(O), nl,*/
                                   not_element(O,['a','b','c']), !,
                                   X1 is X+1,
                                   count_pom(T,X1,Y).
count_pom([_|T],X,Y) :- count_pom(T,X,Y).

/* ----------------------------------------------------------------- */

write_nl_third(Stream,N) :- N rem 3 =:= 0, write(Stream, ' \\\\ \\hline'), nl(Stream), !.
write_nl_third(_,_).



/* ----------------------------------------------------------------- */

/* solving N-th problem in our numeration */

/* determining if the problem is redundant */
solve(N,Stream,RulesUsed,LemmasUsed,Status) :-
            redundant_problem(N,RulesUsed,LemmasUsed), 
            tab(Stream,3), write(Stream,'R'), tab(Stream,3), 
            write('Problem is redundant'), nl, 
            Status='r', !. 

/* determining if the problem is locus-dependent */
solve(N,Stream,RulesUsed,LemmasUsed,Status) :- 
            locus_dependent_problem(N,RulesUsed,LemmasUsed), 
            tab(Stream,3), write(Stream,'L'), tab(Stream,3), 
            write('Problem is locus dependent'), nl, 
            Status='l', !.

/* if the problem is neither redundant nor symmetric to some of the previous problems, we try to solve it */
solve(N,Stream,RulesUsed,LemmasUsed,Status) :- 
            problem_setting(N,Name,Known,Sought), 
            construct(Known,Sought,Name,N,Stream,RulesUsed,LemmasUsed,Status),
            write(Status), !.

/* ----------------------------------------------------------------- */

/* solving all the problems from the corpus, while total time is calculated; 
   the argument of the procedure is the total number of problems */
solve_all_time(To,From,FileName,FileStatDef,FileStatLemma,FileStatConstr,Num,RulesUsed,RulesUsed1,LemmasUsed,LemmasUsed1) :- 
                     statistics(cputime, T1), 
                     solve_all(To,From,FileName,FileStatDef,FileStatLemma,FileStatConstr,RulesUsed,RulesUsed1,LemmasUsed,LemmasUsed1,Num,0,S,0,L,0,R), 
                     statistics(cputime, T2), Time is T2-T1, 
                     nl, write('Total time: '), format('~1f',[Time]), write(' seconds.'), nl,
                     open(FileName,append,Stream),
                     quick_sort(RulesUsed1,RulesOrdered),
                     write('Rules Used In Total: '), write(RulesOrdered), nl,
                     write(Stream, 'Rules Used In Total: '), write(Stream,RulesOrdered), nl(Stream),
                     quick_sort(LemmasUsed1,LemmasOrdered),
                     write('Lemmas Used In Total: '), write(LemmasOrdered), 
                     write(Stream,'Lemmas Used In Total: '), write(Stream,LemmasOrdered), 
                     write(Stream,'Lemmas Used In Total: '), write(Stream,LemmasOrdered), 
                     nl, nl, write('Solvable: '), write(S), nl,
                     write('Locus dependent: '), write(L), nl,
                     write('Redundant: '), write(R), nl,
                     write(Stream,'Solvable: '), write(Stream,S), nl(Stream),
                     write(Stream,'Locus dependent: '), write(Stream,L), nl(Stream),
                     write(Stream,'Redundant: '), write(Stream,R), nl(Stream),
                     close(Stream), !.

/* ----------------------------------------------------------------- */

/* the number of statuses of the solved, redundant and ld problems is being updated */
azuriraj_statuse('s',S,S1,L,L,R,R) :- S1 is S+1.
azuriraj_statuse('l',S,S,L,L1,R,R) :- L1 is L+1.
azuriraj_statuse('r',S,S,L,L,R,R1) :- R1 is R+1.
azuriraj_statuse(_,S,S,L,L,R,R).

/* solving all the problems from the corpus */
solve_all(N,M,_,_,_,_,RulesUsed,RulesUsed,LemmasUsed,LemmasUsed,_,S,S,L,L,R,R) :- M > N, !.
solve_all(N,M,FileName,FileStatDef,FileStatLemma,FileStatConstr,Rules,Rules1,Lemmas,Lemmas1,Num,S0,S0N,L0,L0N,R0,R0N) :- open(FileName,append,Stream),
                  open(FileStatDef,append,Stream1),
                  open(FileStatConstr,append,Stream2),
                  open(FileStatLemma,append,Stream3),
                  solve_time(M,Stream,R,L,Status), !,
                  azuriraj_statuse(Status,S0,SN,L0,LN,R0,RN),
                  /*na osnovu statusa uvecati odgovarajuci brojac!
                  izmeni ostale predikate! */
                  close(Stream),
                  M1 is M+1, 
                  myunion(R,Rules,RulesNew),
                  quick_sort(RulesNew,RulesOrdered),
                  myunion(L,Lemmas,LemmasNew),
                  quick_sort(LemmasNew,LemmasOrdered),
                  nl, write('Construction used so far: '), write(RulesOrdered), 
                  length(RulesOrdered,L1),
                  write(Stream2,Num), write(Stream2,' '), 
                  write(Stream2,L1), nl(Stream2),
                  nl, write('Definitions and lemmas used so far: '), write(LemmasOrdered), nl,
                  length_defs(LemmasOrdered,0,L2),
                  length_lemmas(LemmasOrdered,0,L3),
                  write(Stream1,Num), write(Stream1,' '), 
                  write(Stream1,L2), nl(Stream1),
                  write(Stream3,Num), write(Stream3,' '), 
                  write(Stream3,L3), nl(Stream3),
                  close(Stream1),
                  close(Stream2),
                  close(Stream3),
                  Num1 is Num+1,
                  write('Solvable so far: '), write(SN), nl,
                  write('Locus dependent so far: '), write(LN), nl,
                  write('Redundant so far: '), write(RN), nl,
                  solve_all(N,M1,FileName,FileStatDef,FileStatLemma,FileStatConstr,RulesNew,Rules1,LemmasNew,Lemmas1,Num1,SN,S0N,LN,L0N,RN,R0N). 

/* ----------------------------------------------------------------- */

length_lemmas([],N,N) :- !.
length_lemmas([H|T],N,M) :- string_concat('L',_,H), !, N1 is N+1, length_lemmas(T,N1,M).
length_lemmas([H|T],N,M) :- string_concat('GL',_,H), !, N1 is N+1, length_lemmas(T,N1,M).
length_lemmas([_|T],N,M) :- length_lemmas(T,N,M).

/* ----------------------------------------------------------------- */

length_defs([],N,N) :- !.
length_defs([H|T],N,M) :- string_concat('D',_,H), !, N1 is N+1, length_defs(T,N1,M).
length_defs([H|T],N,M) :- string_concat('GD',_,H), !, N1 is N+1, length_defs(T,N1,M).
length_defs([_|T],N,M) :- length_defs(T,N,M).


/* ----------------------------------------------------------------- */

/* the user enters the number of the problem to be solved */
solve :- !, write('Enter the number of the problem ended by a dot: '), 
         read(N),
         open('lista.txt', write, Stream),
         solve_time(N,Stream,_,_,_),
         close(Stream).

/* ----------------------------------------------------------------- */

/* solving all problems from Wernick's corpus */
solve_wernick :- assert(miniversion), init, 
                 /*generate_wernick(N),*/
                 /* umesto 560 treba vratiti N*/
                 solve_all_time(560,1,'WERNICK_LIST.txt',
                                'statistika_nova_wernick_def.txt', 'statistika_nova_wernick_lemma.txt','statistika_nova_wernick_constructions.txt',1,
                                [],_,[],_), !.

/* ----------------------------------------------------------------- */

/* solving all problems from Pascal's corpus */
solve_pascal :- assert(miniversion), init, generate_pascal(N), 
                 solve_all_time(N,2001,'PASCAL_list.txt',
                                'statistika_pascal_def.txt','statistika_pascal_lemma.txt','statistika_pascal_constructions.txt',1,
                                [],_,[],_), !.

/* ----------------------------------------------------------------- */

/* solving all problems from Connelly's corpus */
solve_connelly :- assert(miniversion), init, 
                 /*generate_connelly1(N),*/
                 /* umesto 1140 treba vratiti N*/
                 solve_all_time(1140,561,'CONNELLY_LIST.txt',
                 'statistika_connelly_def_nova.txt','statistika_connelly_lemma_nova.txt','statistika_connelly_constructions_nova.txt',1,
                 [],_,[],_), !.

/* ----------------------------------------------------------------- */

/* solving all problems from Wernick's and Connnelly's corpus */
solve_wernick_and_connelly :- assert(miniversion), init,
                 /*generate_wernick(N),*/ 
                 solve_all_time(560,1,'WERNICK_LIST.txt',
                                'statistika_wc_def.txt', 'statistika_wc_lemma.txt','statistika_wc_constructions.txt',1,
                                [],RulesUsed,[],LemmasUsed), 
                 /*generate_connelly1(N),*/
                 solve_all_time(1580,1001,'CONNELLY_LIST.txt',
                 'statistika_wc_def.txt','statistika_wc_lemma.txt','statistika_wc_constructions.txt',561,
                 RulesUsed,_,LemmasUsed,_), !.



/* ----------------------------------------------------------------- */

/* solving N-th problem */
solve_one(N) :- assert(miniversion), 
                init, 
                open('test.txt', write, Stream),
                solve_time(N,Stream,RulesUsed,LemmasUsed,_),
                quick_sort(RulesUsed,RulesOrdered),
                quick_sort(LemmasUsed,LemmasOrdered),
                write('Rules Used:'), write(RulesOrdered), nl,
                write('Lemmas Used:'), write(LemmasOrdered), nl, 
                close(Stream).

/* solving all problems from the list */
solve_list(L) :- solve_list_aux(L,[],RulesUsed,[],LemmasUsed),
                 quick_sort(RulesUsed,RulesOrdered),
                 quick_sort(LemmasUsed,LemmasOrdered),
                 write('Rules Used:'), write(RulesOrdered), nl,
                 write('Lemmas Used:'), write(LemmasOrdered), nl, !.

solve_list_aux([],RulesUsed,RulesUsed,LemmasUsed,LemmasUsed).
solve_list_aux([N|T],RulesUsed,RulesUsed1,LemmasUsed,LemmasUsed1) :- 
                             assert(miniversion), init, 
                             open('lista1.txt', append, Stream),
                             solve_time(N, Stream,R,L,_,_),
                             close(Stream), 
                             myunion(R,RulesUsed,RulesUsedNew),
                             myunion(L,LemmasUsed,LemmasUsedNew),
                             solve_list_aux(T,RulesUsedNew,RulesUsed1,LemmasUsedNew,LemmasUsed1).

/* ----------------------------------------------------------------- */

/* generation of all problems from Wernick's corpus */
generate_wernick(N) :- r(N), !.
generate_wernick(N) :- myimport_mini,
                       write('Wernick`s corpus:'), nl,
                       open('problemi_wernick.txt',write,Stream),                                                       
                       generate_all_triples([obj(point,a),obj(point,b),obj(point,c),
                                             obj(point,circumcenter([a,b],c)),
                                             obj(point,midpoint([b,c])),
                                             obj(point,midpoint([a,c])),
                                             obj(point,midpoint([a,b])),
                                             obj(point,centroid([a,b],c)),
                                             obj(point,foot(a,[b,c])),
                                             obj(point,foot(b,[a,c])),
                                             obj(point,foot(c,[a,b])),
                                             obj(point,orthocenter([a,b],c)),
                                             obj(point,angle_bis_foot(a,[b,c])),
                                             obj(point,angle_bis_foot(b,[a,c])),
                                             obj(point,angle_bis_foot(c,[a,b])),
                                             obj(point,incenter([a,b],c))
                                             ],0,N,[],_,Stream),
                       close(Stream),
                       assert(r(N)), nl, nl, !.

/* ----------------------------------------------------------------- */

/* generation of all problems from Pascal's corpus */
generate_pascal(N) :- p(N), !.
generate_pascal(N) :- myimport_mini,
                      write('Pascal`s corpus:'), nl,
                      open('problemi_pascal.txt',write,Stream),                                                        
                      generate_all_triples([obj(length,length(segment([b,c]))),
                                            obj(length,length(segment([a,c]))),
                                            obj(length,length(segment([a,b]))),
                                            obj(length,length(segment([a,midpoint([b,c])]))),
                                            obj(length,length(segment([b,midpoint([a,c])]))),
                                            obj(length,length(segment([c,midpoint([a,b])]))),
                                            obj(length,length(segment([a,foot(a,[b,c])]))),
                                            obj(length,length(segment([b,foot(b,[a,c])]))),
                                            obj(length,length(segment([c,foot(c,[a,b])])))
                                            ],2000,N,[],_,Stream),
                       close(Stream),
                       assert(p(N)), nl, nl, !.

/* ----------------------------------------------------------------- */

/* generation of all problems from Connelly's corpus */
generate_connelly(N) :- c(N), !.
generate_connelly(N) :- myimport_mini,
                        write('Connelly`s corpus:'), nl,
                        open('problemi_connelly.txt',write,Stream),                                                       
                        generate_all_comb_triples(
                                             [obj(point,euler(a,[b,c])),
                                             obj(point,euler(b,[a,c])),
                                             obj(point,euler(c,[a,b])),
                                             obj(point,npcenter([a,b],c))
                                             ],
                                             [obj(point,a),obj(point,b),obj(point,c),
                                             obj(point,centroid([a,b],c)),
                                             obj(point,orthocenter([a,b],c)),
                                             obj(point,foot(a,[b,c])),
                                             obj(point,foot(b,[a,c])),
                                             obj(point,foot(c,[a,b])),
                                             obj(point,incenter([a,b],c)),
                                             obj(point,midpoint([b,c])),
                                             obj(point,midpoint([a,c])),
                                             obj(point,midpoint([a,b])),
                                             obj(point,npcenter([a,b],c)),
                                             obj(point,circumcenter([a,b],c)),
                                             obj(point,angle_bis_foot(a,[b,c])),
                                             obj(point,angle_bis_foot(b,[a,c])),
                                             obj(point,angle_bis_foot(c,[a,b]))
                                             ],1000,N,[],_,Stream),
                       close(Stream),
                       assert(c(N)), nl, nl, !.

generate_connelly1(N) :- c(N), !.
generate_connelly1(N) :- myimport_mini,
                         write('Connelly`s corpus:'), nl,
                         open('problemi_connelly_novi.txt',write,Stream),                                                       
                         generate_all_comb_triples1([obj(point,euler(a,[b,c])),
                                             obj(point,euler(b,[a,c])),
                                             obj(point,euler(c,[a,b])),
                                             obj(point,npcenter([a,b],c))
                                             ],
                                             [obj(point,a),obj(point,b),obj(point,c),
                                             obj(point,euler(a,[b,c])),
                                             obj(point,euler(b,[a,c])),
                                             obj(point,euler(c,[a,b])),
                                             obj(point,centroid([a,b],c)),
                                             obj(point,orthocenter([a,b],c)),
                                             obj(point,foot(a,[b,c])),
                                             obj(point,foot(b,[a,c])),
                                             obj(point,foot(c,[a,b])),
                                             obj(point,incenter([a,b],c)),
                                             obj(point,midpoint([b,c])),
                                             obj(point,midpoint([a,c])),
                                             obj(point,midpoint([a,b])),
                                             obj(point,npcenter([a,b],c)),
                                             obj(point,circumcenter([a,b],c)),
                                             obj(point,angle_bis_foot(a,[b,c])),
                                             obj(point,angle_bis_foot(b,[a,c])),
                                             obj(point,angle_bis_foot(c,[a,b]))
                                             ],560,N,[],_,Stream),
                         close(Stream),
                         assert(c(N)), nl, nl, !.

/* ----------------------------------------------------------------- */

/* generating all distinct triples out of given list of objects */
generate_all_triples(ObjectList,N,N2,Triples,AllTriples,Stream) :- element(A,ObjectList), element(B,ObjectList), A\=B,
                                                       element(C,ObjectList), A\=C, B\=C,
                                                       X=[A,B,C],
                                                       not_element(X,Triples), !, N1 is N+1,
                                                       Y=[obj(point,a),obj(point,b),obj(point,c)],
                                                       assert(problem_setting(N1,N1,X,Y)),
                                                       write(Stream,problem_setting(N1,N1,X,Y)), 
                                                       write(Stream,'.'),
                                                       nl(Stream), 
                                                       write(problem_setting(N1,N1,X,Y)), nl, 
                                                       generate_all_triples(ObjectList,N1,N2,[[A,B,C]|Triples],AllTriples,Stream). 
generate_all_triples(_,N,N,Triples,Triples,_) :- !.

/* ----------------------------------------------------------------- */

/* generating all distinct triples where first element is from the first list, and other two from the second list of objects */
generate_all_comb_triples(ObjectList1,ObjectList2,N,N2,Triples,AllTriples,Stream) :- element(A,ObjectList1), element(B,ObjectList2),
                                                       element(C,ObjectList2), B\=C,
                                                       X=[A,B,C],
                                                       not_element(X,Triples), !, N1 is N+1,
                                                       Y=[obj(point,a),obj(point,b),obj(point,c)],
                                                       assert(problem_setting(N1,N1,X,Y)),
                                                       write(Stream,problem_setting(N1,N1,X,Y)), 
                                                       write(Stream,'.'),
                                                       nl(Stream), 
                                                       write(problem_setting(N1,N1,X,Y)), nl, 
                                                       generate_all_comb_triples(ObjectList1,ObjectList2,N1,N2,[[A,B,C]|Triples],AllTriples,Stream). 
generate_all_comb_triples(_,_,N,N,Triples,Triples,_) :- !.

/* ----------------------------------------------------------------- */

/* generating all distinct triples where first element is from the first list, and other two from the second list of objects */
generate_all_comb_triples1(ObjectList1,ObjectList2,N,N2,Triples,AllTriples,Stream) :- element(A,ObjectList2), element(B,ObjectList2), A\=B,
                                                       element(C,ObjectList2), A\=C, B\=C,
                                                       X=[A,B,C], in_list(ObjectList1,X,X1), X1\=[],
                                                       not_element(X,Triples), !, N1 is N+1,
                                                       Y=[obj(point,a),obj(point,b),obj(point,c)],
                                                       assert(problem_setting(N1,N1,X,Y)),
                                                       write(Stream,problem_setting(N1,N1,X,Y)), 
                                                       write(Stream,'.'),
                                                       nl(Stream), 
                                                       write(problem_setting(N1,N1,X,Y)), nl, 
                                                       generate_all_comb_triples1(ObjectList1,ObjectList2,N1,N2,[[A,B,C]|Triples],AllTriples,Stream). 
generate_all_comb_triples1(_,_,N,N,Triples,Triples,_) :- !.

/* ----------------------------------------------------------------- */

/* find what is an ordinal of the problem in the corpus for the problem we want to solve */
find_problem_number(List,Number) :- problem_setting(Number,_,List,_),
                                    write(Number), nl.

/* ----------------------------------------------------------------- */

generate_html_table_wernick :- assert(miniversion), init,
                               open('compendium_wernick.html',write,Stream),
                               write(Stream,'<!DOCTYPE html>'), nl(Stream),
                               write(Stream,'<html>'), nl(Stream),
                               write(Stream,'<head>'), nl(Stream),
                               write(Stream,'<title>'), nl(Stream),
                               write(Stream,'On-line compendium of Wernick\'s problems'),
                               write(Stream,'</title>'), nl(Stream),
                              
                               write(Stream,'<style>'), nl(Stream),
                               write(Stream,'table, th, td {'), nl(Stream),
                               write(Stream,'border: 1px solid black;'), nl(Stream),
                               write(Stream,'border-collapse: collapse;'), nl(Stream),
                               write(Stream,'padding: 3px;'), nl(Stream),
                               write(Stream,'}'), nl(Stream),
                               write(Stream,'table {'), nl(Stream),
                               write(Stream,'border-spacing: 3px;'), nl(Stream),
                               write(Stream,'}'), nl(Stream),
                               write(Stream,'</style>'), nl(Stream),
                               write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),
                               write(Stream,'</head>'), nl(Stream),

                               write(Stream,'<body>'), nl(Stream),
                               write(Stream,'<h2>'), nl(Stream),

                               write(Stream,'The list of Wernick\'s problems'),
                               write(Stream,'</h2>'), nl(Stream),

                               write(Stream,'<br>'),
                               write(Stream,'<table style="width:100%">'), nl(Stream),
                               write(Stream,'<caption>Statuses of all problems: <em>S (s)</em> denotes that the problem is solvable and its solution is given, <em>S (ns)</em> denotes that the problem is proved solvable but its solution is not given, <em>L</em> that the problem is locus dependent, <em>R</em> that the problem is redundant, while <em>U</em> denotes that the problem is unsolvable.</caption>'), nl(Stream),
                               write(Stream,'<tr>'),
                               print_html_rows(Stream,[],_,1,560),
                               write(Stream,'</tr>'),
                               write(Stream,'</table>'), nl(Stream),
                               write(Stream,'</body>'), nl(Stream),
                               write(Stream,'</html>'), nl(Stream),
                               close(Stream).
 

/* ----------------------------------------------------------------- */

generate_html_table_connelly :- assert(miniversion), init,
                               open('compendium_connelly.html',write,Stream),
                               write(Stream,'<!DOCTYPE html>'), nl(Stream),
                               write(Stream,'<html>'), nl(Stream),
                               write(Stream,'<head>'), nl(Stream),
                               write(Stream,'<title>'), nl(Stream),
                               write(Stream,'On-line compendium of Connelly\'s problems'),
                               write(Stream,'</title>'), nl(Stream),
                              
                               write(Stream,'<style>'), nl(Stream),
                               write(Stream,'table, th, td {'), nl(Stream),
                               write(Stream,'border: 1px solid black;'), nl(Stream),
                               write(Stream,'border-collapse: collapse;'), nl(Stream),
                               write(Stream,'padding: 3px;'), nl(Stream),
                               write(Stream,'}'), nl(Stream),
                               write(Stream,'table {'), nl(Stream),
                               write(Stream,'border-spacing: 3px;'), nl(Stream),
                               write(Stream,'}'), nl(Stream),
                               write(Stream,'</style>'), nl(Stream),
                               write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),                                             
                               write(Stream,'</head>'), nl(Stream),

                               write(Stream,'<body>'), nl(Stream),
                               write(Stream,'<h2>'), nl(Stream),

                               write(Stream,'The list of Connelly\'s problems'),
                               write(Stream,'</h2>'), nl(Stream),

                               write(Stream,'<br>'),
                               write(Stream,'<table style="width:100%">'), nl(Stream),
                               write(Stream,'<caption>Statuses of all problems: <em>S (s)</em> denotes that the problem is solvable and its solution is given, <em>S (ns)</em> denotes that the problem is proved solvable but its solution is not given, <em>L</em> that the problem is locus dependent, <em>R</em> that the problem is redundant, <em>U</em> that the problem is unsolvable, while <em>UK</em> denotes that the status of the problem is still unknown.</caption>'), nl(Stream),
                   
                               write(Stream,'<tr>'),
                               print_html_rows(Stream,[],_,561,1140),
                               write(Stream,'</tr>'),
                               write(Stream,'</table>'), nl(Stream),
                               write(Stream,'</body>'), nl(Stream),
                               write(Stream,'</html>'), nl(Stream),
                               close(Stream).
 
/* ----------------------------------------------------------------- */

print_html_rows(Stream,L,L1,A,B) :- problem_setting(N,_,Known,_), N>=A, N=<B,
                                not_member(N,L),
                                !,
                                write(N), nl,
                                print_one_html_row(Stream,N,Known,A),
                                write_end_of_row_fifth(Stream,N),
                                print_html_rows(Stream,[N|L],L1,A,B).
print_html_rows(_,L,L,_,_).

/* ----------------------------------------------------------------- */

print_one_html_row(Stream,N,Known,A) :- write(Stream,'<td>'), 
                                    write(Stream, '<a href="construction_'), 
                                    four_digit_name(N,Name), write(Stream,Name), write(Stream,'.html" target="_blank">'),
                                    N1 is N-A+1, write(Stream,N1), write(Stream,'. '),
                                    write_list_html(Known,1,Stream),
                                    write(Stream,'</a>'),
                                    write(Stream,'&nbsp;&nbsp;&nbsp;<em>'),
                                    determine_status(N,Status),
                                    write(Stream,Status),
                                    write(Stream,'</em>'),
                                    write(Stream,'</td>'),
                                    nl(Stream).

/* ----------------------------------------------------------------- */

determine_status(N,'S (ns)') :- real_status(N,'solvable'), status_real(N,'u'), !. 
determine_status(N,'U') :- real_status(N,'unsolvable'), !.
determine_status(N,'UK') :- real_status(N,'unknown'), !.  
determine_status(N,'S (s)') :- status_real(N,'s'), !.
determine_status(N,Status) :- status_real(N,StatusL), char_type(Status,to_upper(StatusL)).


/* ----------------------------------------------------------------- */

write_end_of_row_fifth(Stream,N) :- N rem 5 =:= 0, write(Stream,'</tr>'), nl(Stream), write(Stream,'<tr>'),!.
write_end_of_row_fifth(_,_).

/* ----------------------------------------------------------------- */

generate_html_table_compendiums :- assert(miniversion), init,
                               open('compendiums.html',write,Stream),
                               write(Stream,'<!DOCTYPE html>'), nl(Stream),
                               write(Stream,'<html>'), nl(Stream),
                               write(Stream,'<head>'), nl(Stream),
                               write(Stream,'<title>'), nl(Stream),
                               write(Stream,'On-line compendiums of construction problems from Wernick\'s and Connelly\'s corpora'),
                               write(Stream,'</title>'), nl(Stream),
                               write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),
                               write(Stream,'</head>'), nl(Stream),

                               write(Stream,'<body>'), nl(Stream),
                               write(Stream,'<h2>'), nl(Stream),

                               write(Stream,'On-line compendiums of triangle location construction problems'),
                               write(Stream,'</h2>'), nl(Stream),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'Triangle location construction problems are construction problems in which the task is to construct a triangle ABC, using straightedge and compass, given positions of three characteristic points of the triangle. '),
                               write(Stream,'In 1982. William Wernick presented a list of triangle location problems where three characteristic points are selected among the following 16 points:'),
                               write(Stream,'<ul>'), nl(Stream),
                               write(Stream,'<li>A, B, C, O: three vertices and circumcenter;</li>'), nl(Stream),
                               write(Stream,'<li>M<sub>a</sub>, M<sub>b</sub>, M<sub>c</sub>, G: the side midpoints and centroid;</li>'), nl(Stream),
                               write(Stream,'<li>H<sub>a</sub>, H<sub>b</sub>, H<sub>c</sub>, H: three feet of altitudes and orthocenter;</li>'), nl(Stream),
                               write(Stream,'<li>T<sub>a</sub>, T<sub>b</sub>, T<sub>c</sub>, I: three feet of the internal angle bisectors and incenter.</li>'), nl(Stream),
                               write(Stream,'</ul>'), nl(Stream),
                               write(Stream,'Wernick\'s list consists of 139 significantly different problems, and today statuses of all problems from Wernick\'s list are known: there are 74 solvable problems, 39 unsolvable problems, 3 redundant problems and 23 locus dependent problems.'),
                               nl(Stream),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'Harold Connelly considered an extended Wernick\'s list, involving four additional points:'), 
                               nl(Stream),
                               write(Stream,'<ul>'), nl(Stream),
                               write(Stream,'<li>E<sub>a</sub>, E<sub>b</sub>, E<sub>c</sub>: three Euler points;</li>'), nl(Stream),
                               write(Stream,'<li>N: the center of nine point circle.</li>'), nl(Stream),
                               write(Stream,'</ul>'), nl(Stream),
                               write(Stream,'Current status of problems from Connelly\'s list is the following: there are 73 solvable problems, 11 unsolvable problems, 5 redundant problems, 19 locus dependent problems and 32 problems with unknown status.'), 
                               nl(Stream),
                               write(Stream,'<img class="svg" src="definitions.svg" alt="Image of significant points">'),
                               nl(Stream),

                               write(Stream,'<h3>Generated compendiums</h3>'), nl(Stream),
                               write(Stream,'<a href="compendium_wernick.html" target="_blank">'), 
                               write(Stream,'Compendium of solutions to problems from extended Wernick\'s corpus'),
                               write(Stream,'</a>'),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'<a href="compendium_connelly.html" target="_blank">'), 
                               write(Stream,'Compendium of solutions to problems from extended Connelly\'s corpus'),
                               write(Stream,'</a>'),
                               write(Stream,'<br>'),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'<h3>Bibliography</h3>'), nl(Stream),
                               write(Stream,'<ol>'), nl(Stream),
                               write(Stream,'<li>William Wernick, <a href="http://hydra.nat.uni-magdeburg.de/wernick/pdf/wernick_orig.pdf">Triangle Constructions with Three Located Points</a>, Mathematics Magazine 55, no. 4, 1982. </li>'), nl(Stream),
                               write(Stream,'<li>Harold Connelly, <a href="http://forumgeom.fau.edu/FG2009volume9/FG200909.pdf">An Extension of Triangle Constructions from Located Points</a>, Forum Geometricorum 9, 2009.</li>'), nl(Stream),
                               write(Stream,'<li>Vesna Marinkovic, Predrag Janicic, <a href="http://argo.matf.bg.ac.rs/publications/2012/ConstructionProblems.pdf">Towards Understanding Triangle Construction Problems</a>, Intelligent Computer Mathematics - CICM 2012. Lecture Notes in Computer Science, vol. 7362, Springer, 2012. </li>'), nl(Stream),
                               write(Stream,'<li>Vesna Marinkovic, Pascal Schreck, Predrag Janicic, <a href="http://argo.matf.bg.ac.rs/publications/2014/ATPforConstructions.pdf">Computer Theorem Proving for Verifiable Solving of Geometric Construction Problems</a>, Automated Deduction in Geometry 2014, LNCS 9201, Springer, 2015.</li>'), nl(Stream),
                               write(Stream,'<li>Vesna Marinkovic, ArgoTriCS - Automated Triangle Construction Solver, submitted.</li>'), nl(Stream),
                  
                               write(Stream,'</ol>'), nl(Stream),
                               
                               write(Stream,'<p class="desno"><a href="ArgoTriCSAnimations.zip" target="_blank">System for automated solving construction problems ArgoTriCS</a></p>'), 
                               nl(Stream), nl(Stream),
                               write(Stream,'<hr>'), nl(Stream),
                               write(Stream,'<br>'), nl(Stream),
                               write(Stream,'<a href="mailto:vesnap@poincare.matf.bg.ac.rs" target="_blank">Vesna Marinkovic</a>, '),
                               write(Stream,'<a href="http://www.matf.bg.ac.rs/~vesnap" target="_blank">The Faculty of Mathematics, University of Belgrade</a>'),
                               nl(Stream),
                               write(Stream,'</body>'), nl(Stream),
                               write(Stream,'</html>'), nl(Stream),
                               close(Stream).
 
