
:- dynamic(derived_lemma/2).
:- discontiguous(basic_lemma/2).

/******************************************************************/
/* BASIC LEMMAS */
/******************************************************************/

basic_lemma(inc(circumcenter([a,b],c),side_bis([a,b])),'L1').

/* ----------------------------------------------------------------- */

basic_lemma(inc(incenter([a,b],c),angle_bis(c,[a,b])),'L2').

/* ----------------------------------------------------------------- */

basic_lemma(inc(orthocenter([a,b],c),altitude(c,[a,b])),'L3').

/* ----------------------------------------------------------------- */

basic_lemma(inc(centroid([a,b],c),median(c,[a,b])),'L4').                       

/* ----------------------------------------------------------------- */

basic_lemma(inc(a,angle_bis(a,[b,c])),'L5').
basic_lemma(inc(b,angle_bis(b,[a,c])),'L6').
basic_lemma(inc(c,angle_bis(c,[a,b])),'L7').
basic_lemma(eq_dist(angle_bis_foot(a,[b,c]),line([a,b]),angle_bis_foot(a,[b,c]),line([a,c])),'L8').
basic_lemma(eq_dist(angle_bis_foot(b,[a,c]),line([a,b]),angle_bis_foot(b,[a,c]),line([b,c])),'L9').
basic_lemma(eq_dist(angle_bis_foot(c,[a,b]),line([a,c]),angle_bis_foot(c,[a,b]),line([b,c])),'L10').

/* ----------------------------------------------------------------- */

basic_lemma(inc_k(a,circumcircle([a,b],c)),'L11').
basic_lemma(inc_k(b,circumcircle([a,b],c)),'L12').

/* ----------------------------------------------------------------- */

basic_lemma(inc_k(foot(incenter([a,b],c),[a,c]),incircle([a,b],c)),'L13').      
basic_lemma(inc_k(foot(incenter([a,b],c),[a,b]),incircle([a,b],c)),'L14').

/* ----------------------------------------------------------------- */

/* dodajemo samo za Konelijev korpus */
/*
basic_lemma(sratio(npcenter([a,b],c),centroid([a,b],c),
                   npcenter([a,b],c),circumcenter([a,b],c),1,3),'L15').
basic_lemma(sratio(orthocenter([a,b],c),npcenter([a,b],c),
                   orthocenter([a,b],c),centroid([a,b],c),3,4),'L16').
*/

/* ----------------------------------------------------------------- */

/* dodajemo samo za Konelijev korpus */
/*
basic_lemma(inc_k(midpoint([a,c]),npcircle([a,b],c)),'L17').
basic_lemma(inc_k(midpoint([a,b]),npcircle([a,b],c)),'L18').
basic_lemma(inc_k(foot(a,[b,c]),npcircle([a,b],c)),'L19').
basic_lemma(inc_k(foot(b,[a,c]),npcircle([a,b],c)),'L20').
basic_lemma(inc_k(foot(c,[a,b]),npcircle([a,b],c)),'L21').
basic_lemma(inc_k(euler(a,[b,c]),npcircle([a,b],c)),'L22').
basic_lemma(inc_k(euler(b,[a,c]),npcircle([a,b],c)),'L23').
basic_lemma(inc_k(euler(c,[a,b]),npcircle([a,b],c)),'L24').
*/
/* ----------------------------------------------------------------- */

basic_lemma(inc(point_n(a,[b,c]),side_bis([b,c])),'L25').
basic_lemma(inc(point_n(b,[a,c]),side_bis([a,c])),'L26').
basic_lemma(inc(point_n(c,[a,b]),side_bis([a,b])),'L27').

/* ----------------------------------------------------------------- */

/* circle with the center in point Ta is tangent to sides AB and AC */
basic_lemma(inc_k(foot(angle_bis_foot(a,[b,c]),line([a,c])),
           circle_center_through(angle_bis_foot(a,[b,c]),foot(angle_bis_foot(a,[b,c]),line([a,b])))),'L28').

basic_lemma(inc_k(foot(angle_bis_foot(b,[a,c]),line([b,c])),
           circle_center_through(angle_bis_foot(b,[a,c]),foot(angle_bis_foot(b,[a,c]),line([a,b])))),'L29').

basic_lemma(inc_k(foot(angle_bis_foot(c,[a,b]),line([b,c])),
           circle_center_through(angle_bis_foot(c,[a,b]),foot(angle_bis_foot(c,[a,b]),line([a,c])))),'L30').

/* ----------------------------------------------------------------- */

/* points B, I belong to the circle with center Na through point C */
basic_lemma(inc_k(b,circle_center_through(point_n(a,[b,c]),c)),'L31').
basic_lemma(inc_k(incenter([a,b],c),circle_center_through(point_n(a,[b,c]),c)),'L32').

basic_lemma(inc_k(c,circle_center_through(point_n(b,[a,c]),a)),'L33').
basic_lemma(inc_k(incenter([a,b],c),circle_center_through(point_n(b,[a,c]),a)),'L34').

basic_lemma(inc_k(a,circle_center_through(point_n(c,[a,b]),b)),'L35').
basic_lemma(inc_k(incenter([a,b],c),circle_center_through(point_n(c,[a,b]),b)),'L36').

/* ----------------------------------------------------------------- */

/* points C, Hb, Hc belong to the circle with center Ma through point B */
basic_lemma(inc_k(c,circle_center_through(midpoint([b,c]),b)),'L37').
basic_lemma(inc_k(foot(b,[a,c]),circle_center_through(midpoint([b,c]),b)),'L38').
basic_lemma(inc_k(foot(c,[a,b]),circle_center_through(midpoint([b,c]),b)),'L39').

/* points B, Ha, Hb belong to the circle with center Mc through point A */
basic_lemma(inc_k(b,circle_center_through(midpoint([a,b]),a)),'L40').
basic_lemma(inc_k(foot(b,[a,c]),circle_center_through(midpoint([a,b]),a)),'L41').
basic_lemma(inc_k(foot(a,[b,c]),circle_center_through(midpoint([a,b]),a)),'L42').

/* points A, Ha, Hc belong to the circle with center Mb through point C */
basic_lemma(inc_k(a,circle_center_through(midpoint([a,c]),c)),'L43').
basic_lemma(inc_k(foot(a,[b,c]),circle_center_through(midpoint([a,c]),c)),'L44').
basic_lemma(inc_k(foot(c,[a,b]),circle_center_through(midpoint([a,c]),c)),'L45').

/* ----------------------------------------------------------------- */

/* H, Hb, Hc belong to the circle with center Ea through vertex A 
  (since triangle AHHb has a right angle, 
  and Ea is a midpoint of the hypotenuse) */
/* dodajemo samo za Konelijev korpus */
/*
basic_lemma(inc_k(orthocenter([a,b],c),circle_center_through(euler(a,[b,c]),a)),'L46').
basic_lemma(inc_k(foot(b,[a,c]),circle_center_through(euler(a,[b,c]),a)),'L47').
basic_lemma(inc_k(foot(c,[a,b]),circle_center_through(euler(a,[b,c]),a)),'L48').

basic_lemma(inc_k(orthocenter([a,b],c),circle_center_through(euler(b,[a,c]),b)),'L49').
basic_lemma(inc_k(foot(a,[b,c]),circle_center_through(euler(b,[a,c]),b)),'L50').
basic_lemma(inc_k(foot(c,[a,b]),circle_center_through(euler(b,[a,c]),b)),'L51').

basic_lemma(inc_k(orthocenter([a,b],c),circle_center_through(euler(c,[a,b]),c)),'L52').
basic_lemma(inc_k(foot(b,[a,c]),circle_center_through(euler(c,[a,b]),c)),'L53').
basic_lemma(inc_k(foot(a,[b,c]),circle_center_through(euler(c,[a,b]),c)),'L54').
*/

/******************************************************************/
/* ADVANCED LEMMAS */
/******************************************************************/

/* AT:AM_a=2:3, BT:BM_b=2:3, CT:CM_c=2:3 */						
basic_lemma(sratio(a,centroid([a,b],c),a,midpoint([b,c]),2,3),'L55').
basic_lemma(sratio(b,centroid([a,b],c),b,midpoint([a,c]),2,3),'L56').
basic_lemma(sratio(c,centroid([a,b],c),c,midpoint([a,b]),2,3),'L57').

/* ----------------------------------------------------------------- */

/* HG:HO=2:3 */
basic_lemma(sratio(orthocenter([a,b],c),centroid([a,b],c),
                   orthocenter([a,b],c),circumcenter([a,b],c),2,3),'L58').

/* ----------------------------------------------------------------- */

/* sides of the triangle are perpendicular to the incircle */
basic_lemma(perp_line_to_circ(line([a,b]),incircle([a,b],c)),'L59').
basic_lemma(perp_line_to_circ(line([b,c]),incircle([a,b],c)),'L60').
basic_lemma(perp_line_to_circ(line([a,c]),incircle([a,b],c)),'L61').

/* ----------------------------------------------------------------- */

/* PaMa=1/2MaPa', Pa' is the foot of the center of the outer circumcircle of the triangle ABC on the side BC */
basic_lemma(sratio(foot(incenter([a,b],c),[b,c]),midpoint([b,c]),
                   foot(incenter([a,b],c),[b,c]),foot(outcenter(a,[b,c]),[b,c]),1,2),'L62').
basic_lemma(sratio(foot(incenter([a,b],c),[a,c]),midpoint([a,c]),
                   foot(incenter([a,b],c),[a,c]),foot(outcenter(b,[a,c]),[a,c]),1,2),'L63').
basic_lemma(sratio(foot(incenter([a,b],c),[a,b]),midpoint([a,b]),
                   foot(incenter([a,b],c),[a,b]),foot(outcenter(c,[a,b]),[a,b]),1,2),'L64').

/* ----------------------------------------------------------------- */

/* IMa || APa' */                                                                                                
basic_lemma(parallel(line([incenter([a,b],c),midpoint([b,c])]),line([a,foot(outcenter(a,[b,c]),[b,c])])),'L65').                            
basic_lemma(parallel(line([incenter([a,b],c),midpoint([a,c])]),line([b,foot(outcenter(b,[a,c]),[a,c])])),'L66').
basic_lemma(parallel(line([incenter([a,b],c),midpoint([a,b])]),line([c,foot(outcenter(c,[a,b]),[a,b])])),'L67').

/* ----------------------------------------------------------------- */

/* MaMb || AB' */                                                                                                
basic_lemma(parallel(line([midpoint([a,b]),midpoint([a,c])]),line([b,c])),'L68').                                 
basic_lemma(parallel(line([midpoint([a,b]),midpoint([b,c])]),line([a,c])),'L69').   
basic_lemma(parallel(line([midpoint([a,c]),midpoint([b,c])]),line([a,b])),'L70').                          

/* ----------------------------------------------------------------- */

/* A belongs to the circle with diameter TaTa` */                   
basic_lemma(inc_k(a,diam(angle_bis_foot(a,[b,c]),angle_bis_out_foot(a,[b,c]))),'L71').        
basic_lemma(inc_k(c,diam(angle_bis_foot(c,[a,b]),angle_bis_out_foot(c,[a,b]))),'L72').        
basic_lemma(inc_k(b,diam(angle_bis_foot(b,[a,c]),angle_bis_out_foot(b,[a,c]))),'L73').

/* ----------------------------------------------------------------- */

/* Pa belongs to the circle with diameter IMa */
basic_lemma(inc_k(foot(incenter([a,b],c),[b,c]),diam(incenter([a,b],c),midpoint([b,c]))),'L74').
basic_lemma(inc_k(foot(incenter([a,b],c),[a,c]),diam(incenter([a,b],c),midpoint([a,c]))),'L75').
basic_lemma(inc_k(foot(incenter([a,b],c),[a,b]),diam(incenter([a,b],c),midpoint([a,b]))),'L76').

/* ----------------------------------------------------------------- */

/* H(B,C,Ta,Ta`) */                                                                      
basic_lemma(harm(b,c,angle_bis_foot(a,[b,c]),angle_bis_out_foot(a,[b,c])),'L77').             
basic_lemma(harm(a,c,angle_bis_foot(b,[a,c]),angle_bis_out_foot(b,[a,c])),'L78').             
basic_lemma(harm(a,b,angle_bis_foot(c,[a,b]),angle_bis_out_foot(c,[a,b])),'L79').             

/* ----------------------------------------------------------------- */

/* IZMENI!!! - sve ovo naredno bi moralo nekako genericki da se uradi
   mada ako bih radila za svake dve prave koje se seku i grade neki ugao i za njihovu presecnu tacku
   + proizvoljne dve tacke sa ovih pravih - bice previse lema? */

/* ovo treba za 126 zadatak */
basic_lemma(inc_k(a,over_chord([angle_bis_foot(a,[b,c]),foot(b,[a,c])],angle(angle_bis(a,[b,c]),line([a,c])))),'L80').
basic_lemma(inc_k(a,over_chord([angle_bis_foot(a,[b,c]),foot(c,[a,b])],angle(line([a,b]),angle_bis(a,[b,c])))),'L81').
basic_lemma(inc_k(b,over_chord([angle_bis_foot(b,[a,c]),foot(c,[a,b])],angle(angle_bis(b,[a,c]),line([a,b])))),'L82').
basic_lemma(inc_k(b,over_chord([angle_bis_foot(b,[a,c]),foot(a,[b,c])],angle(line([b,c]),angle_bis(b,[a,c])))),'L83').
basic_lemma(inc_k(c,over_chord([angle_bis_foot(c,[a,b]),foot(a,[b,c])],angle(angle_bis(c,[a,b]),line([b,c])))),'L84').
basic_lemma(inc_k(c,over_chord([angle_bis_foot(c,[a,b]),foot(b,[a,c])],angle(line([a,c]),angle_bis(c,[a,b])))),'L85').

/* ----------------------------------------------------------------- */

/* Angle TcSTb has a size alpha/2+pi/2 */
basic_lemma(inc_k(incenter([a,b],c),over_chord([angle_bis_foot(b,[a,c]),angle_bis_foot(c,[a,b])],
                                                angle(angle_bis(b,[a,c]),angle_bis(c,[a,b])))),'L86').
basic_lemma(inc_k(incenter([a,b],c),over_chord([angle_bis_foot(a,[b,c]),angle_bis_foot(b,[a,c])],
                                                angle(angle_bis(a,[b,c]),angle_bis(b,[a,c])))),'L87').
/*
basic_lemma(inc_k(incenter([a,b],c),over_chord([angle_bis_foot(b,[a,c]),angle_bis_foot(a,[b,c])],
                                                angle(angle_bis(b,[a,c]),angle_bis(a,[b,c])))),'L87').
*/
/*basic_lemma(inc_k(incenter([a,b],c),over_chord([angle_bis_foot(a,[b,c]),angle_bis_foot(c,[a,b])],
                                                angle(angle_bis(a,[b,c]),angle_bis(c,[a,b])))),'L88').
*/
basic_lemma(inc_k(incenter([a,b],c),over_chord([angle_bis_foot(c,[a,b]),angle_bis_foot(a,[b,c])],
                                                angle(angle_bis(c,[a,b]),angle_bis(a,[b,c])))),'L88').

/* ----------------------------------------------------------------- */

/* ovo treba za 139. zadatak */
basic_lemma(inc_k(a,over_chord([angle_bis_foot(b,[a,c]),angle_bis_foot(c,[a,b])],angle(line([a,b]),line([a,c])))),'L89').
basic_lemma(inc_k(b,over_chord([angle_bis_foot(c,[a,b]),angle_bis_foot(a,[b,c])],angle(line([b,c]),line([a,b])))),'L90').
basic_lemma(inc_k(c,over_chord([angle_bis_foot(a,[b,c]),angle_bis_foot(b,[a,c])],angle(line([a,c]),line([b,c])))),'L91').

/* ----------------------------------------------------------------- */

basic_lemma(inc_k(a,over_chord([angle_bis_foot(b,[a,c]),incenter([a,b],c)],angle(line([a,c]),angle_bis(a,[b,c])))),'L92').
basic_lemma(inc_k(a,over_chord([angle_bis_foot(c,[a,b]),incenter([a,b],c)],angle(line([a,b]),angle_bis(a,[b,c])))),'L93').
basic_lemma(inc_k(b,over_chord([angle_bis_foot(a,[b,c]),incenter([a,b],c)],angle(line([b,c]),angle_bis(b,[a,c])))),'L94').
basic_lemma(inc_k(b,over_chord([angle_bis_foot(c,[a,b]),incenter([a,b],c)],angle(line([a,b]),angle_bis(b,[a,c])))),'L95').
basic_lemma(inc_k(c,over_chord([angle_bis_foot(b,[a,c]),incenter([a,b],c)],angle(line([a,c]),angle_bis(c,[a,b])))),'L96').
basic_lemma(inc_k(c,over_chord([angle_bis_foot(a,[b,c]),incenter([a,b],c)],angle(line([b,c]),angle_bis(c,[a,b])))),'L97').

/* ----------------------------------------------------------------- */

/* all angles in the triangle are double in size of their halves */
basic_lemma(eq_angle_compound(angle(line([a,b]),angle_bis(a,[b,c])),
                              angle(line([a,b]),line([a,c])),1,1,0,0),'L98').
basic_lemma(eq_angle_compound(angle(angle_bis(a,[b,c]),line([a,c])),
                              angle(line([a,b]),line([a,c])),1,1,0,0),'L99').

basic_lemma(eq_angle_compound(angle(line([b,c]),angle_bis(b,[a,c])),
                              angle(line([b,c]),line([a,b])),1,1,0,0),'L100').
basic_lemma(eq_angle_compound(angle(angle_bis(b,[a,c]),line([a,b])),
                              angle(line([b,c]),line([a,b])),1,1,0,0),'L101').

basic_lemma(eq_angle_compound(angle(line([a,c]),angle_bis(c,[a,b])),
                              angle(line([a,c]),line([b,c])),1,1,0,0),'L102').
basic_lemma(eq_angle_compound(angle(angle_bis(c,[a,b]),line([b,c])),
                              angle(line([a,c]),line([b,c])),1,1,0,0),'L103').

/* ----------------------------------------------------------------- */

/* The angle between the altitude AH and the angle bisector AI 
  is equal to the angle between the angle bisector AI and AO */
basic_lemma(eq_angle_compound(angle(altitude(a,[b,c]),angle_bis(a,[b,c])),
                              angle(angle_bis(a,[b,c]),
                                    line([a,circumcenter([a,b],c)])),1,0,0,0),'L104').
basic_lemma(eq_angle_compound(angle(altitude(b,[a,c]),angle_bis(b,[a,c])),
                              angle(angle_bis(b,[a,c]),
                                    line([b,circumcenter([a,b],c)])),1,0,0,0),'L105').
basic_lemma(eq_angle_compound(angle(altitude(c,[a,b]),angle_bis(c,[a,b])),
                              angle(angle_bis(c,[a,b]),
                                    line([c,circumcenter([a,b],c)])),1,0,0,0),'L106').

/* ----------------------------------------------------------------- */

/* The angle HbHaC is equal to the angle alpha in the triangle */
basic_lemma(eq_angle_compound(angle(line([b,c]),line([foot(a,[b,c]),foot(b,[a,c])])),
                              angle(line([a,b]),line([a,c])),1,0,0,0),'L107').
basic_lemma(eq_angle_compound(angle(line([a,c]),line([foot(b,[a,c]),foot(c,[a,b])])),
                              angle(line([b,c]),line([a,b])),1,0,0,0),'L108').
basic_lemma(eq_angle_compound(angle(line([a,b]),line([foot(c,[a,b]),foot(a,[b,c])])),
                              angle(line([a,c]),line([b,c])),1,0,0,0),'L109').


/* ----------------------------------------------------------------- */

/* The angle TbITc is equal to the angle alpha/2 + pi/2 */
basic_lemma(eq_angle_compound(angle(angle_bis(b,[a,c]),angle_bis(c,[a,b])),
                              angle(line([a,b]),line([a,c])),1,1,1,1),'L110').
basic_lemma(eq_angle_compound(angle(angle_bis(c,[a,b]),angle_bis(a,[b,c])),
                              angle(line([b,c]),line([a,b])),1,1,1,1),'L111').
basic_lemma(eq_angle_compound(angle(angle_bis(a,[b,c]),angle_bis(b,[a,c])),
                              angle(line([a,c]),line([b,c])),1,1,1,1),'L112').

/* ----------------------------------------------------------------- */

/* AH is the bisector of the angle HbHaHc */
basic_lemma(eq_angle_compound(angle(line([foot(a,[b,c]),foot(b,[a,c])]),
                                    altitude(a,[b,c])),
                              angle(line([foot(a,[b,c]),foot(b,[a,c])]),
                                    line([foot(c,[a,b]),foot(a,[b,c])])),1,1,0,0),'L113').

basic_lemma(eq_angle_compound(angle(line([foot(b,[a,c]),foot(c,[a,b])]),
                                    altitude(b,[a,c])),
                              angle(line([foot(b,[a,c]),foot(c,[a,b])]),
                                    line([foot(a,[b,c]),foot(b,[a,c])])),1,1,0,0),'L114').

basic_lemma(eq_angle_compound(angle(line([foot(c,[a,b]),foot(a,[b,c])]),
                                    altitude(c,[a,b])),
                              angle(line([foot(c,[a,b]),foot(a,[b,c])]),
                                    line([foot(b,[a,c]),foot(c,[a,b])])),1,1,0,0),'L115').

/* ----------------------------------------------------------------- */

/* AHa||PPaMa, from the paper "An Angle Bisector Parallel Applied to Triangle Construction", Connelly */
/* dodajemo samo za Konelijev korpus */
/*
basic_lemma(parallel(angle_bis(a,[b,c]),line([midpoint([b,c]),point_p(a,[b,c])])),'L116').
basic_lemma(parallel(angle_bis(b,[a,c]),line([midpoint([a,c]),point_p(b,[a,c])])),'L117').
basic_lemma(parallel(angle_bis(c,[a,b]),line([midpoint([a,b]),point_p(c,[a,b])])),'L118').
*/

/* ----------------------------------------------------------------- */

/* npcircle and incircle are touching inside */
/* nije simetrican predikat jer je upisani unutar ojlerovog kruga */
/* dodajemo samo za Konelijev korpus */
/*
basic_lemma(perp_circ_int(npcircle([a,b],c),incircle([a,b],c)),'L119').
*/

/* ----------------------------------------------------------------- */

/* dodatak na 107,108 i 109 */
basic_lemma(eq_angle_compound(angle(line([foot(a,[b,c]),foot(b,[a,c])]),line([a,c])),
                              angle(line([b,c]),line([a,b])),1,0,0,0),'L120').
basic_lemma(eq_angle_compound(angle(line([foot(b,[a,c]),foot(c,[a,b])]),line([a,b])),
                              angle(line([a,c]),line([b,c])),1,0,0,0),'L121').
basic_lemma(eq_angle_compound(angle(line([foot(c,[a,b]),foot(a,[b,c])]),line([b,c])),
                              angle(line([a,b]),line([a,c])),1,0,0,0),'L122').


/******************************************************************/
/* LEMMAS WITH PRECONDITION */
/******************************************************************/

/* Lemmas of the form:
   general_lemma(PreCond,Concl,EvalExp,RelObjs,LemmaId).
   where:
   PreCond is a set of preconditions
   Concl is a conclusion which follows from preconditions
   EvalExp are expressions to be evaluated, given in a pair form
   RelObjs is a set of objects that should be relevant
   LemmaId is id of a lemma
*/

/* ----------------------------------------------------------------- */

/* center of a circle belongs to the bisector of an arbitrary chord */
general_lemma([inc_k(X,C),inc_k(Y,C),not_eq_point(X,Y),center(O,C)], inc(O,side_bis([X,Y])),
              [],[],'GL01').

/* ----------------------------------------------------------------- */

general_lemma([sratio(X,Y,X,Z,K,L),inc(Z,P),not_true(inc(Y,P))], 
              inc(X,homothety(Y,P,K1,L1)), [(K1,K),(L1,K-L)], [obj(line,P)],'GL02'). 

/* ----------------------------------------------------------------- */


general_lemma([sratio(X,Y,Z,W,K,L)], sratio(Z,W,X,Y,K1,L1),[(K1,L),(L1,K)],[],'GL03').
general_lemma([sratio(X,Y,X,W,K,L)], sratio(W,Y,W,X,K1,L1), [(K1,L-K),(L1,L)],[],'GL04').


/* ----------------------------------------------------------------- */

/* permutation for harmonic conjugation */
general_lemma([harm(A,B,C,D)], harm(B,A,D,C),[],[],'GL05').
general_lemma([harm(A,B,C,D)], harm(C,D,A,B),[],[],'GL06').
general_lemma([harm(A,B,C,D)], harm(D,C,B,A),[],[],'GL07').

/* ----------------------------------------------------------------- */

/* !!! ovo je bitno svojstvo jer nam daje neke nove paralelnosti (primer za clanak) */
/* if two points are located on two sides of triangle at the same ratio, 
   then the segment they determine is parallel to the side of the triangle */
general_lemma([sratio(X,Y,X,Z,A,B),sratio(X,U,X,V,A,B),not_eq_point(Y,U), 
               inc(Y,P),inc(U,P),inc(Z,Q),inc(V,Q),not_parallel(P,Q)], 
              parallel(P,Q),[],[],'GL08').

/* ----------------------------------------------------------------- */

general_lemma([sratio(A,X,A,B,_,_), inc(A,P), inc(B,P)], inc(X,P),[],[],'GL09').

/* ----------------------------------------------------------------- */

/* if the distance of one point is equal to two different lines, 
   then they are tangent to the circle with a center at this point */
general_lemma([eq_dist(X,P,X,_)], perp_line_to_circ(P,circle_center_through(X,foot(X,P))),[],[],'GL10').
general_lemma([eq_dist(X,P,X,Q)], perp_line_to_circ(Q,circle_center_through(X,foot(X,P))),[],[],'GL11').

/* ----------------------------------------------------------------- */

/* if alpha = beta, and eq_angle_compound(gamma,beta,A,B,C,D) then eq_angle_compound(gamma,alpha,A,B,C,D) */
general_lemma([eq_angle_compound(A,B,1,L1,0,0), eq_angle_compound(C,B,K1,K2,K3,K4), not_eq_point(A,C)], 
               eq_angle_compound(C,A,K1,V1,K3,K4),[(V1,K2-L1)],[],'GL12').
general_lemma([eq_angle_compound(A,B,1,L1,0,0), eq_angle_compound(B,C,K1,K2,K3,K4), not_eq_point(A,C)],  
               eq_angle_compound(A,C,K1,V1,K3,V2),[(V1,K2+L1),(V2,K4+L1)],[],'GL13').
general_lemma([eq_angle_compound(A,B,1,L1,0,0), eq_angle_compound(C,A,K1,K2,K3,K4), not_eq_point(C,B)], 
               eq_angle_compound(C,B,K1,V1,K3,K4),[(V1,K2+L1)],[],'GL14').
general_lemma([eq_angle_compound(A,B,1,L1,0,0), eq_angle_compound(A,C,K1,K2,K3,K4), not_eq_point(B,C)], 
               eq_angle_compound(B,C,K1,V1,K3,V2),[(V1,K2-L1),(V2,K4-L1)],[],'GL15').

/* ----------------------------------------------------------------- */

/* if a point X belongs to a circle C, and XY/XZ=K/L
   then point Y belongs to the image by a homothety of circle C with center Z and coeff (L-K)/L */
general_lemma([sratio(X,Y,X,Z,K,L),inc_k(X,C),not_true(inc_k(Z,C))], 
              inc_k(Y,homothety_circ(Z,C,K1,L)), [(K1,L-K)], [obj(circle,C)], 'GL16').

/* ----------------------------------------------------------------- */

/* if eq_angle_compound(alpha,beta,1,0,0,0) then eq_angle_compound(beta,alpha,1,0,0,0) */
general_lemma([eq_angle_compound(A,B,1,0,0,0)], 
               eq_angle_compound(B,A,1,0,0,0),[],[],'GL17').
/* if eq_angle_compound(alpha,beta,1,1,0,0) then eq_angle_compound(beta,alpha,2,0,0,0) */
general_lemma([eq_angle_compound(A,B,1,1,0,0)], 
               eq_angle_compound(B,A,2,0,0,0),[],[],'GL18').
/* if eq_angle_compound(alpha,beta,1,1,1,0) then eq_angle_compound(beta,alpha,2,0,-2,0) */
general_lemma([eq_angle_compound(A,B,1,1,1,0)], 
               eq_angle_compound(B,A,2,0,-2,0),[],[],'GL19').
/* if eq_angle_compound(alpha,beta,1,1,1,1) then eq_angle_compound(beta,alpha,2,0,-1,0) */
general_lemma([eq_angle_compound(A,B,1,1,1,1)], 
               eq_angle_compound(B,A,2,0,-1,0),[],[],'GL20').
