
/* Construction rules of a form:
   basic_cons(Obj_known,Values,Obj_constr,Props,NDGs,DETs,RuleId).
   where:
   Obj_known are already constructed (known) objects,
   Values are values for which object are constructed,
   Obj_constr are objects which are constructed,
   Props are properties which are given as definitions or lemmas,
   NDGs are non-degenerate conditions,
   DETs are determination conditions,
   RuleId is a unique identifier of the construction rule  
*/


/* REDOSLED PRAVILA MORA DA ODGOVARA LEKSIKOGRAFSKOM PORETKU NAZIVA!!!!!!!!!!!!!!!!!!!!!!!!!!*/

basic_cons([obj(point,X), obj(point,Z), obj(point,W)], [obj(int,K), obj(int,L)], 
           [obj(point,Y)], 
           [sratio(X,Y,Z,W,K,L)], [], [], 'W01').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,X), obj(point,Y)], [], [obj(line,P)], 
           [not_eq_point(X,Y), inc(X,P), inc(Y,P)], [], 
           [not_true(identical_points(X,Y))], 'W02').

/* ----------------------------------------------------------------- */

basic_cons([obj(line,P), obj(line,Q)], [], [obj(point,A)], 
           [not_eq_line(P,Q), inc(A,P), inc(A,Q)], [not_parallel(P,Q)], 
           [not_true(identical_lines(P,Q))], 'W03').

/* ----------------------------------------------------------------- */


basic_cons([obj(circle,C), obj(line,P)], [], [obj(point,A), obj(point,B)], 
           [inc_k(A,C), inc_k(B,C), not_eq_point(A,B), inc(A,P), inc(B,P)], 
           [intersect_line_circle(P,C)], [], 'W04').

/* podeljeno na dva pravila zbog konstrukcije u GCLC-u */
basic_cons([obj(circle,C), obj(line,P), obj(point,O), obj(point,A)], [], 
           [obj(point,B)], 
           [center(O,C), inc_k(A,C), inc_k(B,C), not_eq_point(A,B), 
            inc(A,P), inc(B,P), not_true(inc(O,P))], 
           [intersect_line_circle(P,C)], [razlicite(A,B)], 'W05').

basic_cons([obj(circle,C), obj(line,P), obj(point,O), obj(point,A)], [], 
           [obj(point,B)], 
           [center(O,C), inc_k(A,C), inc_k(B,C), not_eq_point(A,B), 
            inc(A,P), inc(B,P), inc(O,P)], 
           [intersect_line_circle(P,C)], [razlicite(A,B)], 'W05a').

/* ----------------------------------------------------------------- */


basic_cons([obj(point,A), obj(point,O)], [], [obj(circle,C)],         
           [center(O,C), inc_k(A,C)], [not_true(identical_points(A,O))], [], 'W06').

/* ----------------------------------------------------------------- */


basic_cons([obj(circle,C1), obj(circle,C2)], [], [obj(point,A), obj(point,B)], 
           [not_eq_circle(C1,C2), inc_k(A,C1), inc_k(B,C1), 
            not_eq_point(A,B), inc_k(A,C2), inc_k(B,C2)], 
           [intersect_circle_circle(C1,C2)], 
           [not_true(identical_circles(C1,C2))], 'W07').
           
basic_cons([obj(circle,C1), obj(circle,C2), obj(point,A), obj(point,O1), obj(point,O2)], 
           [], [obj(point,B)], 
           [not_eq_circle(C1,C2), inc_k(A,C1), inc_k(A,C2), 
            inc_k(B,C1), not_eq_point(A,B), inc_k(B,C2),
            center(O1,C1), center(O2,C2)], 
           [intersect_circle_circle(C1,C2)], 
           [not_true(identical_circles(C1,C2)), razlicite(A,B)], 'W08').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(point,B)], [], [obj(circle,diam(A,B))],
           [not_eq_point(A,B)], [not_true(identical_points(A,B))], [], 'W09').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(line,P)], [], [obj(line,Q)], 
           [perp(P,Q), inc(A,Q)], [], [], 'W10a').


basic_cons([obj(point,A), obj(line,P)], [], [obj(line,Q)], 
           [perp(Q,P), inc(A,Q)], [], [], 'W10b').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(line,P)], [], [obj(circle,C)],
           [perp_line_to_circ(P,C), center(A,C)], 
           [not_true(inc(A,P))], [], 'W11').

/* ----------------------------------------------------------------- */

basic_cons([obj(circle,C), obj(point,A), obj(point,O)], [], 
           [obj(line,P), obj(line,Q)],
           [perp_line_to_circ(P,C), perp_line_to_circ(Q,C), not_eq_line(P,Q), 
            center(O,C), inc(A,P), inc(A,Q)], 
           [out_of_circle(A,C)], [], 'W12').

/* ----------------------------------------------------------------- */

basic_cons([obj(circle,C), obj(point,A), obj(point,O), obj(line,Q)], [], 
           [obj(line,P)],
           [perp_line_to_circ(P,C), perp_line_to_circ(Q,C), not_eq_line(P,Q), 
            center(O,C), inc(A,P), inc(A,Q)], 
           [out_of_circle(A,C)], [], 'W13').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(point,B)], [], [obj(line,side_bis([A,B]))],
           [], [], [not_true(identical_points(A,B))], 'W14').

/* ----------------------------------------------------------------- */


basic_cons([obj(point,A), obj(line,P), obj(point,X)], 
           [obj(int,K), obj(int,L)], [obj(line, homothety(A,P,K,L))], 
           [inc(X,P)], [], [], 'W15').


/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(line,P)], [], [obj(line,Q)],
           [inc(A,Q), parallel(P,Q)], [], [], 'W16').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,X), obj(point,Y), obj(line,W),
            obj(point,T1), obj(point,T2), obj(point,T3), obj(line,R), obj(line,P)], 
           [obj(int,A), obj(int,B), obj(int,C), obj(int,D)], 
           [obj(line,S)],
           [eq_angle_compound(angle(R,S),angle(P,W),A,B,C,D), not_eq_point(X,Y), inc(X,R), inc(X,S), 
            inc(Y,R), not_eq_point(T1,T2), not_eq_point(T2,T3), inc(T1,P), inc(T2,P), inc(T2,W), inc(T3,W)],
           [not_true(identical_points(T2,T3)),not_true(identical_points(T1,T2))], [not_true(identical_points(X,Y))], 'W17').


basic_cons([obj(line,S), obj(line,P), obj(line,Q), obj(point,X), obj(point,Y),
            obj(point,T1), obj(point,T2), obj(point,T3)], 
           [obj(int,A), obj(int,B), obj(int,C), obj(int,D)], 
           [obj(line,R)],
           [eq_angle_compound(angle(R,S),angle(P,Q),A,B,C,D), not_eq_point(X,Y), inc(X,R), inc(X,S), 
            inc(Y,S), not_eq_point(T1,T2), not_eq_point(T2,T3), inc(T1,P), inc(T2,P), inc(T2,Q), inc(T3,Q)],
           [not_true(identical_points(T1,T2)),not_true(identical_points(T2,T3))], [not_true(identical_points(X,Y))], 'W18').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(point,B), obj(point,C), 
            obj(line,P)], [], [obj(point,D)],
           [harm(A,B,C,D), inc(A,P), inc(B,P)], 
           [not_true(identical_points(A,B)),not_true(identical_points(B,C)),not_true(identical_points(B,midpoint([A,C])))], [], 'W19').

/* ----------------------------------------------------------------- */

basic_cons([obj(point,A), obj(point,B), obj(point,P1), obj(point,P2), obj(point,P3)], 
           [obj(int,K1), obj(int,K2), obj(int,K3), obj(int,K4)], 
           [obj(circle,over_chord([A,B],angle(P,Q)))], 
           [eq_angle_compound(angle(P,Q),angle(R,S),K1,K2,K3,K4),
           not_eq_point(P1,P2), not_eq_point(P1,P3), not_eq_point(P2,P3), inc(P1,R), inc(P2,R), inc(P2,S), inc(P3,S)], 
           [not_true(identical_points(P1,P2)),not_true(identical_points(P2,P3)),not_true(identical_points(A,B))], [], 'W20').

/* ----------------------------------------------------------------- */

/* dodajemo samo za Konelijev korpus */
/*
basic_cons([obj(point,A), obj(line,P)], [], [obj(point,foot(A,P))],
           [], [], [], 'W21').
*/

/* ----------------------------------------------------------------- */

/* dodajemo samo za Konelijev korpus */
/*
basic_cons([obj(point,A), obj(circle,B), obj(point,O), obj(point,X)], 
           [], [obj(circle,C)],
           [perp_circ_int(B,C), center(A,C), center(O,B), inc_k(X,B)], 
           [in_circle(A,B),not_true(identical_points(A,O))], [], 'W22').
*/

/* ----------------------------------------------------------------- */

/* dodajemo samo za Konelijev korpus */
/*
basic_cons([obj(point,A), obj(circle,C), obj(point,O), obj(point,X)], 
           [obj(int,K), obj(int,L)], 
           [obj(circle, homothety_circ(A,C,K,L))], 
           [center(O,C), inc_k(X,C)], [], [], 'W23').
*/

