:- dynamic(symmetric/1).

/* ----------------------------------------------------------------- */

/* sorting elements of the list */
quick_sort([],[]) :- !.
quick_sort([H|T],Sorted) :- pivoting(H,T,L1,L2),
                            quick_sort(L1,Sorted1),quick_sort(L2,Sorted2),
                            append(Sorted1,[H|Sorted2],Sorted).
   
pivoting(_,[],[],[]) :- !.
pivoting(H,[X|T],[X|L],G) :- X@=<H, !, pivoting(H,T,L,G).
pivoting(H,[X|T],L,[X|G]) :- X@>H, pivoting(H,T,L,G).

/* ----------------------------------------------------------------- */

/* depth of a term */
term_depth(T,0) :- var(T), !.
term_depth(T,0) :- number(T), !.
term_depth(T,0) :- atom(T), !.
term_depth(T,N) :- compound(T), functor(T,F,M), F='.', !,
                   calculate_max_term_depth(T,M,N).
term_depth(T,N) :- compound(T), functor(T,F,M), F='foot', !,
                   calculate_max_term_depth(T,M,N). /* foot ne racunamo u slozenost */
term_depth(T,N) :- compound(T), functor(T,F,M), F='outcenter', !,
                   calculate_max_term_depth(T,M,N). /* outcenter ne racunamo u slozenost */
term_depth(T,N) :- compound(T), functor(T,F,M), F='incenter', !,
                   calculate_max_term_depth(T,M,N). /* incenter ne racunamo u slozenost */
term_depth(T,N) :- compound(T), functor(T,_,M), !,
                   calculate_max_term_depth(T,M,N1), N is N1+1.

calculate_max_term_depth(_,0,0) :- !.
calculate_max_term_depth(T,M,N) :- arg(M,T,A), term_depth(A,N1), M1 is M-1, 
                                   calculate_max_term_depth(T,M1,N2), max(N1,N2,N).

max(A,B,A) :- A>=B, !.
max(_,B,B).
 
/* ----------------------------------------------------------------- */

/* formatted name of objects (for the formatted output of construction) */
obj_name(X,W) :- var(X), !, /* write('aaaaa'), */ term_to_atom(X,Y), string_concat('V[',Y,Z),
                 string_concat(Z,']',W).
obj_name(obj(point,X),W) :- var(X), !, /*write('bbbbb'), write('2:'), write(X), nl, */ term_to_atom(X,Y), /*write('3:'), write(X),*/ string_concat('P_{\\',Y,Z),
                             /*write('4:'), write(X),*/ string_concat(Z,'}',W)/*, write('5:'), write(X), nl*/.
obj_name(obj(line,X),W) :- var(X), !, /* write('cccc'), */ term_to_atom(X,Y), string_concat('L_{\\',Y,Z),
                           string_concat(Z,'}',W).
obj_name(obj(circle,X),W) :- var(X), !, /* write('ddddddd'), */ term_to_atom(X,Y), string_concat('C_{\\',Y,Z),
                             string_concat(Z,'}',W).
obj_name(obj(angle,X),W) :- var(X), !, term_to_atom(X,Y), string_concat('angle[',Y,Z),
                            string_concat(Z,']',W).
obj_name(obj(int,X),X) :- /*write(X), write('prevodjenje broja'),*/ !.

obj_name(obj(point,a),'A') :- !.
obj_name(obj(point,b),'B') :- !.
obj_name(obj(point,c),'C') :- !.
obj_name(obj(point,a_k),'A_{k}') :- !.
obj_name(obj(point,b_k),'B_{k}') :- !.
obj_name(obj(point,c_k),'C_{k}') :- !.
obj_name(obj(point,chord1(a)),'A_{c1}') :- !.
obj_name(obj(point,chord2(a)),'A_{c2}') :- !.
obj_name(obj(point,chord3(a)),'A_{c3}') :- !.
obj_name(obj(point,chord4(a)),'A_{c4}') :- !.
obj_name(obj(point,chord1(b)),'B_{c1}') :- !.
obj_name(obj(point,chord2(b)),'B_{c2}') :- !.
obj_name(obj(point,chord3(b)),'B_{c3}') :- !.
obj_name(obj(point,chord4(b)),'B_{c4}') :- !.
obj_name(obj(point,chord1(c)),'C_{c1}') :- !.
obj_name(obj(point,chord2(c)),'C_{c2}') :- !.
obj_name(obj(point,chord3(c)),'C_{c3}') :- !.
obj_name(obj(point,chord4(c)),'C_{c4}') :- !.
obj_name(obj(point,chord_alt1(a)),'A_{ca1}') :- !.
obj_name(obj(point,chord_alt2(a)),'A_{ca2}') :- !.
obj_name(obj(point,chord_alt1(b)),'B_{ca1}') :- !.
obj_name(obj(point,chord_alt2(b)),'B_{ca2}') :- !.
obj_name(obj(point,chord_alt1(c)),'C_{ca1}') :- !.
obj_name(obj(point,chord_alt2(c)),'C_{ca2}') :- !.
obj_name(obj(point,second_ai(a)),'A_{sa}') :- !.
obj_name(obj(point,second_ai(b)),'B_{sa}') :- !.
obj_name(obj(point,second_ai(c)),'C_{sa}') :- !.
obj_name(obj(point,foot_ima(a)),'A_{fi}') :- !.
obj_name(obj(point,foot_ima(b)),'B_{fi}') :- !.
obj_name(obj(point,foot_ima(c)),'C_{fi}') :- !.
obj_name(obj(point,foot_out(a)),'A_{fo}') :- !.
obj_name(obj(point,foot_out(b)),'B_{fo}') :- !.
obj_name(obj(point,foot_out(c)),'C_{fo}') :- !.
obj_name(obj(line,line_a1),'a1') :- !.
obj_name(obj(line,line_a2),'a2') :- !.
obj_name(obj(line,line_b1),'b1') :- !.
obj_name(obj(line,line_b2),'b2') :- !.
obj_name(obj(line,line_c1),'c1') :- !.
obj_name(obj(line,line_c2),'c2') :- !.
obj_name(obj(line,line_x1),'x1') :- !.
obj_name(obj(line,line_x2),'x2') :- !.
obj_name(obj(line,line_x3),'x3') :- !.
obj_name(obj(line,line_y1),'y1') :- !.
obj_name(obj(line,line_y2),'y2') :- !.
obj_name(obj(line,line_y3),'y3') :- !.
obj_name(obj(point,a_w(b)),'A_{wb}') :- !.
obj_name(obj(point,a_w(c)),'A_{wc}') :- !.
obj_name(obj(point,b_w(a)),'B_{wa}') :- !.
obj_name(obj(point,b_w(c)),'B_{wc}') :- !.
obj_name(obj(point,c_w(a)),'C_{wa}') :- !.
obj_name(obj(point,c_w(b)),'C_{wb}') :- !.
obj_name(obj(line,line([a,b])),'c') :- !.
obj_name(obj(line,line([a,c])),'b') :- !.
obj_name(obj(line,line([b,c])),'a') :- !.
obj_name(obj(line,line([X,Y])),Z) :- obj_name(obj(point,X),X1),  
                                     obj_name(obj(point,Y),Y1), 
                                     string_concat(X1,Y1,Z), !.
obj_name(obj(point,midpoint([a,b])),'M_{c}') :- !.
obj_name(obj(point,midpoint([a,c])),'M_{b}') :- !.
obj_name(obj(point,midpoint([b,c])),'M_{a}') :- !.
obj_name(obj(point,midpoint([X,Y])),Z) :- obj_name(obj(point,X),X1),  
                                     obj_name(obj(point,Y),Y1),
                                     string_concat('midpoint([',X1,Z1),
                                     string_concat(Z1,',',Z2),
                                     string_concat(Z2,Y1,Z3),
                                     string_concat(Z3,'])',Z), !.
obj_name(obj(point,circumcenter([a,b],c)),'O') :- !.
obj_name(obj(point,incenter([a,b],c)),'I') :- !.
obj_name(obj(point,centroid([a,b],c)),'G') :- !.
obj_name(obj(point,orthocenter([a,b],c)),'H') :- !.
obj_name(obj(point,npcenter([a,b],c)),'N') :- !.
obj_name(obj(point,foot(a,[b,c])),'H_{a}') :- !.
obj_name(obj(point,foot(b,[a,c])),'H_{b}') :- !.
obj_name(obj(point,foot(c,[a,b])),'H_{c}') :- !.
obj_name(obj(point,point_n(a,[b,c])),'N_{a}') :- !.
obj_name(obj(point,point_n(b,[a,c])),'N_{b}') :- !.
obj_name(obj(point,point_n(c,[a,b])),'N_{c}') :- !.
obj_name(obj(point,point_n_k(a,[b,c])),'N_{ak}') :- !.
obj_name(obj(point,point_n_k(b,[a,c])),'N_{bk}') :- !.
obj_name(obj(point,point_n_k(c,[a,b])),'N_{ck}') :- !.
obj_name(obj(point,point_p(a,[b,c])),'PP_{a}') :- !.
obj_name(obj(point,point_p(b,[a,c])),'PP_{b}') :- !.
obj_name(obj(point,point_p(c,[a,b])),'PP_{c}') :- !.
obj_name(obj(point,point_p1(a,[b,c])),'PP_{a}`') :- !.
obj_name(obj(point,point_p1(b,[a,c])),'PP_{b}`') :- !.
obj_name(obj(point,point_p1(c,[a,b])),'PP_{c}`') :- !.
obj_name(obj(point,angle_bis_foot(a,[b,c])),'T_{a}') :- !.
obj_name(obj(point,angle_bis_foot(b,[a,c])),'T_{b}') :- !.
obj_name(obj(point,angle_bis_foot(c,[a,b])),'T_{c}') :- !.
obj_name(obj(point,euler(a,[b,c])),'E_{a}') :- !.
obj_name(obj(point,euler(b,[a,c])),'E_{b}') :- !.
obj_name(obj(point,euler(c,[a,b])),'E_{c}') :- !.
obj_name(obj(point,angle_bis_out_foot(a,[b,c])),'T`_{a}') :- !.
obj_name(obj(point,angle_bis_out_foot(b,[a,c])),'T`_{b}') :- !.
obj_name(obj(point,angle_bis_out_foot(c,[a,b])),'T`_{c}') :- !.
obj_name(obj(point,foot(incenter([a,b],c),[b,c])),'P_{a}') :- !.
obj_name(obj(point,foot(incenter([a,b],c),[a,c])),'P_{b}') :- !.
obj_name(obj(point,foot(incenter([a,b],c),[a,b])),'P_{c}') :- !.
obj_name(obj(point,foot(outcenter(a,[b,c]),[b,c])),'P`_{a}') :- !.
obj_name(obj(point,foot(outcenter(b,[a,c]),[a,c])),'P`_{b}') :- !.
obj_name(obj(point,foot(outcenter(c,[a,b]),[a,b])),'P`_{c}') :- !.
obj_name(obj(point,foot_out(a)),'P``_{a}') :- !.
obj_name(obj(point,foot_out(b)),'P``_{b}') :- !.
obj_name(obj(point,foot_out(c)),'P``_{c}') :- !.
obj_name(obj(line,side_bis([b,c])),'m_{a}') :- !.
obj_name(obj(line,side_bis([a,c])),'m_{b}') :- !.
obj_name(obj(line,side_bis([a,b])),'m_{c}') :- !.
obj_name(obj(line,side_bis([X,Y])),Z) :- obj_name(obj(point,X),X1),  
                                         obj_name(obj(point,Y),Y1), 
                                         string_concat('m(',X1,Z1),
                                         string_concat(Z1,Y1,Z2),
                                         string_concat(Z2,')',Z), !.
obj_name(obj(line,homothety(P,L,A,B)),Z) :- obj_name(obj(point,P),P1),  
                                            obj_name(obj(line,L),L1), 
                                            string_concat('h_{',P1,Z1),
                                            string_concat(Z1,',',Z2),
                                            string_concat(Z2,A,Z3),
                                            string_concat(Z3,'/',Z4),
                                            string_concat(Z4,B,Z5),
                                            string_concat(Z5,'}(',Z6), 
                                            string_concat(Z6,L1,Z7),
                                            string_concat(Z7,')',Z), !.
obj_name(obj(circle,homothety_circ(P,C,A,B)),Z) :- obj_name(obj(point,P),P1),  
                                                 obj_name(obj(circle,C),C1), 
                                                 string_concat('h_{',P1,Z1),
                                                 string_concat(Z1,',',Z2),
                                                 string_concat(Z2,A,Z3),
                                                 string_concat(Z3,'/',Z4),
                                                 string_concat(Z4,B,Z5),
                                                 string_concat(Z5,'}(',Z6), 
                                                 string_concat(Z6,C1,Z7),
                                                 string_concat(Z7,')',Z), !.
obj_name(obj(line,altitude(a,[b,c])),'h_{a}') :- !.
obj_name(obj(line,altitude(b,[a,c])),'h_{b}') :- !.
obj_name(obj(line,altitude(c,[a,b])),'h_{c}') :- !.
obj_name(obj(line,median(a,[b,c])),'t_{a}') :- !.
obj_name(obj(line,median(b,[a,c])),'t_{b}') :- !.
obj_name(obj(line,median(c,[a,b])),'t_{c}') :- !.
obj_name(obj(line,angle_bis(a,[b,c])),'s_{a}') :- !.
obj_name(obj(line,angle_bis(b,[a,c])),'s_{b}') :- !.
obj_name(obj(line,angle_bis(c,[a,b])),'s_{c}') :- !.
obj_name(obj(circle,circumcircle([a,b],c)),'k(O,C)') :- !.
obj_name(obj(circle,incircle([a,b],c)),'k(I,P_{a})') :- !.
obj_name(obj(circle,npcircle([a,b],c)),'k(N,M_{a})') :- !.
obj_name(obj(circle,circle_center_through(X,Y)),Z) :- obj_name(obj(point,X),X1), 
                                                      obj_name(obj(point,Y),Y1),
                                                      string_concat('k(',X1,P1), 
                                                      string_concat(P1,',',P2), 
                                                      string_concat(P2,Y1,P3),
                                                      string_concat(P3,')',Z), !.
obj_name(obj(circle,diam(X,Y)),Z) :- obj_name(obj(point,X),X1), 
                                     obj_name(obj(point,Y),Y1),
                                     string_concat('k_over(',X1,P1), 
                                     string_concat(P1,',',P2), 
                                     string_concat(P2,Y1,P3),
                                     string_concat(P3,')',Z), !.
obj_name(obj(circle,circumcircle([b,c,foot(b,[a,c])])),'k(M_{a},C)') :- !.
obj_name(obj(circle,circumcircle([b,a,foot(b,[a,c])])),'k(M_{c},B)') :- !.
obj_name(obj(circle,circumcircle([a,c,foot(a,[b,c])])),'k(M_{b},A)') :- !.
obj_name(obj(angle,angle(X,Y)),Z) :- obj_name_modified(obj(line,X),X1), 
                                     obj_name_modified(obj(line,Y),Y1),
                                     string_concat('angle[',X1,P1),
                                     string_concat(P1,'][',P2),
                                     string_concat(P2,Y1,P3),
                                     string_concat(P3,']',Z), !.
obj_name(obj(circle,over_chord([X,Y],Ang)),Z) :- obj_name(obj(point,X),X1), 
                                                 obj_name(obj(point,Y),Y1), 
                                                 obj_name(obj(angle,Ang),Ang1), 
                                                 string_concat('circle[',X1,A1),
                                                 string_concat(A1,',',A2),
                                                 string_concat(A2,Y1,A3), 
                                                 string_concat(A3,',',A4),
                                                 string_concat(A4,Ang1,A5),
                                                 string_concat(A5,']',Z), !.
obj_name(obj(point,foot(X,Y)),Z) :- obj_name(obj(point,X),X1),
                                    obj_name(obj(line,Y),Y1),
                                    string_concat('foot[',X1,A1),
                                    string_concat(A1,',',A2),
                                    string_concat(A2,Y1,A3),
                                    string_concat(A3,']',Z), !.
obj_name(X,X). /* for other objects */

/*PROVERI DA LI TREBA MOZDA KAO ARGUMENT X, PA ONDA PROVERITI EQUAL(x,...)*/

tex_obj_name(Obj,NameTex) :- obj_name(Obj,Name), string_concat('$',Name,Name1), string_concat(Name1,'$',NameTex).
tex_underline_obj_name(Obj,NameTex) :- obj_name(Obj,Name), underline_name(Name,NameU), 
                                       string_concat('$',NameU,Name1), string_concat(Name1,'$',NameTex).

obj_name_modified(Obj,NameMod) :- obj_name(Obj,Name), replace_brackets(Name,NameMod), !.

obj_name_html(Obj,HName) :- obj_name(Obj,Name), replace_subscript(Name,HName), !.

replace_brackets(Name,NameMod) :- string_to_list(Name,NameList), replace(NameList,NameNew), string_to_list(NameMod,NameNew), !.

replace([],[]) :- !.
replace([40|T],[91|T1]) :- !, replace(T,T1).
replace([41|T],[93|T1]) :- !, replace(T,T1).
replace([95,123|T],[91|T1]) :- !, replace(T,T1).
replace([125|T],[93|T1]) :- !, replace(T,T1).

replace([H|T],[H|T1]) :- replace(T,T1). 

replace_subscript(Name,NameMod) :- string_to_list(Name,NameList), replace_s(NameList,NameNew), string_to_list(NameMod,NameNew), !.

replace_s([],[]) :- !.
replace_s([95,123|T],[60,115,117,98,62|T1]) :- !, replace_s(T,T1).
replace_s([125|T],[60,47,115,117,98,62|T1]) :- !, replace_s(T,T1).

replace_s([H|T],[H|T1]) :- replace_s(T,T1). 


/* ----------------------------------------------------------------- */

/* printing problem setting into a file */
print_problem_setting_to_file(Known,_,N,Stream) :- write(Stream,'Problem '), 
                                                        write(Stream,N),
                                                        write(Stream,':'),
                                                        nl(Stream),
                                                        write(Stream,'Given '), 
                                                        write_tex_indef_objs_to_file(Known,Stream),
                                                        write(Stream, ', construct the triangle ABC.'), 
                                                        nl(Stream), nl(Stream), !.

/* ----------------------------------------------------------------- */
                                                     
print_construction_to_tex_file(L,Known,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Status,Stream) :-
                                             Known=[A,B,C],
                                             tex_obj_name(A,AN), tex_underline_obj_name(A,AU),
                                             tex_obj_name(B,BN),  tex_underline_obj_name(B,BU),
                                             tex_obj_name(C,CN),  tex_underline_obj_name(C,CU),
                                             write(Stream,'\\chapter{Problem '), write(Stream,N),  
                                             write(Stream,': '), write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,', '), write(Stream,CN),
                                             write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\section{Problem}'), nl(Stream), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N), write(Stream,': '), 
                                             write(Stream,'Given '), write_tex_indef_objs_to_file(Known,Stream),
                                             write(Stream, ', construct the triangle $ABC$.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'\\section{Status}'), nl(Stream), nl(Stream),
                                             write(Stream,'ArgoTriCS says that the problem is '), write_status(Status,Stream), nl(Stream), nl(Stream),
                                             write(Stream,'\\section{Solution}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in natural language form}'), nl(Stream), nl(Stream),
                                             print_tex_steps_to_file_if_any(L,1,Stream),
                                             nl(Stream),
                                             write(Stream, 'Non-degenerate conditions: '), write_tex_prop_list(Stream,NDGs,1), write(Stream,'.'), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Determination conditions: '), write_tex_prop_list(Stream,DETs,1), write(Stream,'.'), nl(Stream), 
                                             nl(Stream),
                                             write(Stream, 'Rules used: '), write_whitespace(Stream,RulesUsed,1), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Definitions and lemmas used: '), write_whitespace(Stream,LemmasUsed,1), nl(Stream), nl(Stream),
                                             write(Stream, 'Solving time: '), 
                                             format(Stream,'~1f',[Time]), /*write(Stream,Time),*/ write(Stream,' seconds.'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in GCLC language}'), nl(Stream), nl(Stream),
                                             write(Stream, '{\\footnotesize'), nl(Stream),
                                             write(Stream,'\\begin{lstlisting}'), nl(Stream),
                                             print_only_construction_to_gclc_file(L,NDGs,DETs,Known,Stream),
                                             write(Stream,'\\end{lstlisting}'), nl(Stream), 
                                             write(Stream,'}'), nl(Stream),
                                             nl(Stream),
                                             write(Stream,'\\subsection{Illustration}'), nl(Stream), nl(Stream),
                                             write(Stream,'Illustration of the constructed figure is given in Figure \\ref{fig:problem'),
                                             write(Stream,N), write(Stream,'}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\begin{figure}'), nl(Stream),
                                             write(Stream,'\\centering'), nl(Stream),
                                             four_digit_name(N,NN),
                                             write(Stream,'\\input{proofs/construction0_'), write(Stream,NN), write(Stream,'.tkz}'), nl(Stream),
                                             write(Stream,'\\caption{Illustration for the problem '), write(Stream,NN),
                                             write(Stream,'}\\label{fig:problem'), write(Stream,N), write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\end{figure}'), nl(Stream),
                                             write(Stream,'\\section{Correctness proof}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{OGP - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                           
                                             write(Stream,'\\subsection{GCLC - Area method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Grobner basis method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             !.

print_construction_to_tex_file_red(L,Known,C,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Status,Stream) :-
                                             Known=[A,B],
                                             Known1=[C,A,B],
                                             tex_obj_name(A,AN), tex_underline_obj_name(A,AU),
                                             tex_obj_name(B,BN),  tex_underline_obj_name(B,BU),
                                             tex_obj_name(C,CN),  tex_underline_obj_name(C,CU),
                                             write(Stream,'\\chapter{Problem '), write(Stream,N),  
                                             write(Stream,': '), write(Stream,CN),
                                             write(Stream,', '), write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\section{Problem}'), nl(Stream), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N), write(Stream,': '), 
                                             write(Stream,'Given '), write_tex_indef_objs_to_file(Known1,Stream),
                                             write(Stream, ', construct the triangle $ABC$.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'\\section{Status}'), nl(Stream), nl(Stream),
                                             write(Stream,'ArgoTriCS says that the problem is '), write_status(Status,Stream), nl(Stream), nl(Stream),
                                             write(Stream,'\\section{Solution}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in natural language form}'), nl(Stream), nl(Stream),
                                             print_tex_steps_to_file_if_any(L,1,Stream),
                                             nl(Stream),
                                             write(Stream, 'Non-degenerate conditions: '), write_tex_prop_list(Stream,NDGs,1), write(Stream,'.'), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Determination conditions: '), write_tex_prop_list(Stream,DETs,1), write(Stream,'.'), nl(Stream), 
                                             nl(Stream),
                                             write(Stream, 'Rules used: '), write_whitespace(Stream,RulesUsed,1), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Definitions and lemmas used: '), write_whitespace(Stream,LemmasUsed,1), nl(Stream), nl(Stream),
                                             write(Stream, 'Solving time: '), 
                                             format(Stream,'~1f',[Time]), /*write(Stream,Time),*/ write(Stream,' seconds.'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in GCLC language}'), nl(Stream), nl(Stream),
                                             write(Stream, '{\\footnotesize'), nl(Stream),
                                             write(Stream,'\\begin{lstlisting}'), nl(Stream),
                                             print_only_construction_to_gclc_file_red(L,NDGs,DETs,Known,[C],Stream),
                                             write(Stream,'\\end{lstlisting}'), nl(Stream), 
                                             write(Stream,'}'), nl(Stream),
                                             nl(Stream),
                                             write(Stream,'\\subsection{Illustration}'), nl(Stream), nl(Stream),
                                             write(Stream,'Illustration of the constructed figure is given in Figure \\ref{fig:problem'),
                                             write(Stream,N), write(Stream,'}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\begin{figure}'), nl(Stream),
                                             write(Stream,'\\centering'), nl(Stream),
                                             four_digit_name(N,NN),
                                             write(Stream,'\\input{proofs/construction0_'), write(Stream,NN), write(Stream,'.tkz}'), nl(Stream),
                                             write(Stream,'\\caption{Illustration for the problem '), write(Stream,NN),
                                             write(Stream,'}\\label{fig:problem'), write(Stream,N), write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\end{figure}'), nl(Stream),
                                             write(Stream,'\\section{Correctness proof}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{OGP - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                           
                                             write(Stream,'\\subsection{GCLC - Area method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Grobner basis method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             !.

print_construction_to_tex_file_ld(L,Known,C,El,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Status,Stream) :-
                                             Known=[A,B],
                                             Known1=[C,A,B],
                                             tex_obj_name(A,AN), tex_underline_obj_name(A,AU),
                                             tex_obj_name(B,BN),  tex_underline_obj_name(B,BU),
                                             tex_obj_name(C,CN),  tex_underline_obj_name(C,CU),
                                             write(Stream,'\\chapter{Problem '), write(Stream,N),  
                                             write(Stream,': '), write(Stream,CN),
                                             write(Stream,', '), write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\section{Problem}'), nl(Stream), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N), write(Stream,': '), 
                                             write(Stream,'Given '), write_tex_indef_objs_to_file(Known1,Stream),
                                             write(Stream, ', construct the triangle $ABC$.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'\\section{Status}'), nl(Stream), nl(Stream),
                                             write(Stream,'ArgoTriCS says that the problem is '), write_status(Status,Stream), nl(Stream), nl(Stream),
                                             write(Stream,'\\section{Solution}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in natural language form}'), nl(Stream), nl(Stream),
                                             print_tex_steps_to_file_if_any(L,1,Stream),
                                             nl(Stream),
                                             write(Stream, 'Non-degenerate conditions: '), write_tex_prop_list(Stream,NDGs,1), write(Stream,'.'), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Determination conditions: '), write_tex_prop_list(Stream,DETs,1), write(Stream,'.'), nl(Stream), 
                                             nl(Stream),
                                             write(Stream, 'Rules used: '), write_whitespace(Stream,RulesUsed,1), nl(Stream),
                                             nl(Stream),
                                             write(Stream, 'Definitions and lemmas used: '), write_whitespace(Stream,LemmasUsed,1), nl(Stream), nl(Stream),
                                             write(Stream, 'Solving time: '), 
                                             format(Stream,'~1f',[Time]), /*write(Stream,Time),*/ write(Stream,' seconds.'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{Construction in GCLC language}'), nl(Stream), nl(Stream),
                                             write(Stream, '{\\footnotesize'), nl(Stream),
                                             write(Stream,'\\begin{lstlisting}'), nl(Stream),
                                             print_only_construction_to_gclc_file_ld(L,NDGs,DETs,Known,C,El,Stream),
                                             write(Stream,'\\end{lstlisting}'), nl(Stream), 
                                             write(Stream,'}'), nl(Stream),
                                             nl(Stream),
                                             write(Stream,'\\subsection{Illustration}'), nl(Stream), nl(Stream),
                                             write(Stream,'Illustration of the constructed figure is given in Figure \\ref{fig:problem'),
                                             write(Stream,N), write(Stream,'}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\begin{figure}'), nl(Stream),
                                             write(Stream,'\\centering'), nl(Stream),
                                             four_digit_name(N,NN),
                                             write(Stream,'\\input{proofs/construction0_'), write(Stream,NN), write(Stream,'.tkz}'), nl(Stream),
                                             write(Stream,'\\caption{Illustration for the problem '), write(Stream,NN),
                                             write(Stream,'}\\label{fig:problem'), write(Stream,N), write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\end{figure}'), nl(Stream),
                                             write(Stream,'\\section{Correctness proof}'), nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{OGP - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_ogp_wu_short}'), 
                                             nl(Stream), nl(Stream),                                           
                                             write(Stream,'\\subsection{GCLC - Area method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_area_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Wu method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_wu_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsection{GCLC - Grobner basis method}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,AN), 
                                             write(Stream,'='), write(Stream,AU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction1_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,BN), 
                                             write(Stream,'='), write(Stream,BU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction2_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\subsubsection{Proving '),write(Stream,CN), 
                                             write(Stream,'='), write(Stream,CU), write(Stream,'}'), 
                                             nl(Stream), nl(Stream),
                                             write(Stream,'\\input{proofs/construction3_'), write(Stream,NN), write(Stream,'_proof_gclc_gb_short}'), 
                                             nl(Stream), nl(Stream),
                                             !.

print_unsolvable_to_tex_file(Known,N,Stream) :-
                                             /*
                                             write(Stream,'\\documentclass{article}'), nl(Stream),
                                             write(Stream,'\\usepackage{argoclp}'), nl(Stream),
                                             write(Stream,'\\usepackage{listings}'), nl(Stream),
                                             write(Stream,'\\usepackage{tikz}'), nl(Stream),
                                             write(Stream,'\\usepackage{gclc}'), nl(Stream),
                                             write(Stream,'\\usepackage{graphicx}'), nl(Stream),

                                             write(Stream,'\\lstset{%'), nl(Stream),
                                             write(Stream,'language=[LaTeX]TeX,'), nl(Stream),
                                             write(Stream,'basicstyle=\\ttfamily,'), nl(Stream),
                                             write(Stream,'breaklines=true,'), nl(Stream),
                                             write(Stream,'columns=fullflexible'), nl(Stream),
                                             write(Stream,'}'), nl(Stream),
                    
                                             write(Stream,'\\makeatletter'), nl(Stream),
                                             write(Stream,'\\@ifclassloaded{combine}'), nl(Stream),
                                             write(Stream,'  {\\let\\@begindocumenthook\\@empty}'), nl(Stream),
                                             write(Stream,'  {}'), nl(Stream),
                                             write(Stream,'\\makeatother'), nl(Stream), nl(Stream),

                                             write(Stream,'\\begin{document}'), nl(Stream),
                                             write(Stream,'\\title{Problem '), write(Stream,N),  write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\author{Generated automatically by ArgoTriCS '),
                                             write(Stream,'\\\\ Developed by Vesna Marinkovi\\\' c, University of Belgrade}'), 
                                             nl(Stream),
                                             write(Stream,'\\maketitle'), nl(Stream), nl(Stream),
                                             */
                                             Known=[A,B,C],
                                             tex_obj_name(A,AN),
                                             tex_obj_name(B,BN),
                                             tex_obj_name(C,CN),
                                             write(Stream,'\\chapter{Problem '), write(Stream,N),  
                                             write(Stream,': '), write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,', '), write(Stream,CN),
                                             write(Stream,'}'), nl(Stream),
                                             write(Stream,'\\section{Problem}'), nl(Stream), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N), write(Stream,': '), 
                                             write(Stream,'Given '), write_tex_indef_objs_to_file(Known,Stream),
                                             write(Stream, ', construct the triangle $ABC$.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'\\section{Status}'), nl(Stream), nl(Stream),
                                             write(Stream,'ArgoTriCS says that the status of the problem is unknown.'), nl(Stream), nl(Stream),
                                             write_real_status(Stream,N),
                                             nl(Stream), nl(Stream),
                                             !.

corpus_name(N,'Wernick') :- N<561, !.
corpus_name(N,'Connelly') :- N>560, !.

corpus_name_lowercase(N,'wernick') :- N<561, !.
corpus_name_lowercase(N,'connelly') :- N>560, !.

corpus_number(N,N) :- N<561, !.
corpus_number(N,N1) :- N>560, N1 is N-560, !.

print_construction_to_html_file(L,Known,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Status,Stream) :-
                                             Known=[A,B,C],
                                             obj_name_html(A,AN),
                                             obj_name_html(B,BN),
                                             obj_name_html(C,CN),
                                             four_digit_name(N,NN),
                                             corpus_name(N,CName),
                                             corpus_number(N,N1),
                                             
                                             write(Stream,'<!DOCTYPE html>'), nl(Stream),
                                             write(Stream,'<html>'), nl(Stream),
                                             write(Stream,'<head>'), nl(Stream),
                                             write(Stream,'<title>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus'),
                                             write(Stream,'</title>'), nl(Stream),
                          
                                             write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="jquery-2.1.4.min.js"></script>'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="javascript_animations.js"></script>'), nl(Stream),
                                             
                                             write(Stream,'</head>'), nl(Stream),

                                             write(Stream,'<body>'), nl(Stream),
                                             corpus_name_lowercase(N,CNameL),
                                             write(Stream,'<a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a>'), nl(Stream),

                                             write(Stream,'<h2>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),  
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus: '),
                                             write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,', '), write(Stream,CN),
                                             write(Stream,'</h2>'), nl(Stream),                                             
                                             write(Stream,'<br>'),

                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Problem'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'Given '), write_html_indef_objs_to_file(Known,Stream),
                                             write(Stream, ', construct the triangle ABC.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Status'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             
                                             write(Stream,'ArgoTriCS says that the problem is '), write_status(Status,Stream), nl(Stream), 
                                             
                                             nl(Stream),
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Illustration'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'<img class="svg" src="construction0_'), write(Stream,NN),
                                             write(Stream,'.svg" alt="Figure of construction">'),
                                             nl(Stream),

                                             nl(Stream),
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Solution'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'<input type="button" value="Construction in natural language form" id="show_steps">'), nl(Stream),
                                             write(Stream,'<table style="width:100%">'), nl(Stream),
                                             write(Stream,'<tr>'), nl(Stream),
                                             write(Stream,'<td style="width:70%">'), nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),

                                             print_html_steps_to_file_if_any(L,1,Stream),
                                             nl(Stream),
                                             
                                             write(Stream,'</td>'), nl(Stream),
                                             write(Stream,'<td style="width:30%">'), nl(Stream),
                                             
                                             write(Stream,'<img src="animation_'),
                                             write(Stream,NN), write(Stream,'.gif" alt="animation" id="image">'),


                                             write(Stream,'</td>'), nl(Stream),
                                             write(Stream,'</tr>'), nl(Stream),
                                             write(Stream,'</table>'), nl(Stream),

                                             write(Stream,'<a href="construction_gclc_'),
                                             write(Stream,NN), write(Stream,'.html" target="_blank">'),
                                             write(Stream,'Construction in GCLC language'), 
                                             write(Stream,'</a>'),
                                             nl(Stream), nl(Stream),

                                             output_gclc_html_file_name(N,Name),
                                             open(Name,write,StreamH),
                                             print_only_construction_to_gclc_html_file(L,N,NDGs,DETs,Known,StreamH),
                                             close(StreamH),

                                             nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),
                                             write(Stream,'<p class="desno"><a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a></p>'), nl(Stream), nl(Stream),

                                             nl(Stream), nl(Stream),
                           
                                             write(Stream,'</body>'), nl(Stream),
                                             write(Stream,'</html>'), nl(Stream),

                                             nl(Stream), nl(Stream),
                                             !.

print_construction_to_html_file_red(L,Known,C,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Status,Stream) :-

                                             Known=[A,B],
                                             Known1=[C,A,B],
                                             obj_name_html(A,AN),
                                             obj_name_html(B,BN),
                                             obj_name_html(C,CN),
                                             four_digit_name(N,NN),
                                             corpus_name(N,CName),
                                             corpus_number(N,N1),
                                             
                                             write(Stream,'<!DOCTYPE html>'), nl(Stream),
                                             write(Stream,'<html>'), nl(Stream),
                                             write(Stream,'<head>'), nl(Stream),
                                             write(Stream,'<title>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus'),
                                             write(Stream,'</title>'), nl(Stream),

                                             write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="jquery-2.1.4.min.js"></script>'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="javascript_animations.js"></script>'), nl(Stream),

                                             write(Stream,'</head>'), nl(Stream),

                                             write(Stream,'<body>'), nl(Stream),
                                             corpus_name_lowercase(N,CNameL),
                                             write(Stream,'<a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a>'), nl(Stream),

                                             write(Stream,'<h2>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),  
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus: '),
                                             write(Stream,CN),
                                             write(Stream,', '), write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,'</h2>'), nl(Stream),                                             
                                             write(Stream,'<br>'),

                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Problem'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'Given '), write_html_indef_objs_to_file(Known1,Stream),
                                             write(Stream, ', construct the triangle ABC.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Status'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             
                                             write(Stream,'ArgoTriCS says that the problem is '), write_status(Status,Stream), nl(Stream), nl(Stream),

                                             nl(Stream),
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Illustration'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'<img class="svg" src="construction0_'), write(Stream,NN),
                                             write(Stream,'.svg" alt="Figure of construction">'),
                                             nl(Stream),

                                             nl(Stream),
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Solution'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'<input type="button" value="Construction in natural language form" id="show_steps">'), nl(Stream),
                                             write(Stream,'<table style="width:100%">'), nl(Stream),
                                             write(Stream,'<tr>'), nl(Stream),
                                             write(Stream,'<td style="width:70%">'), nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),

                                             print_html_steps_to_file_if_any(L,1,Stream),
                                             nl(Stream),
                                             
                                             write(Stream,'</td>'), nl(Stream),
                                             write(Stream,'<td style="width:30%">'), nl(Stream),
                                             
                                             write(Stream,'<img src="animation_'),
                                             write(Stream,NN), write(Stream,'.gif" alt="animation" id="image">'),


                                             write(Stream,'</td>'), nl(Stream),
                                             write(Stream,'</tr>'), nl(Stream),
                                             write(Stream,'</table>'), nl(Stream),

                                             write(Stream,'<a href="construction_gclc_'),
                                             write(Stream,NN), write(Stream,'.html" target="_blank">'),
                                             write(Stream,'Construction in GCLC language'), 
                                             write(Stream,'</a>'),
                                             nl(Stream), nl(Stream),

                                             output_gclc_html_file_name(N,Name),
                                             open(Name,write,StreamH),
                                             print_only_construction_to_gclc_html_file_red(L,N,NDGs,DETs,Known,[C],StreamH),
                                             close(StreamH),

                                             nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),
                                             write(Stream,'<p class="desno"><a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a></p>'), nl(Stream), nl(Stream),
                                             nl(Stream), nl(Stream),
                           
                                             write(Stream,'</body>'), nl(Stream),
                                             write(Stream,'</html>'), nl(Stream),

                                             nl(Stream), nl(Stream),
                                             !.

print_construction_to_html_file_ld(L,Known,C,El,N,NDGs,DETs,RulesUsed,LemmasUsed,Time,Status,Stream) :-

                                             Known=[A,B],
                                             Known1=[C,A,B],
                                             obj_name_html(A,AN),
                                             obj_name_html(B,BN),
                                             obj_name_html(C,CN),
                                             four_digit_name(N,NN),
                                             corpus_name(N,CName),
                                             corpus_number(N,N1),
                                             
                                             write(Stream,'<!DOCTYPE html>'), nl(Stream),
                                             write(Stream,'<html>'), nl(Stream),
                                             write(Stream,'<head>'), nl(Stream),
                                             write(Stream,'<title>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus'),
                                             write(Stream,'</title>'), nl(Stream),

                                             write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="jquery-2.1.4.min.js"></script>'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="javascript_animations.js"></script>'), nl(Stream),
                                             write(Stream,'</head>'), nl(Stream),

                                             write(Stream,'<body>'), nl(Stream),
                                             corpus_name_lowercase(N,CNameL),
                                             write(Stream,'<a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a>'), nl(Stream),

                                             write(Stream,'<h2>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),  
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus: '),
                                             write(Stream,CN),
                                             write(Stream,', '), write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,'</h2>'), nl(Stream),                                             
                                             write(Stream,'<br>'),

                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Problem'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'Given '), write_html_indef_objs_to_file(Known1,Stream),
                                             write(Stream, ', construct the triangle ABC.'), nl(Stream), nl(Stream),

                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Status'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             
                                             write(Stream,'ArgoTriCS says that the problem is '), write_status(Status,Stream), nl(Stream), nl(Stream),

nl(Stream),
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Illustration'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'<img class="svg" src="construction0_'), write(Stream,NN),
                                             write(Stream,'.svg" alt="Figure of construction">'),
                                             nl(Stream),

                                             nl(Stream),
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Solution'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'<input type="button" value="Construction in natural language form" id="show_steps">'), nl(Stream),
                                             write(Stream,'<table style="width:100%">'), nl(Stream),
                                             write(Stream,'<tr>'), nl(Stream),
                                             write(Stream,'<td style="width:70%">'), nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),

                                             print_html_steps_to_file_if_any(L,1,Stream),
                                             nl(Stream),
                                             
                                             write(Stream,'</td>'), nl(Stream),
                                             write(Stream,'<td style="width:30%">'), nl(Stream),
                                             
                                             write(Stream,'<img src="animation_'),
                                             write(Stream,NN), write(Stream,'.gif" alt="animation" id="image">'),


                                             write(Stream,'</td>'), nl(Stream),
                                             write(Stream,'</tr>'), nl(Stream),
                                             write(Stream,'</table>'), nl(Stream),

                                             write(Stream,'<a href="construction_gclc_'),
                                             write(Stream,NN), write(Stream,'.html" target="_blank">'),
                                             write(Stream,'Construction in GCLC language'), 
                                             write(Stream,'</a>'),
                                             nl(Stream), nl(Stream),

                                             output_gclc_html_file_name(N,Name),
                                             open(Name,write,StreamH),
                                             print_only_construction_to_gclc_html_file_ld(L,N,NDGs,DETs,Known,C,El,StreamH),
                                             close(StreamH),

                                             nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),
                                             write(Stream,'<p class="desno"><a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a></p>'), nl(Stream), nl(Stream),
                                             nl(Stream), nl(Stream),
                           
                                             write(Stream,'</body>'), nl(Stream),
                                             write(Stream,'</html>'), nl(Stream),

                                             nl(Stream), nl(Stream),

                                             !.

print_unsolvable_to_html_file(Known,N,Stream) :-

                                             Known=[A,B,C],
                                             obj_name_html(A,AN),
                                             obj_name_html(B,BN),
                                             obj_name_html(C,CN),
                                             four_digit_name(N,NN),
                                             corpus_name(N,CName),
                                             corpus_number(N,N1),
                                             
                                             write(Stream,'<!DOCTYPE html>'), nl(Stream),
                                             write(Stream,'<html>'), nl(Stream),
                                             write(Stream,'<head>'), nl(Stream),
                                             write(Stream,'<title>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus'),
                                             write(Stream,'</title>'), nl(Stream),
                                             write(Stream,'<link rel="stylesheet" href="style_animations.css">'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="jquery-2.1.4.min.js"></script>'), nl(Stream),
                                             write(Stream,'<script type="text/javascript" src="javascript_animations.js"></script>'), nl(Stream),
                                             write(Stream,'</head>'), nl(Stream),

                                             write(Stream,'<body>'), nl(Stream),
                                             corpus_name_lowercase(N,CNameL),
                                             write(Stream,'<a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a>'), nl(Stream),
write(Stream,'<h2>'), nl(Stream),
                                             write(Stream,'Problem '), write(Stream,N1),  
                                             write(Stream,' from '), 
                                             write(Stream,CName),
                                             write(Stream,'\'s corpus: '),
                                             write(Stream,AN),
                                             write(Stream,', '), write(Stream,BN),
                                             write(Stream,', '), write(Stream,CN),
                                             write(Stream,'</h2>'), nl(Stream),                                             
                                             write(Stream,'<br>'),

                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Problem'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             

                                             write(Stream,'Given '), write_html_indef_objs_to_file(Known,Stream),
                                             write(Stream, ', construct the triangle ABC.'), nl(Stream), nl(Stream),
                                             
                                             write(Stream,'<h3>'), nl(Stream),
                                             write(Stream,'Status'), nl(Stream), nl(Stream),
                                             write(Stream,'</h3>'), nl(Stream),                                             
                                             write(Stream,'ArgoTriCS says that the status of the problem is unknown.'), nl(Stream), nl(Stream),
                                             write_real_status(Stream,N), nl(Stream), nl(Stream),
                                             nl(Stream),
                                             write(Stream,'<br>'), nl(Stream),
                                             write(Stream,'<p class="desno"><a href="compendium_'),
                                             write(Stream,CNameL),
                                             write(Stream,'.html" target="_blank">Back to the list of problems</a></p>'), nl(Stream), nl(Stream),
                                             nl(Stream), nl(Stream),
                           
                                             write(Stream,'</body>'), nl(Stream),
                                             write(Stream,'</html>'), nl(Stream),

                                             nl(Stream), nl(Stream),
                                             !.




/* ----------------------------------------------------------------- */

write_status('s',Stream) :- write(Stream,'solvable.').
write_status('r',Stream) :- write(Stream,'redundant.').
write_status('l',Stream) :- write(Stream,'locus dependent.').

/* ----------------------------------------------------------------- */

write_real_status(Stream,N) :- real_status(N,'unknown'), !, write(Stream,'[The status of the problem is still unknown]').
write_real_status(Stream,N) :- real_status(N,Status), write(Stream,'[However, the status of the problem is proved to be '), 
                               write(Stream,Status), write(Stream,']').

/* wernickova lista */
real_status(48,'unsolvable').
real_status(49,'unsolvable').
real_status(75,'unsolvable').
real_status(76,'unsolvable').
real_status(96,'solvable').
real_status(97,'unsolvable').
real_status(98,'unsolvable').
real_status(99,'solvable').
real_status(148,'unsolvable').
real_status(150,'unsolvable').
real_status(165,'unsolvable').
real_status(167,'unsolvable').
real_status(187,'unsolvable').
real_status(188,'solvable').
real_status(189,'unsolvable').
real_status(190,'solvable').
real_status(192,'unsolvable'). /* neka greska, 192 i 103 su simetricni, 103 je resiv, a 192 nije?? */
real_status(235,'unsolvable').
real_status(236,'unsolvable').
real_status(243,'unsolvable').
real_status(244,'unsolvable').
real_status(265,'unsolvable').
real_status(266,'unsolvable').
real_status(267,'solvable').
real_status(268,'solvable').
real_status(269,'unsolvable'). /* neka greska, 269 i 103 su simetricni, 103 je resiv, a 269 nije?? */
real_status(283,'unsolvable').
real_status(284,'unsolvable').
real_status(285,'solvable').
real_status(292,'unsolvable').
real_status(294,'unsolvable').
real_status(295,'solvable').
real_status(301,'unsolvable').
real_status(302,'unsolvable').
real_status(304,'solvable').
real_status(309,'unsolvable').
real_status(310,'unsolvable').
real_status(311,'unsolvable').
real_status(312,'unsolvable').
real_status(313,'unsolvable').
real_status(314,'unsolvable').
real_status(316,'solvable').
real_status(317,'unsolvable').
real_status(318,'unsolvable').
real_status(319,'unsolvable').
real_status(320,'unsolvable').
real_status(322,'unsolvable').
real_status(323,'solvable').
real_status(324,'unsolvable').
real_status(325,'unsolvable').
real_status(327,'unsolvable').
real_status(328,'unsolvable').
real_status(329,'solvable').
real_status(330,'unsolvable').
real_status(331,'unsolvable').
real_status(332,'unsolvable').
real_status(333,'unsolvable').
real_status(334,'unsolvable').
real_status(335,'unsolvable').
real_status(336,'unsolvable').
real_status(337,'solvable').
real_status(338,'unsolvable').
real_status(339,'solvable').
real_status(340,'solvable').
real_status(346,'solvable').
real_status(347,'unsolvable').
real_status(348,'unsolvable').
real_status(349,'unsolvable').
real_status(350,'unsolvable').
real_status(355,'solvable').
real_status(356,'unsolvable').
real_status(357,'unsolvable').
real_status(358,'unsolvable').
real_status(359,'unsolvable').
real_status(365,'unsolvable').
real_status(366,'unsolvable').
real_status(372,'unsolvable').
real_status(373,'unsolvable').
real_status(379,'unsolvable').
real_status(380,'unsolvable').
real_status(383,'unsolvable').
real_status(385,'unsolvable').
real_status(386,'solvable').
real_status(387,'unsolvable').
real_status(388,'unsolvable').
real_status(389,'unsolvable').
real_status(390,'unsolvable').
real_status(391,'unsolvable').
real_status(393,'unsolvable').
real_status(394,'unsolvable').
real_status(395,'unsolvable').
real_status(400,'solvable').
real_status(401,'unsolvable').
real_status(402,'unsolvable').
real_status(403,'unsolvable').
real_status(404,'unsolvable').
real_status(409,'unsolvable').
real_status(411,'unsolvable').
real_status(418,'unsolvable').
real_status(419,'unsolvable').
real_status(422,'unsolvable').
real_status(424,'unsolvable').
real_status(427,'unsolvable').
real_status(430,'unsolvable').
real_status(431,'unsolvable').
real_status(432,'solvable').
real_status(433,'unsolvable').
real_status(434,'unsolvable').
real_status(435,'unsolvable').
real_status(436,'unsolvable').
real_status(437,'unsolvable').
real_status(438,'unsolvable').
real_status(440,'unsolvable').
real_status(445,'unsolvable').
real_status(446,'unsolvable').
real_status(453,'unsolvable').
real_status(455,'unsolvable').
real_status(458,'unsolvable').
real_status(461,'unsolvable').
real_status(463,'unsolvable').
real_status(464,'unsolvable').
real_status(467,'unsolvable').
real_status(468,'unsolvable').
real_status(469,'solvable').
real_status(470,'unsolvable').
real_status(471,'unsolvable').
real_status(472,'unsolvable').
real_status(473,'unsolvable').
real_status(474,'unsolvable').
real_status(475,'unsolvable').
real_status(477,'unsolvable').
real_status(478,'unsolvable').
real_status(481,'unsolvable').
real_status(482,'unsolvable').
real_status(483,'solvable').
real_status(484,'unsolvable').
real_status(486,'unsolvable').
real_status(488,'unsolvable').
real_status(489,'solvable').
real_status(491,'unsolvable').
real_status(492,'unsolvable').
real_status(494,'solvable').
real_status(495,'unsolvable').
real_status(496,'unsolvable').
real_status(497,'unsolvable').
real_status(498,'unsolvable').
real_status(499,'unsolvable').
real_status(500,'unsolvable').
real_status(501,'unsolvable').
real_status(502,'unsolvable').
real_status(503,'unsolvable').
real_status(504,'unsolvable').
real_status(509,'unsolvable').
real_status(510,'unsolvable').
real_status(513,'unsolvable').
real_status(515,'unsolvable').
real_status(517,'unsolvable').
real_status(518,'unsolvable').
real_status(519,'solvable').
real_status(520,'unsolvable').
real_status(521,'unsolvable').
real_status(523,'unsolvable').
real_status(524,'unsolvable').
real_status(525,'unsolvable').
real_status(527,'unsolvable').
real_status(530,'unsolvable').
real_status(531,'unsolvable').
real_status(533,'unsolvable').
real_status(534,'solvable').
real_status(535,'unsolvable').
real_status(536,'unsolvable').
real_status(537,'unsolvable').
real_status(538,'unsolvable').
real_status(540,'unsolvable').
real_status(541,'unsolvable').
real_status(542,'unsolvable').
real_status(544,'solvable').
real_status(545,'unsolvable').
real_status(546,'unsolvable').
real_status(547,'unsolvable').
real_status(548,'unsolvable').
real_status(549,'unsolvable').
real_status(551,'unsolvable').
real_status(552,'unsolvable').
real_status(553,'solvable').
real_status(554,'unsolvable').
real_status(555,'solvable').
real_status(556,'solvable').
real_status(557,'unsolvable').

/* connelly-jeva lista */

real_status(576,'solvable').
real_status(583,'unsolvable').
real_status(584,'unsolvable').
real_status(585,'solvable').
real_status(586,'solvable').
real_status(591,'unknown').
real_status(592,'solvable').
real_status(596,'solvable').
real_status(597,'unknown').
real_status(598,'unknown').
real_status(599,'unknown').
real_status(600,'solvable').
real_status(605,'unknown').
real_status(606,'solvable').
real_status(610,'solvable').
real_status(611,'unknown').
real_status(612,'unknown').
real_status(613,'unknown').
real_status(619,'unknown').
real_status(624,'unknown').
real_status(625,'unknown').
real_status(626,'unknown').
real_status(632,'solvable').
real_status(633,'solvable').
real_status(638,'unknown').
real_status(640,'solvable').
real_status(643,'solvable').
real_status(644,'unknown').
real_status(645,'unknown').
real_status(646,'unknown').
real_status(653,'solvable').
real_status(659,'unsolvable').
real_status(661,'unsolvable').
real_status(662,'solvable').
real_status(667,'unknown').
real_status(669,'solvable').
real_status(672,'solvable').
real_status(673,'unknown').
real_status(674,'unknown').
real_status(675,'unknown').
real_status(681,'unknown').
real_status(686,'unknown').
real_status(687,'unknown').
real_status(688,'unknown').
real_status(689,'solvable').
real_status(691,'solvable').
real_status(696,'unknown').
real_status(699,'solvable').
real_status(701,'solvable').
real_status(702,'unknown').
real_status(703,'unknown').
real_status(704,'unknown').
real_status(706,'solvable').
real_status(711,'unknown').
real_status(714,'solvable').
real_status(716,'solvable').
real_status(717,'unknown').
real_status(718,'unknown').
real_status(719,'unknown').
real_status(725,'solvable').
real_status(731,'unsolvable').
real_status(732,'unsolvable').
real_status(739,'unknown').
real_status(744,'unknown').
real_status(745,'unknown').
real_status(746,'unknown').
real_status(748,'solvable').
real_status(753,'unsolvable').
real_status(758,'solvable').
real_status(759,'unknown').
real_status(760,'unknown').
real_status(761,'unknown').
real_status(762,'solvable').
real_status(767,'unsolvable').
real_status(772,'solvable').
real_status(773,'unknown').
real_status(774,'unknown').
real_status(775,'unknown').
real_status(778,'solvable').
real_status(779,'solvable').
real_status(780,'unknown').
real_status(782,'solvable').
real_status(783,'solvable').
real_status(786,'unknown').
real_status(787,'unknown').
real_status(788,'unknown').
real_status(792,'solvable').
real_status(799,'unsolvable').
real_status(800,'unsolvable').
real_status(803,'solvable').
real_status(810,'unknown').
real_status(811,'unknown').
real_status(813,'unsolvable').
real_status(818,'solvable').
real_status(819,'unknown').
real_status(820,'unsolvable').
real_status(821,'unknown').
real_status(822,'unsolvable').
real_status(827,'solvable').
real_status(828,'unknown').
real_status(829,'unknown').
real_status(830,'unsolvable').
real_status(832,'unknown').
real_status(833,'unknown').
real_status(835,'unknown').
real_status(836,'unknown').
real_status(837,'unknown').
real_status(838,'unknown').
real_status(843,'solvable').
real_status(844,'unknown').
real_status(845,'unknown').
real_status(849,'unknown').
real_status(850,'unknown').
real_status(851,'unknown').
real_status(854,'unknown').
real_status(855,'unknown').
real_status(856,'unknown').
real_status(858,'solvable').
real_status(859,'unknown').
real_status(860,'unknown').
real_status(861,'unknown').
real_status(862,'unknown').
real_status(863,'unknown').
real_status(864,'unknown').
real_status(865,'unknown').
real_status(866,'unknown').
real_status(867,'solvable').
real_status(872,'unsolvable').
real_status(877,'solvable').
real_status(878,'unknown').
real_status(879,'unknown').
real_status(880,'unknown').
real_status(882,'solvable').
real_status(884,'solvable').
real_status(885,'unknown').
real_status(886,'solvable').
real_status(888,'solvable').
real_status(891,'unknown').
real_status(892,'unknown').
real_status(893,'unknown').
real_status(897,'solvable').
real_status(903,'unsolvable').
real_status(905,'unsolvable').
real_status(908,'unsolvable').
real_status(913,'solvable').
real_status(914,'unsolvable').
real_status(915,'unknown').
real_status(916,'unknown').
real_status(918,'solvable').
real_status(924,'unknown').
real_status(926,'unknown').
real_status(927,'unsolvable').
real_status(932,'solvable').
real_status(933,'unknown').
real_status(934,'unknown').
real_status(935,'unsolvable').
real_status(936,'unknown').
real_status(938,'unknown').
real_status(940,'unknown').
real_status(941,'unknown').
real_status(942,'unknown').
real_status(943,'unknown').
real_status(948,'unknown').
real_status(949,'unknown').
real_status(950,'unknown').
real_status(954,'unknown').
real_status(955,'solvable').
real_status(956,'unknown').
real_status(959,'unknown').
real_status(960,'unknown').
real_status(961,'unknown').
real_status(963,'unknown').
real_status(964,'solvable').
real_status(965,'unknown').
real_status(966,'unknown').
real_status(967,'unknown').
real_status(968,'unknown').
real_status(969,'unknown').
real_status(970,'unknown').
real_status(971,'unknown').
real_status(973,'solvable').
real_status(974,'solvable').
real_status(976,'unknown').
real_status(977,'solvable').
real_status(978,'solvable').
real_status(982,'unknown').
real_status(983,'unknown').
real_status(984,'unknown').
real_status(988,'solvable').
real_status(994,'unsolvable').
real_status(995,'unsolvable').
real_status(999,'unsolvable').
real_status(1004,'solvable').
real_status(1005,'unsolvable').
real_status(1006,'unknown').
real_status(1007,'unknown').
real_status(1009,'unsolvable').
real_status(1014,'solvable').
real_status(1015,'unknown').
real_status(1016,'unsolvable').
real_status(1017,'unknown').
real_status(1018,'solvable').
real_status(1024,'unknown').
real_status(1025,'unknown').
real_status(1027,'unknown').
real_status(1028,'unknown').
real_status(1031,'unknown').
real_status(1032,'unknown').
real_status(1033,'unknown').
real_status(1034,'unknown').
real_status(1039,'unknown').
real_status(1040,'unknown').
real_status(1041,'unknown').
real_status(1045,'unknown').
real_status(1046,'unknown').
real_status(1047,'unknown').
real_status(1050,'unknown').
real_status(1051,'unknown').
real_status(1052,'solvable').
real_status(1054,'unknown').
real_status(1055,'unknown').
real_status(1056,'solvable').
real_status(1057,'unknown').
real_status(1058,'unknown').
real_status(1059,'unknown').
real_status(1060,'unknown').
real_status(1061,'unknown').
real_status(1062,'unknown').
real_status(1067,'unsolvable').
real_status(1072,'unsolvable').
real_status(1073,'unsolvable').
real_status(1074,'unsolvable').
real_status(1078,'unsolvable').
real_status(1083,'unsolvable').
real_status(1084,'unsolvable').
real_status(1085,'unsolvable').
real_status(1093,'solvable').
real_status(1094,'unknown').
real_status(1095,'unknown').
real_status(1102,'unknown').
real_status(1103,'solvable').
real_status(1104,'unknown').
real_status(1110,'unknown').
real_status(1111,'unknown').
real_status(1112,'solvable').
real_status(1116,'unsolvable').
real_status(1117,'unknown').
real_status(1118,'unknown').
real_status(1119,'unknown').
real_status(1123,'solvable').
real_status(1124,'unknown').
real_status(1125,'unknown').
real_status(1128,'unknown').
real_status(1129,'solvable').
real_status(1130,'unknown').
real_status(1132,'unknown').
real_status(1133,'unknown').
real_status(1134,'solvable').
real_status(1135,'unsolvable').
real_status(1136,'unsolvable').
real_status(1137,'unsolvable').
real_status(1138,'unknown').
real_status(1139,'unknown').
real_status(1140,'unknown').


/* ----------------------------------------------------------------- */

write_whitespace(_,[],_) :- !.
write_whitespace(Stream, [H|T], N) :- write_comma(N,Stream) ,write(Stream,H), 
                                     N1 is N+1, write_whitespace(Stream,T,N1). 

/* ----------------------------------------------------------------- */
                                                     
/* printing construction into a file */
print_construction_to_file(L,NDGs,DETs,RulesUsed,LemmasUsed,Time,Stream) :- write(Stream, 'Construction: '), nl(Stream),
/*write('XXX'),*/
print_steps_to_file(L,1,Stream), nl(Stream),
                                             /*write('AAA'),*/
                                             write(Stream, 'Non-degenerate conditions: '), write_prop_list(Stream,NDGs,1), write(Stream,'.'), nl(Stream),
                                             /*write('BBB'),*/
                                             write(Stream, 'Determination conditions: '), write_prop_list(Stream,DETs,1), write(Stream,'.'), nl(Stream), 
                                             /*write('CCC'),*/
                                             write(Stream, 'Rules used: '), write(Stream,RulesUsed), nl(Stream),
                                             /*write('DDD'),*/
                                             write(Stream, 'Definitions and lemmas used: '), write(Stream,LemmasUsed), nl(Stream), nl(Stream),
                                             write(Stream, 'Solving time: '), 
                                             format(Stream,'~1f',[Time]), /*write(Stream,Time),*/ write(Stream,' seconds.'), 
                                             nl(Stream), nl(Stream), !. 

/* ----------------------------------------------------------------- */

write_ndg_list_if_any(_,[]) :- !.
write_ndg_list_if_any(Stream,L) :- write(Stream,'% NDG: '), write_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_tex_ndg_list_if_any(_,[]) :- !.
write_tex_ndg_list_if_any(Stream,L) :- write(Stream,'\\% NDG: '), write_tex_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_html_ndg_list_if_any(_,[]) :- !.
write_html_ndg_list_if_any(Stream,L) :- write(Stream,'<p class="paragraph2"> % NDG: '), write_html_prop_list(Stream,L,1), write(Stream,'</p>').
           
/* ----------------------------------------------------------------- */

write_det_list_if_any(_,[]) :-!.
write_det_list_if_any(Stream,L) :- write(Stream,'% DET: '), write_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_tex_det_list_if_any(_,[]) :-!.
write_tex_det_list_if_any(Stream,L) :- write(Stream,' \\% DET: '), write_tex_prop_list(Stream,L,1).
           
/* ----------------------------------------------------------------- */

write_html_det_list_if_any(_,[]) :-!.
write_html_det_list_if_any(Stream,L) :- write(Stream,'<p class="paragraph2"> % DET: '), write_html_prop_list(Stream,L,1), write(Stream,'</p>').
           
/* ----------------------------------------------------------------- */
                                          
write_prop_list(_,[],_) :- !.
write_prop_list(Stream,[H|T],N) :- write_semicolon_to_file1(N,Stream), write_prop(Stream,H), N1 is N+1, write_prop_list(Stream,T,N1).

/* ----------------------------------------------------------------- */

write_tex_prop_list(_,[],_) :- !.
write_tex_prop_list(Stream,[H|T],N) :- write_semicolon_to_file1(N,Stream), write_tex_prop(Stream,H), N1 is N+1, write_tex_prop_list(Stream,T,N1).

/* ----------------------------------------------------------------- */

write_html_prop_list(_,[],_) :- !.
write_html_prop_list(Stream,[H|T],N) :- /*write_semicolon_to_file1(N,Stream),*/ write_html_prop(Stream,H), N1 is N+1, write_html_prop_list(Stream,T,N1).

/* ----------------------------------------------------------------- */

write_prop(Stream,not_true(identical_points(A,B))) :- !, write(Stream,' points '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_prop(Stream,not_true(identical_lines(A,B))) :- !, write(Stream,' lines '), 
                                                obj_name(obj(line,A),AN),
                                                obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_prop(Stream,not_true(identical_circles(A,B))) :- !, write(Stream,' circles '), 
                                                obj_name(obj(circle,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_prop(Stream,not_parallel(A,B)) :- !, write(Stream,' lines '), 
                                                obj_name(obj(line,A),AN),
                                                obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not parallel').
write_prop(Stream,intersect_line_circle(A,B)) :- !, write(Stream,' line '), 
                                                obj_name(obj(line,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and circle '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_prop(Stream,intersect_circle_circle(A,B)) :- !, write(Stream,' circles '), 
                                                obj_name(obj(circle,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_prop(Stream,not_true(inc(A,B))) :- !, write(Stream,' point '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is not incident to the line '),
                                                write(Stream,BN).
write_prop(Stream,out_of_circle(A,B)) :- !, write(Stream,' point '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is outside the circle '),
                                                write(Stream,BN).
write_prop(Stream,in_circle(A,B)) :- write(Stream,' point '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is inside the circle '),
                                                write(Stream,BN).
write_prop(Stream,razlicite(A,B)) :- write(Stream,' points '), 
                                                obj_name(obj(point,A),AN),
                                                obj_name(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream, ' and '),
                                                write(Stream,BN),
                                                write(Stream,' must be different').


/* ----------------------------------------------------------------- */

write_tex_prop(Stream,not_true(identical_points(A,B))) :- !, write(Stream,' points '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_tex_prop(Stream,not_true(identical_lines(A,B))) :- !, write(Stream,' lines '), 
                                                tex_obj_name(obj(line,A),AN),
                                                tex_obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_tex_prop(Stream,not_true(identical_circles(A,B))) :- !, write(Stream,' circles '), 
                                                tex_obj_name(obj(circle,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_tex_prop(Stream,not_parallel(A,B)) :- !, write(Stream,' lines '), 
                                                tex_obj_name(obj(line,A),AN),
                                                tex_obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not parallel').
write_tex_prop(Stream,intersect_line_circle(A,B)) :- !, write(Stream,' line '), 
                                                tex_obj_name(obj(line,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and circle '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_tex_prop(Stream,intersect_circle_circle(A,B)) :- !, write(Stream,' circles '), 
                                                tex_obj_name(obj(circle,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_tex_prop(Stream,not_true(inc(A,B))) :- !, write(Stream,' point '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is not incident to the line '),
                                                write(Stream,BN).
write_tex_prop(Stream,out_of_circle(A,B)) :- !, write(Stream,' point '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is outside the circle '),
                                                write(Stream,BN).
write_tex_prop(Stream,in_circle(A,B)) :- write(Stream,' point '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is inside the circle '),
                                                write(Stream,BN).
write_tex_prop(Stream,razlicite(A,B)) :- write(Stream,' points '), 
                                                tex_obj_name(obj(point,A),AN),
                                                tex_obj_name(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream, ' and '),
                                                write(Stream,BN),
                                                write(Stream,' must be different').

/* ----------------------------------------------------------------- */

write_html_prop(Stream,not_true(identical_points(A,B))) :- !, write(Stream,' points '), 
                                                obj_name_html(obj(point,A),AN),
                                                obj_name_html(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_html_prop(Stream,not_true(identical_lines(A,B))) :- !, write(Stream,' lines '), 
                                                obj_name_html(obj(line,A),AN),
                                                obj_name_html(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_html_prop(Stream,not_true(identical_circles(A,B))) :- !, write(Stream,' circles '), 
                                                obj_name_html(obj(circle,A),AN),
                                                obj_name_html(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not the same').
write_html_prop(Stream,not_parallel(A,B)) :- !, write(Stream,' lines '), 
                                                obj_name_html(obj(line,A),AN),
                                                obj_name_html(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' are not parallel').
write_html_prop(Stream,intersect_line_circle(A,B)) :- !, write(Stream,' line '), 
                                                obj_name_html(obj(line,A),AN),
                                                obj_name_html(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and circle '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_html_prop(Stream,intersect_circle_circle(A,B)) :- !, write(Stream,' circles '), 
                                                obj_name_html(obj(circle,A),AN),
                                                obj_name_html(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' and '),
                                                write(Stream,BN),
                                                write(Stream,' intersect').
write_html_prop(Stream,not_true(inc(A,B))) :- !, write(Stream,' point '), 
                                                obj_name_html(obj(point,A),AN),
                                                obj_name_html(obj(line,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is not incident to the line '),
                                                write(Stream,BN).
write_html_prop(Stream,out_of_circle(A,B)) :- !, write(Stream,' point '), 
                                                obj_name_html(obj(point,A),AN),
                                                obj_name_html(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is outside the circle '),
                                                write(Stream,BN).
write_html_prop(Stream,in_circle(A,B)) :- write(Stream,' point '), 
                                                obj_name_html(obj(point,A),AN),
                                                obj_name_html(obj(circle,B),BN),
                                                write(Stream,AN),
                                                write(Stream,' is inside the circle '),
                                                write(Stream,BN).
write_html_prop(Stream,razlicite(A,B)) :- write(Stream,' points '), 
                                                obj_name_html(obj(point,A),AN),
                                                obj_name_html(obj(point,B),BN),
                                                write(Stream,AN),
                                                write(Stream, ' and '),
                                                write(Stream,BN),
                                                write(Stream,' must be different').


/* ----------------------------------------------------------------- */

/* printing construction steps into a file */
print_steps_to_file([],_,Stream)                       :- write(Stream,'.'), nl(Stream), !.
print_steps_to_file([(_,C,[H],_,_,_,'WOnline1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline1'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline1) '),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline1'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H],_,_,_,'WOnline2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline2'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline2)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline2'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H],_,_,_,'WOnline3',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline3'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline3)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline3'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H],_,_,_,'WOnline4',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline4'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline4)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline4'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle1'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle1'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle2'),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle2'),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([([],_,[H1|T1],_,_,_,Id,_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write(Id),*/
                                                         write(Stream,N), write(Stream,'. Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' (rule '), write(Stream,Id),
                                                         write(Stream, ')'),
                                                         N1 is N+1, 
                                                         /*write('prosao'), write(Id),*/
                                                         print_steps_to_file(O,N1,Stream).
print_steps_to_file([([H|T],_,[H1|T1],_,NDG,DET,Id,_)|O],N,Stream) :- 
                                                            write_semicolon_to_file(N,Stream),
                                                            /*nl, write(Id),*/
                                                            write(Stream,N), write(Stream,'. Using '),
                                                            eliminate_duplicates([H|T],L1),
                                                            write_tex_def_objs_to_file(L1,Stream), 
                                                            write(Stream,', construct '),
                                                            eliminate_duplicates([H1|T1],L2),
                                                            write_tex_indef_objs_to_file(L2,Stream),
                                                            write(Stream, ' (rule '), write(Stream,Id),
                                                            write(Stream,'); '),  
                                                            write_ndg_list_if_any(Stream,NDG),
                                                            write_det_list_if_any(Stream,DET),
                                                            N1 is N+1, 
                                                            /*write('prosao'), write(Id), nl,*/
                                                            print_steps_to_file(O,N1,Stream).


/* ----------------------------------------------------------------- */

print_tex_steps_to_file_if_any([],_,_) :- !.
print_tex_steps_to_file_if_any(L,N,Stream) :- write(Stream,'\\begin{enumerate}'), nl(Stream),
                                              print_tex_steps_to_file(L,N,Stream),
                                              write(Stream,'\\end{enumerate}'), nl(Stream).


/* ----------------------------------------------------------------- */

/* printing construction steps into a tex file */
print_tex_steps_to_file([],_,Stream)                       :- write(Stream,'.'), nl(Stream), !.
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline1'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline1) '),
                                                         /*write('prosao wonline1'),*/
                                                         N1 is N+1,
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline2'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline2)'),
                                                         /*write('prosao wonline2'),*/
                                                         N1 is N+1,
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline3',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline3'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline3)'),
                                                         /*write('prosao wonline3'),*/
                                                         N1 is N+1,
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H],_,_,_,'WOnline4',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('wonline4'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline4)'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline4'),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle1',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle1'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle1'),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle2',_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write('woncircle2'),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_tex_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle)'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle2'),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([([],_,[H1|T1],_,_,_,Id,_)|O],N,Stream) :- 
                                                         !, write_semicolon_to_file(N,Stream),
                                                         /*write(Id),*/
                                                         write(Stream,'\\item '), write(Stream,'Choose freely '), 
                                                         write_tex_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' (rule '), write(Stream,Id),
                                                         write(Stream, ')'),
                                                         N1 is N+1, 
                                                         /*write('prosao'), write(Id),*/
                                                         print_tex_steps_to_file(O,N1,Stream).
print_tex_steps_to_file([([H|T],_,[H1|T1],_,NDG,DET,Id,_)|O],N,Stream) :- 
                                                            write_semicolon_to_file(N,Stream),
                                                            /*nl, write(Id),*/
                                                            write(Stream,'\\item '), write(Stream,'Using '),
                                                            eliminate_duplicates([H|T],L1),
                                                            write_tex_def_objs_to_file(L1,Stream), 
                                                            write(Stream,', construct '),
                                                            eliminate_duplicates([H1|T1],L2),
                                                            write_tex_indef_objs_to_file(L2,Stream),
                                                            write(Stream, ' (rule '), write(Stream,Id),
                                                            write(Stream,'); '),  
                                                            write_tex_ndg_list_if_any(Stream,NDG),
                                                            write_tex_det_list_if_any(Stream,DET),
                                                            N1 is N+1, 
                                                            /*write('prosao'), write(Id), nl,*/
                                                            print_tex_steps_to_file(O,N1,Stream).

/* ----------------------------------------------------------------- */

print_html_steps_to_file_if_any([],_,_) :- !.
print_html_steps_to_file_if_any(L,N,Stream) :- write(Stream,'<ol id="steps">'), nl(Stream),
                                              print_html_steps_to_file(L,N,Stream),
                                              write(Stream,'</ol>'), nl(Stream).


/* ----------------------------------------------------------------- */

/* printing construction steps into a html file */
print_html_steps_to_file([],_,Stream)                       :- nl(Stream), !.
print_html_steps_to_file([(_,C,[H],_,_,_,'WOnline1',_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write('wonline1'),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_html_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline1) </p>'),
                                                         /*write('prosao wonline1'),*/
                                                         N1 is N+1,
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([(_,C,[H],_,_,_,'WOnline2',_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write('wonline2'),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_html_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline2) </p>'),
                                                         /*write('prosao wonline2'),*/
                                                         N1 is N+1,
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([(_,C,[H],_,_,_,'WOnline3',_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write('wonline3'),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_html_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline3) </p>'),
                                                         /*write('prosao wonline3'),*/
                                                         N1 is N+1,
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([(_,C,[H],_,_,_,'WOnline4',_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write('wonline4'),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H],Stream),
                                                         write(Stream, ' on '), write_html_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOnline4) </p>'),
                                                         N1 is N+1, 
                                                         /*write('prosao wonline4'),*/
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle1',_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write('woncircle1'),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_html_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle) </p>'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle1'),*/
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([(_,C,[H1|T1],_,_,_,'WOncircle2',_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write('woncircle2'),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' on '), write_html_def_objs_to_file(C,Stream),
                                                         write(Stream, ' (rule WOncircle) </p>'),
                                                         N1 is N+1, 
                                                         /*write('prosao woncircle2'),*/
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([([],_,[H1|T1],_,_,_,Id,_)|O],N,Stream) :- 
                                                         !, nl(Stream),
                                                         /*write(Id),*/
                                                         write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Choose freely '), 
                                                         write_html_indef_objs_to_file([H1|T1],Stream),
                                                         write(Stream, ' (rule '), write(Stream,Id),
                                                         write(Stream, ') </p>'),
                                                         N1 is N+1, 
                                                         /*write('prosao'), write(Id),*/
                                                         print_html_steps_to_file(O,N1,Stream).
print_html_steps_to_file([([H|T],_,[H1|T1],_,NDG,DET,Id,_)|O],N,Stream) :- 
                                                            nl(Stream),
                                                            /*nl, write(Id),*/
                                                            write(Stream,'<li> <p class="paragraph1">'), write(Stream,'Using '),
                                                            eliminate_duplicates([H|T],L1),
                                                            write_html_def_objs_to_file(L1,Stream), 
                                                            write(Stream,', construct '),
                                                            eliminate_duplicates([H1|T1],L2),
                                                            write_html_indef_objs_to_file(L2,Stream),
                                                            write(Stream, ' (rule '), write(Stream,Id),
                                                            write(Stream,'); </p> '),  
                                                            write_html_ndg_list_if_any(Stream,NDG),
                                                            write_html_det_list_if_any(Stream,DET),
                                                            N1 is N+1, 
                                                            /*write('prosao'), write(Id), nl,*/
                                                            print_html_steps_to_file(O,N1,Stream).


/* ----------------------------------------------------------------- */

/* eliminates duplicates in list of objects */
eliminate_duplicates([],[]) :- !.
eliminate_duplicates([H|T],T1) :- element(H,T), !, eliminate_duplicates(T,T1). 
eliminate_duplicates([H|T],[H|T1]) :- eliminate_duplicates(T,T1). 

/* ----------------------------------------------------------------- */

/* each line, except the last one is ended by ';' */
write_semicolon_to_file(1,_)      :- !.
write_semicolon_to_file(_,Stream) :- write(Stream,';'), nl(Stream).

/* ----------------------------------------------------------------- */

/* each line, except the last one is ended by ';' without new line */
write_semicolon_to_file1(1,_)      :- !.
write_semicolon_to_file1(_,Stream) :- write(Stream,';').

/* ------------------------------------------------------------------ */

/* write comma between objects  to stdout */
write_comma(1) :- !.
write_comma(_) :- write(', ').

/* ------------------------------------------------------------------ */

/* write comma between objects  to stream */
write_comma(1,_) :- !.
write_comma(_,Stream) :- write(Stream,', ').

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_def_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'the '), write(Stream,Type),  write(Stream,' '), 
                                           obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_tex_def_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'the '), write(Stream,Type),  write(Stream,' '), 
                                           tex_obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_html_def_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'the '), write(Stream,Type),  write(Stream,' '), 
                                           obj_name_html(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_and_def_objs_to_file([],_)      :- !.
write_and_def_objs_to_file([H],Stream):- write(Stream,' and '), write_def_obj_to_file(H,Stream), !.
write_and_def_objs_to_file([H|T],Stream):- write(Stream,', '), write_def_obj_to_file(H,Stream), 
                                       write_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_tex_and_def_objs_to_file([],_)      :- !.
write_tex_and_def_objs_to_file([H],Stream):- write(Stream,' and '), write_tex_def_obj_to_file(H,Stream), !.
write_tex_and_def_objs_to_file([H|T],Stream):- write(Stream,', '), write_tex_def_obj_to_file(H,Stream), 
                                       write_tex_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_html_and_def_objs_to_file([],_)      :- !.
write_html_and_def_objs_to_file([H],Stream):- write(Stream,' and '), write_html_def_obj_to_file(H,Stream), !.
write_html_and_def_objs_to_file([H|T],Stream):- write(Stream,', '), write_html_def_obj_to_file(H,Stream), 
                                       write_html_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_def_objs_to_file([], _) :- !.
write_def_objs_to_file([H|T],Stream):- write_def_obj_to_file(H,Stream), 
                                   write_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_tex_def_objs_to_file([], _) :- !.
write_tex_def_objs_to_file([H|T],Stream):- write_tex_def_obj_to_file(H,Stream), 
                                   write_tex_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_html_def_objs_to_file([], _) :- !.
write_html_def_objs_to_file([H|T],Stream):- write_html_def_obj_to_file(H,Stream), 
                                   write_html_and_def_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_indef_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'a '), write(Stream,Type),  write(Stream,' '), 
                                           obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_tex_indef_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'a '), write(Stream,Type), write(Stream,' '),
                                           tex_obj_name(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a formatted object name preceeded by its type to a file */
write_html_indef_obj_to_file(obj(Type,Obj),Stream) :- write(Stream,'a '), write(Stream,Type), write(Stream,' '),
                                           obj_name_html(obj(Type,Obj),Name), write(Stream,Name), !.

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_and_indef_objs_to_file([],_)      :- !.
write_and_indef_objs_to_file([H],Stream) :- write(Stream,' and '), write_indef_obj_to_file(H,Stream), !.
write_and_indef_objs_to_file([H|T],Stream):- write(Stream,', '), write_indef_obj_to_file(H,Stream), 
                                       write_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_tex_and_indef_objs_to_file([],_)      :- !.
write_tex_and_indef_objs_to_file([H],Stream) :- write(Stream,' and '), write_tex_indef_obj_to_file(H,Stream), !.
write_tex_and_indef_objs_to_file([H|T],Stream):- write(Stream,', '), write_tex_indef_obj_to_file(H,Stream), 
                                       write_tex_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects preceeded by a connective 'and' to a file */
write_html_and_indef_objs_to_file([],_)      :- !.
write_html_and_indef_objs_to_file([H],Stream) :- write(Stream,' and '), write_html_indef_obj_to_file(H,Stream), !.
write_html_and_indef_objs_to_file([H|T],Stream):- write(Stream,', '), write_html_indef_obj_to_file(H,Stream), 
                                       write_html_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_indef_objs_to_file([], _) :- !.
write_indef_objs_to_file([H|T],Stream):- write_indef_obj_to_file(H,Stream), 
                                   write_and_indef_objs_to_file(T,Stream).


/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_tex_indef_objs_to_file([], _) :- !.
write_tex_indef_objs_to_file([H|T],Stream):- write_tex_indef_obj_to_file(H,Stream), 
                                   write_tex_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of formatted objects connected by a connective 'and' to a file */
write_html_indef_objs_to_file([], _) :- !.
write_html_indef_objs_to_file([H|T],Stream):- write_html_indef_obj_to_file(H,Stream), 
                                   write_html_and_indef_objs_to_file(T,Stream).

/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a standard output */
write_list([],_) :- !.
write_list([H|T],N) :- write_comma(N), obj_name(H,H1), write(H1), N1 is N+1, write_list(T,N1).

/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a standard output */
write_tex_list([],_) :- !.
write_tex_list([H|T],N) :- write_comma(N), tex_obj_name(H,H1), write(H1), N1 is N+1, write_tex_list(T,N1).


/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a stream */
write_list([],_,_) :- !.
write_list([H|T],N,Stream) :- write_comma(N,Stream), obj_name(H,H1), write(Stream,H1), N1 is N+1, write_list(T,N1,Stream).

/* ----------------------------------------------------------------- */

/* write a list of object names in html form separated by commas to a stream */
write_list_html([],_,_) :- !.
write_list_html([H|T],N,Stream) :- write_comma(N,Stream), obj_name_html(H,H1), write(Stream,H1), N1 is N+1, write_list_html(T,N1,Stream).


/* ----------------------------------------------------------------- */

/* write a list of object names separated by commas to a stream */
write_tex_list([],_,_) :- !.
write_tex_list([H|T],N,Stream) :- write_comma(N,Stream), tex_obj_name(H,H1), write(Stream,H1), N1 is N+1, write_tex_list(T,N1,Stream).

/* ----------------------------------------------------------------- */

/* removes an element from the list */
remove_one(_,[],[])         :- !.
remove_one(H,[H|T],T)       :- !.
remove_one(H,[H1|T],[H1|R]) :- remove_one(H,T,R).

/* ----------------------------------------------------------------- */

/* removes all elements of the first list from the second */
myremove([],L,L)    :- !.
myremove([H|T],L,R) :- remove_one(H,L,R1), myremove(T,R1,R).

/* ----------------------------------------------------------------- */

/* appending a list to another */
myappend([],X,X)         :- !.
myappend([H|T],X,[H|T1]) :- myappend(T,X,T1).

/* ----------------------------------------------------------------- */

/* making union of two lists, two variants */
myunion([],L,L)         :- !.
myunion([H|T],L,[H|L1]) :- not_element(H,L), myunion(T,L,L1).
myunion([H|T],L,L1)     :- element(H,L), myunion(T,L,L1).

myunion1(L,[],L)     :- !.
myunion1(L,[H|T],L2) :- not_element(H,L), add2end(H,L,L1), myunion1(L1,T,L2).
myunion1(L,[H|T],L1) :- element(H,L), myunion1(L,T,L1).

/* ----------------------------------------------------------------- */

/* adding element to the end of the list */
add2end(X,[H|T],[H|NewT]) :- add2end(X,T,NewT).
add2end(X,[],[X]).
                  
/* ----------------------------------------------------------------- */

/* checking if the object is an element of the list */
element(O,[H|_]) :- equal(H,O).
element(O,[_|T]) :- element(O,T).

/* ----------------------------------------------------------------- */

/* checking if the object is not an element of the list */
not_element(H,L) :- element(H,L), !, fail.
not_element(_,_).

/* ----------------------------------------------------------------- */

/* checking if the object is not a number */
not_number(H) :- number(H), !, fail.
not_number(_).

/* ----------------------------------------------------------------- */

/* determining which elements of the first list occur in the second list;
   both lists do not contain variables */
in_list([],_,[]).
in_list([H|T],L1,[H|T1]) :- element(H,L1), !, in_list(T,L1,T1).
in_list([_|T],L1,L2)     :- in_list(T,L1,L2).

/* ----------------------------------------------------------------- */

/* determining which elements of the first list occur in the second list */
in_list1([],_,[]).
in_list1([H|T],L1,[H|T1]) :- element(H,L1), in_list1(T,L1,T1).
in_list1([_|T],L1,L2)     :- in_list1(T,L1,L2).


/* ----------------------------------------------------------------- */

/* determining which elements of the first list do not occur in the second list */
not_in_list([],_,[]).
not_in_list([H|T],L1,[H|R]) :- not_element(H,L1), !, not_in_list(T,L1,R).
not_in_list([_|T],L1,R)     :- not_in_list(T,L1,R).
 
/* ----------------------------------------------------------------- */

/* instantiation of the second list with the elements of the first list */
instantiate(_,[])     :-!.
instantiate(L1,[H|T]) :- element(H,L1), instantiate(L1,T).

/* ----------------------------------------------------------------- */

/* checking if the second list is a sublist of the first list */
mysublist(_,[])     :- !.
mysublist(L1,[H|T]) :- element_and_decompose(L1,H,A,B), myappend(A,B,L2), mysublist(L2,T).
/* unified element is deleted from the first list, 
   in order not to be able to instantiate different elements with the same one */

/* ----------------------------------------------------------------- */

/* checking if the second list is not a sublist of the first list */
not_mysublist(L,L1) :- mysublist(L,L1), !, fail.
not_mysublist(_,_).

/* ----------------------------------------------------------------- */

/* checking if the second list is a sublist of the first list */
mysublist_def_lemma(_,[],_)        :- !.
mysublist_def_lemma(L1,[H|T],Perm) :- element_and_decompose_def_lemma(L1,H,A,B,Perm), myappend(A,B,L2), 
                                      /*write('poziv mysublist za '), write(L2), nl, write(T), nl, write(Perm), nl, */
                                      mysublist_def_lemma(L2,T,Perm).
/* unified element is deleted from the first list, 
   in order not to be able to instantiate different elements with the same one */

mysublist_def_lemma_inv(_,[],_)        :- !.
mysublist_def_lemma_inv(L1,[H|T],Perm) :- element_and_decompose_def_lemma_inv(L1,H,A,B,Perm), myappend(A,B,L2), mysublist_def_lemma_inv(L2,T,Perm).

/* ----------------------------------------------------------------- */

/* checking if the element E occurs in the list [H|T],
   if it occurs - list is decomposed into two lists: 
   one with elements before and one with elements after it */
element_and_decompose([],_,[],[])       :- !, fail.
element_and_decompose([H|T],E,[],T)     :- equal(H,E).
element_and_decompose([H|T],E,[H|T1],L) :- element_and_decompose(T,E,T1,L).

/* ----------------------------------------------------------------- */

/* checking if the element E occurs in the list [H|T],
   if it occurs - list is decomposed into two lists: 
   one with elements before and one with elements after it */
element_and_decompose_def_lemma([],_,[],[],_)          :- !, fail.
element_and_decompose_def_lemma([H|T],E,[],T,Perm)     :- equal_def_lemma(H,E,Perm) /*write('proslo equal '), write(H), nl, write(E), write(Perm), nl */.
element_and_decompose_def_lemma([H|T],E,[H|T1],L,Perm) :- element_and_decompose_def_lemma(T,E,T1,L,Perm).

element_and_decompose_def_lemma_inv([],_,[],[],_)          :- !, fail.
element_and_decompose_def_lemma_inv([H|T],E,[],T,Perm)     :- equal_def_lemma(E,H,Perm).
element_and_decompose_def_lemma_inv([H|T],E,[H|T1],L,Perm) :- element_and_decompose_def_lemma_inv(T,E,T1,L,Perm).

/* ----------------------------------------------------------------- */

/* testing if a term is not compound */
non_compound(X) :- compound(X), !, fail.
non_compound(_).

/* ----------------------------------------------------------------- */

/* checking if two terms are equal in the way I like
   examples: equal(A,a), equal(f(A),f(a)), 
             equal(f([a,b,c]),f([c,a,b])), equal(f([a,b,[c,d]]),f([[d,c],b,a])) */

equal(A,B)           :- non_compound(A), A = B, !.
equal(A,B)           :- non_compound(B), A = B, !.
equal([H|T],[H1|T1]) :- !, mysublist([H|T],[H1|T1]), mysublist([H1|T1],[H|T]). 
equal(A,B)           :- compound(A), compound(B), functor(A,FA,NOA), functor(B,FB,NOB), 
                        FA = FB, NOA = NOB, all_n_equal(A,B,NOA).

/* ----------------------------------------------------------------- */

/* checking if all arguments of compound term are equal */

all_n_equal(_,_,N) :- N = 0, !.
all_n_equal(A,B,N) :- arg(N,A,ArgA), arg(N,B,ArgB), 
                      equal(ArgA,ArgB), 
                      N1 is N-1, all_n_equal(A,B,N1).

/* ----------------------------------------------------------------- */

/* checking if two terms are equal with regard to definitions and lemmas
   examples: equal(centroid([a,c],b),centroid([a,b],c)) */
equal_def_lemma(A,B,_)              :- non_compound(A), 
                                       A = B, !.
equal_def_lemma(A,B,_)              :- non_compound(B), 
                                       A = B, !.
equal_def_lemma([H|T],[H1|T1],Perm) :- !, mysublist_def_lemma([H|T],[H1|T1],Perm), 
                                       mysublist_def_lemma_inv([H1|T1],[H|T],Perm).
equal_def_lemma(A,B,Perm)           :- equal_points(A,B,Perm). 
                                       /* ZA SAD SU U POSTAVCI ZADATAKA SAMO TACKE, PA JE OVO OK */

/* ----------------------------------------------------------------- */

/* checking if all arguments of compound term are equal */
all_n_equal_def_lemma(_,_,N,_)    :- N = 0, !.
all_n_equal_def_lemma(A,B,N,Perm) :- arg(N,A,ArgA), arg(N,B,ArgB), 
                                     equal_def_lemma(ArgA,ArgB,Perm), 
                                     N1 is N-1, all_n_equal_def_lemma(A,B,N1,Perm).

/* ----------------------------------------------------------------- */

/* checking if two terms are different */
notequal(A,B) :- equal(A,B), !, fail.
notequal(_,_).

/* ----------------------------------------------------------------- */

/* checking if two terms are different */
notequal_def(A,B,Perm) :- equal_def(A,B,Perm), !, fail.
notequal_def(_,_,_).

/* ----------------------------------------------------------------- */

/* collecting all lines equal to the given one */
all_equal_lines(L,All,All1) :- equal_lines(L,L1), not_element(obj(line,L1),All), !,
                               /* write('DODAJEMO PRAVU '), write(L1), nl, */
                               all_equal_lines(L,[obj(line,L1)|All],All1).
all_equal_lines(_,All,All). 

/* ----------------------------------------------------------------- */

/* collecting all circles equal to the given one */
all_equal_circles(L,All,All1) :- equal_circles(L,L1), not_element(obj(circle,L1),All), !,
                                 /* write('DODAJEMO KRUG '), write(L1), nl, */
                                 all_equal_circles(L,[obj(circle,L1)|All],All1).
all_equal_circles(_,All,All). 

/* --------------------------------------------------------y--------- */

/* collecting all lines and circles through the given point */
lines_and_circles_through_point(X,Objs,Objs1) :- def_or_lemma(inc(X,P),_), not_element(obj(line,P),Objs), !,
                                                 /* write('POZIVAMO ALL EQUAL LINES ZA PRAVU '), write(P), nl, */
                                                 all_equal_lines(P,[],Lines), myunion(Lines,Objs,All),
                                                 /* write('PRAVI SE UNIJA: '), write(All), nl, */
                                                 lines_and_circles_through_point(X,All,Objs1).
lines_and_circles_through_point(X,Objs,Objs1) :- def_or_lemma(inc_k(X,C),_), not_element(obj(circle,C),Objs), !,
                                                 /* write('POZIVAMO ALL EQUAL CIRCLES ZA KRUG '), write(C), nl, */
                                                 all_equal_circles(C,[],Circles), myunion(Circles,Objs,All),
                                                 /* write('PRAVI SE UNIJA: '), write(All), nl, */
                                                 lines_and_circles_through_point(X,All,Objs1).
lines_and_circles_through_point(_,Objs,Objs) :- !.

/* ----------------------------------------------------------------- */

/* checking if a problem is locus-dependent */
locus_dependent_problem(N,RulesUsed,LemmasUsed) :- problem_setting(N,Name,Known,Unknown),
                              ld_triple(N,Name,Known,Unknown,RulesUsed,LemmasUsed).
                              
ld_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se ld_triple za: '), write(X), nl, 
                                /*X=obj(point,XN),
                                lines_and_circles_through_point(XN,[],All),*/
                                construct2([Y,Z],X,Name,N,Unknown,RulesUsed,LemmasUsed), 
                                !.

ld_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se ld_triple za: '), write(Y), nl,
                                /*Y=obj(point,YN),
                                lines_and_circles_through_point(YN,[],All),*/
                                construct2([X,Z],Y,Name,N,Unknown,RulesUsed,LemmasUsed), 
                                !.

ld_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se ld_triple za: '), write(Z), nl,
                                /*Z=obj(point,ZN), 
                                lines_and_circles_through_point(ZN,[],All),*/
                                construct2([X,Y],Z,Name,N,Unknown,RulesUsed,LemmasUsed), 
                                !.

/* ----------------------------------------------------------------- */

/* checking if a problem is redundant */
redundant_problem(N,RulesUsed,LemmasUsed) :- problem_setting(N,Name,Known,Unknown), 
                        redundant_triple(N,Name,Known,Unknown,RulesUsed,LemmasUsed).

/* checking if a triple is redundant -- if one of the elements is constructible from the others */
redundant_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se redundant_triple za: '), write(X), nl,
                                       construct1([Y,Z],[X],Name,N,Unknown,RulesUsed,LemmasUsed), !.
redundant_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se redundant_triple za: '), write(Y), nl,
                                       construct1([X,Z],[Y],Name,N,Unknown,RulesUsed,LemmasUsed), !.
redundant_triple(N,Name,[X,Y,Z],Unknown,RulesUsed,LemmasUsed) :- nl, write('poziva se redundant_triple za: '), write(Z), nl,
                                       construct1([X,Y],[Z],Name,N,Unknown,RulesUsed,LemmasUsed), !.

/* ----------------------------------------------------------------- */

/* checking if problem is not symmetric */
not_symmetric(N) :- symmetric(N), !, fail.
not_symmetric(_).

/* ----------------------------------------------------------------- */

/* checking if a problem is symmetric to some previous */
/* we compare a problem only to the problems from the corpora it belongs to  */
symmetric_problem(N,Stream) :- N>1140, !, /*write('pokusavamo za: '), flush, */ symmetric_problems(N,1141,Stream). 
symmetric_problem(N,Stream) :- N>560, N=<1140, !, /*write('pokusavamo za: '), flush,*/ symmetric_problems(N,561,Stream). 
symmetric_problem(N,Stream) :- N<1000, !, /*write('pokusavamo za: '), flush,*/ symmetric_problems(N,1,Stream). 

/* ----------------------------------------------------------------- */

symmetric_problems(N,M,_)      :- N==M, !.
symmetric_problems(N,M,Stream) :- not_symmetric(M), /* there is no point in finding symmetric problems to already symmetric ones */
                                  problem_setting(N,_,NKnown,_), 
                                  problem_setting(M,_,MKnown,_),
                                  without_type(NKnown,NObj),
                                  without_type(MKnown,MObj),
                                  permutation(Perm), 
                                  substitute(NObj,Perm,NNew),
                                  equal_ld(NNew,MObj,Perm,Stream), 
                                  !, 
                                  assert(symmetric(N)),
                                  write('to the problem '), write(M),
                                  write(Stream,'('), write(Stream,M), write(Stream,')$) '),
                                  write(' for the permutation '), write(Perm), nl.
symmetric_problems(N,M,Stream) :- /*write(M), write(' '), flush,*/
                                  M1 is M+1, symmetric_problems(N,M1,Stream).

/* ----------------------------------------------------------------- */

/* equality regarding definitions only, or both definitions and lemmas */
equal_ld(L1,L2,_,Stream)    :- equal(L1,L2), 
                               write('Symmetric with regard to definitions only '), 
                               tab(Stream,3),
                               write(Stream,'($S_d'), !.
equal_ld(L1,L2,Perm,Stream) :- equal_def_lemma(L1,L2,Perm), 
                               write('Symmetric with regard to definitions and lemmas '), 
                               tab(Stream,3),
                               write(Stream,'($S_{dl}'), !.

/* ----------------------------------------------------------------- */

/* two points are equal if they belong to two same lines */
equal_points(A,B,Perm) :- def_or_lemma_perm(inc(A,L1),Perm),
                          def_or_lemma(inc(B,L2),_), 
                          equal(L1,L2),   
                          def_or_lemma_perm(inc(A,L3),Perm), 
                          notequal(L1,L3),
                          /*notequal(L2,L3),*/ 
                          not_equal_lines(L1,L3),
                          /*not_equal_lines(L2,L3),*/
                          def_or_lemma(inc(B,L4),_),
                          equal(L3,L4),
                          notequal(L1,L4),
                          not_equal_lines(L1,L4),
                          notequal(L2,L4),
                          not_equal_lines(L2,L4),
                          !.

/* ----------------------------------------------------------------- */

/* definition or a lemma with applied permutation */
def_or_lemma_perm(PropPerm,Perm) :- def_or_lemma(Prop,_), substitute(Prop,Perm,PropPerm).

/* ----------------------------------------------------------------- */

/* list of objects given without their types */
without_type([],[]) :- !.
without_type([obj(_,X)|T],[X|T1]) :- without_type(T,T1).

/* ----------------------------------------------------------------- */

/* all possible permutations of a triple [a b c] */
permutation([a,c,b]).
permutation([b,a,c]).
permutation([b,c,a]).
permutation([c,a,b]).
permutation([c,b,a]).

inverse_permutation([a,c,b],[a,c,b]) :- !.
inverse_permutation([b,a,c],[b,a,c]) :- !.
inverse_permutation([b,c,a],[c,a,b]) :- !.
inverse_permutation([c,a,b],[b,c,a]) :- !.
inverse_permutation([c,b,a],[c,b,a]) :- !.

/* ----------------------------------------------------------------- */

/* substitution in a given term using a permutation of [a,b,c] (given as a second argument of a predicate) */
substitute([],_,[])         :- !.
substitute(a,[A,_,_],A)     :- !.
substitute(b,[_,B,_],B)     :- !.
substitute(c,[_,_,C],C)     :- !.
substitute([H|T],L,[H1|T1]) :- !, substitute(H,L,H1), substitute(T,L,T1). 
substitute(X,L,Y)           :- compound(X), !, functor(X,FX,NOX), functor(Y,FX,NOX), substitute_n(X,L,Y,NOX).

/* ----------------------------------------------------------------- */

substitute_n(_,_,_,N) :- N = 0, !.
substitute_n(A,L,B,N) :- arg(N,A,ArgA),  
                         substitute(ArgA,L,ArgB), 
                         arg(N,B,ArgB),
                         N1 is N-1, substitute_n(A,L,B,N1).

/* ----------------------------------------------------------------- */

print_list_to_stdout([])    :- !.
print_list_to_stdout([H|T]) :- write(H), nl, print_list_to_stdout(T).

/* ----------------------------------------------------------------- */

not_member(X,L) :- member(X,L), !, fail.
not_member(_,_).
