#include <iostream>
#include <vector>

std::vector<int> calculate_preffix_sums(const std::vector<int> &a)
{
    std::vector<int> preffix_sums(a.size());

    preffix_sums[0] = a[0];

    int n = a.size();

    for (int i = 1; i < n; i++) {
        preffix_sums[i] = preffix_sums[i - 1] + a[i];
    }

    return preffix_sums;
}

int main ()
{
    int n, q;

    std::cin >> n >> q;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::vector<int> preffix_sums = calculate_preffix_sums(a);

    int l, r;
    while (q != 0) {
        std::cin >> l >> r;
        std::cout << preffix_sums[r] - preffix_sums[l - 1] << "\n";
        q--;
    }

    // Alternative solution
    // while (q--) {
    //     std::cin >> l >> r;
    //     std::cout << preffix_sums[r] - preffix_sums[l - 1];
    // }

    return 0;
}