#include <iostream>
#include <vector>

std::vector<int> calculate_preffix_sums(const std::vector<int> &A)
{
    std::vector<int> preffix_sums(A.size());

    preffix_sums[0] = A[0];

    int n = A.size();

    for (int i = 1; i < n; i++) {
        preffix_sums[i] = preffix_sums[i - 1] + A[i];
    }

    return preffix_sums;
}

std::vector<int> calculate_suffix_sums(const std::vector<int> &B)
{
    std::vector<int> suffix_sums(B.size());

    int n = B.size();

    suffix_sums[n - 1] = B[n - 1];

    for (int i = n - 2; i >= 0; i--) {
        suffix_sums[i] = suffix_sums[i + 1] + B[i];
    }

    return suffix_sums;
}

int main ()
{
    int n;

    std::cin >> n;

    std::vector<int> A(n), B(n);

    for (int i = 0; i < n; i++) {
        std::cin >> A[i];
    }

    for (int i = 0; i < n; i++) {
        std::cin >> B[i];
    }

    std::vector<int> preffix_sums = calculate_preffix_sums(A);
    std::vector<int> suffix_sums = calculate_suffix_sums(B);

    int counter = 0;

    for (int i = 0, j = n - 1; i < n; i++, j--) {
        if (preffix_sums[i] == suffix_sums[j]) {
            counter++;
        }
    }

    // for (int i = 0; i < n; i++) {
    //     if (preffix_sums[i] == suffix_sums[n - 1 - i]) {
    //         counter++;
    //     }
    // }

    std::cout << counter << "\n";

    return 0;
}