#include <iostream>
#include <algorithm>
#include <vector>

int dominant_element(std::vector<int> a)
{
    std::sort(a.begin(), a.end());

    int current = a[0], num_of_occurences = 0, max_num_of_occurences = 0;
    int candidate = a[0];

    int n = a.size();

    for (int i = 0; i < n; i++) {
        if (a[i] == current) {
            num_of_occurences++;
        }
        else {
            if (num_of_occurences > max_num_of_occurences) {
                max_num_of_occurences = num_of_occurences;
                candidate = current;
            }
            current = a[i];
        }
    }

    // Ovo je neophodno proveriti jer ako je poslednji element dominantan
    // nece se desiti da u petlji vrsimo ovu proveru, jer ce za ovaj element
    // uvek vaziti a[i] == current, a mi azuriramo samo ako se desi da ovaj
    // uslov nije ispunjen. Ovo je provera koja nam omogucava da izvrsimo
    // proveru da li je poslednji element zapravo kandidat
    if (num_of_occurences > max_num_of_occurences) {
        max_num_of_occurences = num_of_occurences;
        candidate = current;
    }

    if (max_num_of_occurences > n / 2) {
        return candidate;
    }
    else {
        return -1;
    }
}

int dominant_element_v2(std::vector<int> a)
{
    std::sort(a.begin(), a.end());

    int n = a.size();

    int candidate = a[n / 2];

    int counter = 0;

    for (int i = 0; i < n; i++) {
        if (a[i] == candidate) {
            counter++;
        }
    }

    if (counter > n / 2) {
        return candidate;
    }

    return -1;
}

int main ()
{
    int n;

    std::cin >> n;

    std::vector<int> a(n);

    for(int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << dominant_element(a) << "\n";

    std::cout << dominant_element_v2(a) << "\n";

    return 0;
}