#include <iostream>
#include <queue>

int main ()
{
    std::priority_queue<int, std::vector<int>, std::less<int>> max_heap; // max heap
    std::priority_queue<int, std::vector<int>, std::greater<int>> min_heap; // min heap

    max_heap.push(1); // O(log n)
    max_heap.push(8);
    max_heap.push(4);
    max_heap.push(9);
    max_heap.push(3);

    // O(n * log n)
    while (!max_heap.empty()) {
        std::cout << max_heap.top() << " "; // O(1)
        max_heap.pop(); // O(log n)
    }
    std::cout << "\n";

    min_heap.push(1); // O(log n)
    min_heap.push(8);
    min_heap.push(4);
    min_heap.push(9);
    min_heap.push(3);

    // O(n * log n)
    while (!min_heap.empty()) {
        std::cout << min_heap.top() << " "; // O(1)
        min_heap.pop(); // O(log n)
    }
    std::cout << "\n";

    return 0;
}