#include <iostream>
#include <vector>
#include <algorithm>

void rancevi(std::vector<int> a, int T)
{
    std::sort(a.begin(), a.end());

    int i, j, k;

    int n = a.size();

    for (int k = 0; k < n - 2; k++) {
        i = k + 1;
        j = n - 1;

        while (i < j) {
            if (a[i] + a[j] + a[k] > T) {
                j--;
            }
            else if (a[i] + a[j] + a[k] < T) {
                i++;
            }
            else {
                std::cout << a[k] << " " << a[i] << " " << a[j] << "\n";
                i++;
                j--;
            }
        }
    }
}

int main ()
{
    int n, T;

    std::cin >> n >> T;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    rancevi(a, T);

    return 0;
}