#include <iostream>
#include <vector>
#include <queue>

int v1(const std::vector<int> &a, int k)
{
    std::priority_queue<int, std::vector<int>, std::less<int>> max_heap;

    for (int x : a) {
        max_heap.push(x);
    }

    int sum = 0;

    for (int i = 0; i < k; i++) {
        int current_max = max_heap.top();

        sum += current_max;

        max_heap.pop();
    }

    return sum;
}

int v2(const std::vector<int> &a, int k)
{
    std::priority_queue<int, std::vector<int>, std::greater<int>> min_heap;

    for (int i = 0; i < k; i++) {
        min_heap.push(a[i]);
    }

    int n = a.size();
    for (int i = k; i < n; i++) {
        if (a[i] > min_heap.top()) {
            min_heap.pop();
            min_heap.push(a[i]);
        }
    }

    int sum = 0;

    while (min_heap.empty() == false) { //!min_heap.empty()
        sum += min_heap.top();
        min_heap.pop();
    }

    return sum;
}

int main ()
{
    int n, k;

    std::cin >> n >> k;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << v1(a, k) << "\n";

    std::cout << v2(a, k) << "\n";

    return 0;
}