#include <iostream>
#include <stack>

int main ()
{
    std::stack<int> s;

    std::string expression;

    std::cin >> expression;

    for (int c : expression) {
        if (c == '+') {
            int op1 = s.top();
            s.pop();
            int op2 = s.top();
            s.pop();

            int result = op1 + op2;
            s.push(result);
        }
        else if (c == '-') {
            int op1 = s.top();
            s.pop();
            int op2 = s.top();
            s.pop();

            int result = op2 - op1;
            s.push(result);
        }
        else if (c == '*') {
            int op1 = s.top();
            s.pop();
            int op2 = s.top();
            s.pop();

            int result = op2 * op1;
            s.push(result);
        }
        else if (c == '/') {
            int op1 = s.top();
            s.pop();
            int op2 = s.top();
            s.pop();

            if (op1 == 0) {
                std::cout << "Division by 0!\n";
                return 0;
            }

            int result = op2 / op1;
            s.push(result);
        }
        else{
            s.push(c - '0'); // Ovde imamo karakter '7' a ne broj 7,
                             // a nacin da dovijemo broj 7 je da od '7'
                             // oduzmemo '0' jer su u ASCII tabeli, sve
                             // cifre poredjane redom
        }
    }

    std::cout << s.top() << "\n";

    return 0;
}