--connect to stud2020;

-- Ilustracija formiranja korisnicki definisanih tipova i funkcija koje
-- rade sa takvim podacima
--
-- Formira se korisnicki definisan tip stipendija nad tipom decimal(7,2).
-- Potrebno je definisati funkcije za rad sa podacima tog tipa

drop type stipendija;
--Ovde drop nece da radi jer postoji tabela koja je zavisna od ovog tipa
drop function "+";
drop table stipendije;
drop type stipendija;  
-- na ovom mestu je tabela vec izbrisana
create distinct type stipendija   as dec(7,2) with comparisons;
create function "+" (stipendija,stipendija) returns stipendija
                source sysibm."+" (dec(7,2),dec(7,2));

create table stipendije  (
                          indeks       integer  not null ,
                          jmbg         char(15) not null ,
                          ovajmesec    stipendija        ,
                          proslimesec  stipendija        ,
                          narednimesec stipendija        ,
                          primary key  (indeks)
                         )
in dugacak;

insert into stipendije
values (20100021,'123456789012345',31600.33,28984.23,25484.90);
insert into stipendije
values (20100022,'234567890123456',21600.33,29984.23,35484.90);

select ime, prezime,(ovajmesec + narednimesec)+ proslimesec
from   stipendije a, dosije b
where  a.indeks=b.indeks;


--Naredni upit nijekorektan jer uključuje operaciju "-" koja nije definisana nad tipom stipendija
select ime, prezime,(ovajmesec + narednimesec)- proslimesec
from   stipendije a, dosije b
where  a.indeks=b.indeks;
