--connect to stud2020;

drop table dosije_nov;

-- Tabela dosije_nov je definisana sa:
create table dosije_nov (
       indeks           integer      not null,  
       ime              varchar(10)  not null with default USER,
       prezime          varchar(15)  not null,
       god_rodjenja     smallint             ,        
       mesto_rodjenja   varchar(20)          ,
       tekuci_prosek    prosek       not null with default 0,
       drzava_rodjenja  drzava                with default 'Srbija'
                        )
with restrict on drop;


--Zadatak1 : prosiriti tabelu dodajuci joj atribute kredit sa
--tipom integer i rokom otplate sa tipom datum
--Pri tome kredit ne moze biti veci od 60.000
--Dodatak (za razmatranje)
--dok rok moze biti najvise 20 godina od trenutka uzimanja kredita

--Zadatak 2: dodati primarni kljuc u tabelu dosije_nov



--Zadatak moze da se resi na vise nacina. Jedan od njih je da se
--izvrsi vise naredbi alter - posebno za dodavanje atributa i
--posebno za dodavanje ogranicenja. Drugi nacin je da se istovremeno
--dodaju i atributi i ogranicenje



ALTER TABLE dosije_nov ADD kredit  INTEGER
            CONSTRAINT granica  CHECK (kredit<=60000);
ALTER TABLE dosije_nov ADD otplata DATE;

-- Da li moze i ovako? 
-- ALTER TABLE dosije_nov ADD otplata DATE
-- CHECK (otplata <=(CURRENT DATE + 20 year));



--Na isti nacin mogu da se dodaju i spoljasnji kljucevi (ako je potrebno),
--dok se brisanje kljuceva vrsi naredbom
--ALTER TABLE XXX DROP PRIMARY  KEY; ili
--ALTER TABLE XXX DROP FOREIGN  KEY ime-spoljasnjeg-kljuca;

-- Pitanje: da li se automatski brise i odgovarajuci indeks? 

--Zadatak3: Promeniti opciju WITH RESTRICT ON DROP u tabeli dosije_nov
--Bez promene, tabela neće moći da se izbriše

--Naredni upit neće biti uspešno izvršen
DROP TABLE DOSIJE_NOV;

--Uklanjanje ograničenja
ALTER TABLE dosije_nov DROP RESTRICT ON DROP;

--Naredni upit će biti uspešno izvršen
DROP TABLE DOSIJE_NOV;


--Na slican nacin moze da se doda ovo ogranicenje u tabelu koja ga ne poseduje.
--ALTER TABLE ispit ADD  RESTRICT ON DROP;

-- Uklanjanje uslova ogranicenja (provera) iz tabela

ALTER TABLE dosije_nov DROP CONSTRAINT GRANICA;
-- ALTER TABLE dosije_nov DROP CHECK GRANICA;
