--Elementarni podupiti

--Prikazati ime, prezime i broj indeksa studenata koji su polagali ispit u nekom od ispitnih rokova 2015. godine, 
--bez obzira na ocenu koju su dobili  
select ime, prezime, indeks
from   dosije
where  indeks in (
                  select indeks 
                  from   ispit 
                  where  godina_roka=2015
                 ); 


--Isti upit moze da se predstavi i preko spajanja, sto je znatno efikasnije
select distinct ime, prezime, a.indeks
from   dosije a, ispit b
where  a.indeks=b.indeks
and    b.godina_roka=2015;


--Prikazati ime, prezime, broj indeksa studenata  i naziv predmeta koje je student 
--polozio u nekom od ispitnih rokova 2015. godine
select ime, prezime, indeks, naziv
from   dosije a, predmet b
where  (indeks, id_predmeta)  in (
                                  select indeks, id_predmeta
                                  from   ispit 
                                  where  godina_roka=2015
                                  and    ocena > 5
                                 ); 




--Prikazati broj indeksa, ime i prezime studenta koji je u 2015 godini imao 
--prosecnu ocenu na ispitima vecu od 7.5
select indeks,ime,prezime
from   dosije a
where  7.5 < (
              select avg(ocena*1.0)
              from   ispit b
              where  b.indeks=a.indeks
              and    godina_roka=2015
             ); 


--Prikazati broj indeksa, ime i prezime studenta koji je u 2015 godini polozio bar jedan ispit
select indeks,ime,prezime
from   dosije a
where  exists (
               select *
               from   ispit b
               where  b.indeks=a.indeks
               and    godina_roka=2015
              ); 



--Prikazati broj indeksa, ime, prezime i naziv predmeta za koje vazi da je student sa tim 
--brojem indeksa, imenom i prezimenom polozio ispit iz tog predmeta u 
--ispitnom roku ciji je naziv 'April 2015' ili 'Jun 2015'
select indeks, ime, prezime, naziv
from   dosije a, predmet b
where  a.indeks in (     
                    select c.indeks 
                    from   ispit c
                    where  (godina_roka, oznaka_roka) in (
                                                          select godina_roka, oznaka_roka
                                                          from   ispitni_rok
                                                          where  naziv in ('April 2015','Jun 2015')                                                          
                                                         )
                    and    c.id_predmeta=b.id_predmeta   
                    and    c.ocena>5   
                   );

--Alternativni upit 
--select indeks, ime, prezime, naziv
--from   dosije a, predmet b
--where  (a.indeks,b.id_predmeta)  in 
--                   (     
--                    select c.indeks, c.id_predmeta
--                    from   ispit c
--                    where  (c.godina_roka, c.oznaka_roka) in (
--                                                              select godina_roka, oznaka_roka
--                                                              from   ispitni_rok
--                                                              where  naziv in ('April 2015','Jun  2015')                                                          
--                                                             )
--                    and    c.ocena>5   
--                   );


--Prikazati broj indeksa, ime, prezime i naziv predmeta za koje vazi da je student sa tim 
--brojem indeksa, imenom i prezimenom polozio ispit iz tog predmeta u 
--ispitnom roku ciji je naziv 'April 2015' ili 'Jun 2015'
--sa ocenom koja je bar jednaka prosecnoj oceni svih studenata na polozenim ispitima u tom ispitnom roku
select indeks, ime, prezime, naziv
from   dosije a, predmet b
where  a.indeks in (     
                    select c.indeks 
                    from   ispit c
                    where  (godina_roka, oznaka_roka) in (
                                                          select godina_roka, oznaka_roka
                                                          from   ispitni_rok
                                                          where  naziv in ('April 2015','Jun 2015')                                                          
                                                         )
                    and    c.id_predmeta=b.id_predmeta   
                    and    c.ocena>5   
                    and    c.ocena>=(select avg(ocena*1.0)
                                     from   ispit d
                                     where  (d.godina_roka, d.oznaka_roka)= (c.godina_roka, c.oznaka_roka)
                                     and    c.ocena>5   
                                    ) 
                   );


--Prikazati nazive predmeta koji jesu polagani u nekom od ispitnih rokova 2015 godine, i za koje 
--vazi da niko od studenata koji su ih polagali nije pao. 
select naziv
from   predmet a
where  exists  (select * 
                from   ispit b
                where  b.id_predmeta=a.id_predmeta
                and    godina_roka=2015
               )
and   not exists (select * 
                  from   ispit b
                  where  b.id_predmeta=a.id_predmeta
                  and    godina_roka=2015
                  and    ocena=5
                 );
                 
                 
--Prikazati nazive predmeta koje su polozili svi studenti
--Kako u SQL-u ne postoji univerzalni kvantifikator, zadatak se transformise u 
--prikazati nazive predmeta za koje ne postoji student koji ih nije polozio
select naziv
from   predmet a
where  not exists  (select * 
                    from   dosije b
                    where  indeks not in (select indeks
                                          from   ispit c
                                          where  c.id_predmeta = a.id_predmeta
                                          and    c.ocena>5
                                         ) 
                   );

                                  

--Prikazati uredjene sestorke (naziv_predmeta_1, oznaka_roka_1, godina_roka_1, naziv_predmeta_2, oznaka_roka_2, godina_roka_2)
--zako je vazi da je predmet sa nazivom naziv_predmeta_1 u ispitnom roku oznaka_roka_1 koji je drzan u godini godina_roka_1 polozilo 
--vise studenata nego predmet sa nazivom naziv_predmeta_2 u ispitnom roku oznaka_roka_2 koji je drzan u godini godina_roka_2 
select a.naziv, c.oznaka_roka, c.godina_roka, b.naziv, d.oznaka_roka, d.godina_roka 
from   predmet a, predmet b, ispitni_rok c, ispitni_rok d
where  (select count(*)
        from   ispit 
        where  id_predmeta=a.id_predmeta
        and    oznaka_roka=c.oznaka_roka
        and    godina_roka=c.godina_roka
        and    ocena>5
        having count(*)>0
       )
       > 
       (select count(*)
        from   ispit 
        where  id_predmeta=b.id_predmeta
        and    oznaka_roka=d.oznaka_roka
        and    godina_roka=d.godina_roka
        and    ocena>5
        having count(*)>0
       );
       
