--XQUERY
xquery db2-fn:xmlcolumn('DOSIJE_XML.PODATAK')/student/ime;
xquery db2-fn:sqlquery('SELECT PODATAK FROM DOSIJE_XML')/student/prezime;
xquery db2-fn:xmlcolumn('DOSIJE_XML.PODATAK')/student[@broj_indeksa="20140021"]/ime;
xquery db2-fn:xmlcolumn('DOSIJE_XML.PODATAK')/student/adresa/grad;

-- XQUERY FLWOR (for, let, where, order by, return)
xquery
for $i in ("Beograd", "Novi Sad", "Niš")
for $j in ("Subotica","Preševo")
return <output>{$i,"-",$j}</output>;

-- Četiri varijante istog upita
xquery
for $i in db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")/student
return $i/ime;

xquery
for $i in db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")/student/ime
return $i;

xquery
for $i in db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")
return $i/student/ime;

xquery db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")/student/ime;


-- Upotreba where

xquery
for $i in db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")/student
where $i/@broj_indeksa=20140021
return $i/ime;

-- Upotreba Order by
xquery
for      $i in db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")/student
let      $j := $i/ime
where    $i/adresa/grad = "Beograd"
order by $i/@id descending
return   $j;

-- Formiranje nove XML strukture pomoću konstruktora

xquery
for      $i in db2-fn:xmlcolumn("DOSIJE_XML.PODATAK")/student
where    $i/adresa/grad = "Beograd"
return <student>
<ime_studenta>{$i/ime/text()}</ime_studenta>
<grad_u_kome_je_rođen>{$i/adresa/grad/text()}</grad_u_kome_je_rođen>
</student>;

-- Uporediti prethodni upit sa upitom bez text()

-- Operatori (primer za Union)
xquery
let $gradstanovanja := db2-fn:xmlcolumn('DOSIJE_XML.PODATAK')/student/adresa/grad
let $ulicastanovanja := db2-fn:xmlcolumn('DOSIJE_XML.PODATAK')/student/adresa/ulica
return <student>
{ $gradstanovanja union $ulicastanovanja }
</student>;

-- Korišćenje agregatnih funkcija (ilustracija za avg, count)
xquery
let $studenti := db2-fn:xmlcolumn('DOSIJE_XML.PODATAK')/student
return <student>
        {'Ukupno različitih brojeva telefona='}     
        {count($studenti//telefon)}
        {', a prosek ocena studenata je '}        
        {avg  ($studenti//prosek)}
       </student>;



-- SQL/XML

SELECT XMLQUERY('$PODATAK/student/prezime')
FROM   DOSIJE_XML;

--Alternativni način referenciranja
SELECT XMLQUERY('$i/student/prezime' passing podatak as "i") 
FROM   DOSIJE_XML;

-- Vraćanje samo tekstualne vrednosti

SELECT XMLQUERY('$PODATAK/student/prezime/text()')
FROM   DOSIJE_XML;

-- Uklanjanje xml oznaka pomoću XMLCAST
SELECT XMLCAST(XMLQUERY('$PODATAK/student/prezime') as CHARACTER(10))
FROM   DOSIJE_XML;

-- Izdvajanje više podataka

SELECT indeks as "Indeks",
       XMLQUERY('$PODATAK/student/prezime/text()') as "Prezime",
       XMLQUERY('$PODATAK/student/ime/text()') as "Ime",
       XMLQUERY('$PODATAK/student/datum_upisa/text()') as "Datum_upisa" 
FROM   DOSIJE_XML;

-- Izdvajanje više podataka

SELECT indeks as "Indeks",
       XMLQUERY('$PODATAK/student/prezime/text()') as "Prezime",
       XMLQUERY('$PODATAK/student/ime/text()') as "Ime",
       XMLQUERY('$PODATAK/student/datum_upisa/text()') as "Datum_upisa", 
       XMLQUERY('$PODATAK/student/telefon') as "Telefon" 
FROM   DOSIJE_XML;


-- Upotreba XMLTABLE (1)

SELECT dosije.*
FROM   dosije_xml,
XMLTABLE('$PODATAK/student' COLUMNS broj_indeksa integer path '@broj_indeksa', ime varchar(15) PATH 'ime', prezime varchar(15) PATH 'prezime', 
ulica varchar(20) PATH 'adresa/ulica', grad varchar(15) PATH 'adresa/grad') AS dosije;


-- Upotreba XMLTABLE (2)

SELECT dosije.*
FROM   dosije_xml,
XMLTABLE('$PODATAK/student' COLUMNS 
         broj_indeksa integer path '@broj_indeksa', 
         ime          varchar(15) path 'ime', 
         prezime      varchar(15) path 'prezime', 
         ulica        varchar(40) path 'adresa/ulica', 
         grad         varchar(20) path 'adresa/grad',
         telefon1     varchar(15) path 'telefon[1]',
         telefon2     varchar(15) path 'telefon[2]'
         ) as dosije
order by ulica desc;



-- Upotreba XMLEXISTS


SELECT indeks as "Indeks",
       XMLQUERY('$PODATAK/student/prezime/text()') as "Prezime",
       XMLQUERY('$PODATAK/student/ime/text()') as "Ime",
       XMLQUERY('$PODATAK/student/datum_upisa/text()') as "Datum_upisa"
FROM   DOSIJE_XML        
WHERE XMLEXISTS('$PODATAK/student[adresa/grad = "Beograd"]');


--Poređenje rezultata upita

SELECT XMLQUERY('$i/student/adresa[@drzava="Srbija"]' passing podatak as "i") 
FROM   DOSIJE_XML;

SELECT XMLQUERY('$i/student/adresa[@drzava="Србија"]' passing podatak as "i") 
FROM   DOSIJE_XML;

SELECT XMLQUERY('$i/student/adresa/@drzava="Srbija"' passing podatak as "i") 
FROM   DOSIJE_XML;

SELECT XMLQUERY('$i/student/adresa/@drzava="Србија"' passing podatak as "i") 
FROM   DOSIJE_XML;
;
