-- Prikazati brojeve redova onim redom kojim se generišu u rezultatu 
-- U prikazu redovi mogu da budu promenjeni u zavisnosti od atributa za koga se zahteva uredjenje

with proseci(indeks, ime, prezime, prosek)
as
(
 select a.indeks, ime, prezime, dec(avg(ocena*1.0),4,2)
 from   ispit a, dosije b 
 where  ocena >5
 and    a.indeks=b.indeks
 and    a.datum_ispita=(select max(datum_ispita)
                        from   ispit c
                        where  a.indeks=c.indeks
                        and    a.id_predmeta=c.id_predmeta 
                       )
 group by a.indeks,ime,prezime
)
select indeks,ime, prezime, prosek, row_number() over(order by prosek desc) as "Redosled"
from   proseci;
-- order by indeks;



-- Za poredjenje izmedju row_number i dense_rank izvršiti sledeći upit

with proseci(indeks, ime, prezime, prosek)
as
(
 select a.indeks, ime, prezime, dec(avg(ocena*1.0),4,2)
 from   ispit a, dosije b 
 where  ocena >5
 and    a.indeks=b.indeks
 and    a.datum_ispita=(select max(datum_ispita)
                        from   ispit c
                        where  a.indeks=c.indeks
                        and    a.id_predmeta=c.id_predmeta 
                       )
 group by a.indeks,ime,prezime
)
select 1,indeks,ime, prezime, prosek, row_number() over(order by prosek desc) as "Redni broj reda u rezultatu"
from   proseci 


union all 


select 2,indeks,ime, prezime, prosek, dense_rank() over(order by prosek desc) as "Redosled"
from   proseci;

