with preduslovi (nivo, predmet, preko, uslovni_predmet) as
    ( 
--    Inicijalni SELECT

      select 0, idpredmeta, null, iduslovnogpredmeta
      from   db.uslovnipredmet koren
      where  koren.idpredmeta in (select id from db.predmet where naziv='Релационе базе података')
      
      union all

--    Iterativni SELECT      
      select roditelj.nivo+1, roditelj.predmet, dete.idpredmeta, dete.iduslovnogpredmeta
      from   preduslovi roditelj, db.uslovnipredmet dete
      where  roditelj.uslovni_predmet=dete.idpredmeta
    )
-- Glavni SELECT    
select distinct nivo as "Nivo" ,
                (select char(naziv,45) from db.predmet b where b.id=a.predmet) as "Predmet", 
                (select char(naziv,45) from db.predmet b where b.id=a.preko) as "Predmet preko koga je preduslov", 
                (select char(naziv,45) from db.predmet b where b.id=a.uslovni_predmet) as "Uslovni predmet"
from   preduslovi a

order by 1;
