connect to stud2020;
drop table listadelova;
CREATE TABLE LISTADELOVA
       (DEO      VARCHAR(8) NOT NULL,
        PODDEO   VARCHAR(8) NOT NULL,
        KOLICINA INTEGER, 
        primary key (DEO, PODDEO));


LOAD FROM "delovi.load" OF DEL MODIFIED BY FASTPARSE METHOD P (1, 2, 3) MESSAGES "delovi.load.izv" INSERT INTO LISTADELOVA (DEO, PODDEO, KOLICINA) NONRECOVERABLE INDEXING MODE AUTOSELECT;

-- Primer1.
-- Prikazati spisak svih delova i kolicine neposrednih sastavnih poddelova od kojih se ti delovi sastoje. 
WITH REKURZLISTADELOVA (DEO, PODDEO, KOLICINA) AS

    ( 
--    Inicijalni SELECT

      SELECT KOREN.DEO, KOREN.PODDEO, KOREN.KOLICINA
      FROM LISTADELOVA KOREN
      WHERE KOREN.DEO='01'
      
      UNION ALL

--    Iterativni SELECT      
      SELECT DETE.DEO, DETE.PODDEO, DETE.KOLICINA
      FROM REKURZLISTADELOVA RODITELJ, LISTADELOVA DETE
      WHERE RODITELJ.PODDEO = DETE.DEO
    )
    
-- Glavni SELECT    
SELECT DISTINCT DEO, PODDEO, SUM(KOLICINA) AS UKUPNO
FROM REKURZLISTADELOVA
GROUP BY DEO, PODDEO
ORDER BY DEO, PODDEO;


-- Primer 2. 
-- Prikazati spisak svih delova sa kolicinama koji su ugradjeni u proizvod (deo) sa sifrom 01.
WITH REKURZLISTADELOVA (DEO, PODDEO, KOLICINA) AS
   (
    SELECT KOREN.DEO, KOREN.PODDEO, KOREN.KOLICINA
    FROM LISTADELOVA KOREN
    WHERE KOREN.DEO='01'
    UNION ALL
    SELECT RODITELJ.DEO, DETE.PODDEO, RODITELJ.KOLICINA*DETE.KOLICINA
    FROM REKURZLISTADELOVA RODITELJ, LISTADELOVA DETE
    WHERE RODITELJ.PODDEO = DETE.DEO
   )
SELECT DEO, PODDEO, SUM(KOLICINA) AS "Ukupna upotrebljena kolcina"
FROM REKURZLISTADELOVA
GROUP BY DEO, PODDEO
ORDER BY DEO, PODDEO;


-- Primer 3. 
-- Prikazati spisak delova koji se koriste pri pravljenju proizvoda sa sifrom 01
-- Spisak ograniciti na prva dva nivoa. 

WITH REKURZLISTADELOVA (NIVO, DEO, PODDEO, KOLICINA) AS
  (
   SELECT 1, KOREN.DEO, KOREN.PODDEO, KOREN.KOLICINA
   FROM LISTADELOVA KOREN
   WHERE KOREN.DEO='01'
   UNION ALL
   SELECT RODITELJ.NIVO+1, DETE.DEO, DETE.PODDEO, DETE.KOLICINA
   FROM REKURZLISTADELOVA RODITELJ, LISTADELOVA DETE
   WHERE RODITELJ.PODDEO = DETE.DEO
   AND RODITELJ.NIVO < 2
  )
SELECT DEO, NIVO, PODDEO, KOLICINA
FROM REKURZLISTADELOVA;
