#!/usr/bin/python

import sys

#provera argumenata komandne linije
if len(sys.argv) != 2:
    print "Koriscenje:", sys.argv[0], "snt_file"
    exit()

#citanje ulaznog fajla
try:
    f = open(sys.argv[1], "r")
except IOError:
    print "Ne mogu da otvorim fajl za citanje"
    exit()

sadrzaj = f.read()

f.close

#trazeni patern
import re

pattern = re.compile(r"{(([^,]|,[^.])+),\.NE\+(\w+):\d[a-z]}")


#izlazni fajl
try:
    g = open(sys.argv[1].replace(".snt", ".xml"), "w")
except IOError:
    print "Nemoguce otvoriti xml fajl za pisanje"
    exit()

g.write("<xml>\n")

#pokazivac dokle se doslo u konverziji fajla
prepisano = 0

#za svaki pronadjen patern
for m in pattern.finditer(sadrzaj):
    #prepisi tekst pre pronalaska paterna
    g.write(sadrzaj[prepisano:m.start()])
    #konvertuj patern u xml tag
    g.write("<" + m.group(3) + ">" + m.group(1) + "</" + m.group(3) + ">")
    #pomeri pokazivac dokle je stigla konverzija
    prepisano = m.end()

#prepisi ostatak fajla
g.write(sadrzaj[prepisano:])

#zadatak je mogao i prostije u jednoj liniji da se uradi na ovaj nacin:
#g.write(pattern.sub(r"<\3>\1</\3>", sadrzaj))

g.write("\n")
g.write("</xml>")

g.close()
