#!/usr/bin/python

# U html fajlu koji se zada kao prvi argument komandne linije,
# postoje rezultati kolokvijuma, u formi tabele (pogledaj html)
# U fajl izlaz.txt upisati sumarne rezultate, sortirane po ucinku

# ucitavamo modul sys, zbog argumenata komandne linije
import sys

# importujemo modul za rad sa regularnim izrazima
import re

# proveravano da li imamo dovoljno argumenata komandne linije
if len(sys.argv) != 2:
    print "koriscenje: /rez.py FAJL"
    exit()

# proveravano da li je prosledjen fajl html stranica
if re.match(".*\.html", sys.argv[1], re.I) == None:
    print "Datoteka mora biti html stranica"
    exit()

# otvaramo fajl samo za citanje
f = open(sys.argv[1], "r")

# procitamo sav sadrzaj fajla
fajl = f.read()

# pravimo pattern
pattern = r"\s*<tr[^>]*>\s*<td[^>]*>\s*(\w+)\s*</td>\s*"
pattern += r"<td[^>]*>\s*(\w+)\s*</td>\s*"
pattern += r"<td[^>]*>\s*(\w+)\s*</td>\s*"
pattern += r"<td[^>]*>\s*(\d+)\s*</td>\s*"
pattern += r"<td[^>]*>\s*(\d+)\s*</td>\s*"
pattern += r"<td[^>]*>\s*(\d+)\s*</td>\s*"
pattern += r"<td[^>]*>\s*(\d+)\s*</td>\s*"
pattern += r"</tr>"

# u mapi1 pamtimo broj poena svakog studenta
# u mapi2 pamtimo indeks svakog studenta
mapa1 = {}
mapa2 = {}

# pronalazimo sve studente koji se nalaze u HTML-fajlu
for x in re.finditer(pattern, fajl):
    zbir = 0
    for i in range(4, 7):
        # konvertujemo string koji predstavlja broj poena u int i sabiramo
        zbir += int(x.group(i))
    mapa1[x.group(1) + " " + x.group(2)] = zbir
    mapa2[x.group(1) + " " + x.group(2)] = x.group(3)

# zatvaramo fajl
f.close()

#for k, v in mapa1.items():
#    print k, v

# fja poredjenja dva studenata po broju poena
def poredi(x, y):
    return cmp(mapa1[x], mapa1[y])

# soritramo studente po broju poena
keys = mapa1.keys()
keys.sort(poredi, reverse=True)

# otvaramo fajl za ispis rezutata
g = open("izlaz.txt", "w")

# upis u fajl
for k in keys:
    g.write(k.ljust(20) + " " + mapa2[k].center(6) + " " + str(mapa1[k]).rjust(4) + "\n")

# zatvaramo fajl
g.close()

