#!/usr/bin/python

import sys

#provera argumenata komandne linije
if len(sys.argv) < 2:
    print "Koriscenje:", sys.argv[0], "OPCIJE ime_knjige"
    exit()

#trazeni podaci
trazim_autora = False
trazim_cenu = False
trazim_izdavaca = False
trazim_godinu = False
trazim_sve = False
ime_knjige = ''

for arg in sys.argv[1:]:
    if arg == '-a':
        trazim_autora = True
    elif arg == '-c':
        trazim_cenu = True
    elif arg == '-i':
        trazim_izdavaca = True
    elif arg == '-g':
        trazim_godinu = True
    else:
        ime_knjige = arg

if not trazim_autora and not trazim_izdavaca and not trazim_cenu and not trazim_godinu:
    trazim_sve = True

if ime_knjige == '':
    print 'Navedi ime knjige'
    exit()

#otvaranje fajla za citanje
try:
    f = open("knjige.xml", "r")
except IOError:
    print "Ne mogu da otvorim fajl za citanje"
    exit()
#citanje fajla
sadrzaj = f.read()
f.close

#trazeni paterni
import re
item1 = r'<knjiga\s+rbr\s*=\s*"(\d+)"\s*>\s*'
item2 = r'<(naslov|autor|godina_izdanja|izdavac)>\s*([^<]+)\s*</\1>\s*'
item3 = r'<(cena)\s+valuta\s*=\s*"((rsd)|(eur))">\s*([^<]+)\s*</\1>\s*'

pattern1 = re.compile(item1, re.I)
pattern2 = re.compile(item2, re.I)
pattern3 = re.compile(item3, re.I)

mapa = {}

#za svaku knjigu iz fajla
for m in pattern1.finditer(sadrzaj):
    #pocetak sledece knjige
    m_next = pattern1.search(sadrzaj, m.end())
    #ako nema sledece knjige
    if m_next == None:
        tmp = len(sadrzaj)
    #inace
    else:
        tmp = m_next.start()
    #u svakoj knjizi trazimo relevantne podatke
    for i in pattern2.finditer(sadrzaj, m.end(), tmp):
        if i.group(1) == 'naslov':
            naslov = i.group(2).strip()
        elif i.group(1) == 'autor':
            autor = i.group(2).strip()
        elif i.group(1) == 'godina_izdanja':
            godina_izdanja = i.group(2).strip()
        else:
            izdavac = i.group(2).strip()
    i = pattern3.search(sadrzaj, m.end(), tmp)
    if (i == None):
        print 'Knjiga sa rednim brojem', m.group(1), 'nema cenu'
        exit()
    cena = i.group(5) + i.group(2)
    mapa[m.group(1)] = (naslov, autor, godina_izdanja, izdavac, cena)

for k, v in mapa.iteritems():
    if v[0] == ime_knjige:
        if trazim_sve:
            print v[2:]
        else:
            if trazim_autora:
                print v[1]
            if trazim_godinu:
                print v[2]
            if trazim_izdavaca:
                print v[3]
            if trazim_cenu:
                print v[4]

