%option noyywrap
%{
#include <set>
#include <string>
#include <vector>
#include "relacija.h"
#include "formula.h"
using namespace std;
#include "relacije.tab.hpp"
%}
%%

[;.{}=,()&|~?!]	{ return *yytext; }
[.][.]          { return PP; }
::              { return DD; }
-->             { return IMP; }
type		{ return TYPE; }
relation	{ return RELATION; }
question	{ return QUESTION; }
answer		{ return ANSWER; }
[a-zA-Z][a-zA-Z0-9]*	{ yylval.str_attr = new string(yytext); return ID; }
[0-9]+          { yylval.int_attr = atoi(yytext); return NUM; }
[ \t\n]
%%
