#ifndef __FORMULA_H__
#define __FORMULA_H__

#include <string>
#include <vector>
#include <map>
#include <iostream>
using namespace std;

#include "relacija.h"
extern map<string, Relacija*> relacije;

class Formula {
 public:
    virtual bool vrednost() = 0;
};

class Atom : public Formula {
 public:
    Atom(const string& ime, const vector<int>& argumenti) 
	: _imeRelacije(ime), _argumenti(argumenti) {
    }

    virtual bool vrednost() {
	return (relacije[_imeRelacije])->uRelaciji(_argumenti);
    }
 private:
    string _imeRelacije;
    vector<int> _argumenti;
};

#endif
