%option noyywrap
%{
#include <cstdlib>
#include <string>
using namespace std;
class Statement;
class StringExpression;
class BooleanExpression;
#include "basic.tab.hpp"
%}

%%
[;+=(),]           return *yytext;
PRINT              return PRINT;
INPUT              return INPUT;
GOTO               return GOTO;
IF                 return IF;
THEN               return THEN;
FOR                return FOR;
TO                 return TO;
NEXT               return NEXT;
RUN                return RUN;
LEFT\$             return LEFT;
RIGHT\$            return RIGHT;
LET                return LET;
[a-zA-Z]+   { yylval.pstring_atr = new string(yytext); return VAR; }
[a-zA-Z]+\$ { yylval.pstring_atr = new string(yytext); return STRINGVAR; }
\"[^\"]*\"  { string* str = new string(yytext+1); 
              str->resize(str->size()-1); 
              yylval.pstring_atr = str; 
              return STRING; 
            }
[0-9]+      { yylval.int_atr = atoi(yytext); return NUM; }
[ \t\n]+
%%