#include "Program.h"
#include "Statement.h"

Program::~Program() {
    map<int, Statement*>::iterator i;
    for (i = _statements.begin(); i != _statements.end(); i++)
	delete i->second;
}

void Program::run() {
    // Ukoliko je program prazan, nema sta da se izvrsava
    if (_statements.empty())
	return;

    // Krecemo od prve naredbe programa
    _lineNumber = getMinStatementNumber();
    while (1) {
	// Pronalazimo tekucu naredbu
	Statement* statement = getStatement(_lineNumber);

	// Ukoliko naredba ne postoji, prekidamo izvrsavanje
	if (statement == 0) 
	    break;

	// Postavljamo broj sledece naredbe
	nextStatement();

	// Izvrsavamo tekucu naredbu
	statement->execute();
    }
}

int Program::getForStatementNumber(string var) {
    // Pretragu zapocinjemo od naredbe koja prethodi tekucoj
    map<int, Statement*>::const_iterator i = 
	_statements.find(_lineNumber);
    i--;

    bool done = false;
    while (!done) {
	// Ukoliko u ovoj iteraciju obradjujemo prvu naredbu programa,
	// zavrsili smo
	if (i == _statements.begin())
	    done = true;

	// Proveravamo da li je naredba koju obradjujemo for naredba i da li je
	// njena promenljiva iteracije jednaka datoj
	ForStatement* forStatement = dynamic_cast<ForStatement*>(i->second);
	if (forStatement != 0 && forStatement->getVar() == var)
	    return i->first;
	
	// Prelazimo na prethodnu naredbu
	i--;

    }

    // Nismo nasli odgovarajucu for naredbu
    return -1;
}
