#ifndef __BOOLEAN_EXPRESSION_H__
#define __BOOLEAN_EXPRESSION_H__

#include "StringExpression.h"

/**
 *   Bazna klasa za sve logicke izraze
 */
class BooleanExpression {
 public:
    virtual ~BooleanExpression() {}
    virtual int value() = 0;
};

/**
 *   Klasa kojom se predstavlja jednakost dva string izraza
 */
class Eq : public BooleanExpression {
 public:
    Eq (StringExpression* op1, StringExpression* op2) 
	: _op1(op1), _op2(op2) {
    }

    virtual int value() {
	return _op1->value() == _op2->value();
    }

 private:
    StringExpression *_op1, *_op2;
};

#endif
