%option noyywrap

%{
#include "regex.h"
#include "pii-2006.01.tab.hpp"
#include <cstring>
%}

%%
print  return PRINT;
basic_regex return BASIC;

"["."-"."]" {yylval.str_attr = strdup(yytext); return CHARCLASS;}
[A-Z]+ {yylval.str_attr = strdup(yytext); return ID;}
[+*?|=();] return *yytext;
[0-9a-z\.] {yylval.char_attr = *yytext; return CHAR;}
[\n\t ]
.
%%
