#ifndef __FORMULE_HPP__
#define __FORMULE_HPP__

#include <iostream>
#include "promenljive.hpp"

class Formula
{
public:
	virtual void ispisi(ostream& ostr) = 0;
	virtual int vrednost() = 0;
	virtual ~Formula() 
	{}
};

class Slovo : public Formula
{
public:
	Slovo(char p)
		: _p(p)
	{}

	void ispisi(ostream& ostr)
	{
		ostr<<_p;
	}
	
	int vrednost()
	{
		return vrednost_promenljive(_p);
	}

private:
	char _p;
};

class Konstanta : public Formula
{
public:
	Konstanta(int vrednost)
	:	_vrednost(vrednost)
	{}

	void ispisi(ostream& ostr)
	{
		ostr<<(_vrednost?'T':'F');
	}

	int vrednost()
	{	return _vrednost;	}

private:
	int _vrednost;	
};
#endif
