
%{    
#include "pii-03.04.h"
#include "y.tab.h"
#include <string.h>
#include <stdlib.h>
int line_number=1;
%}

%%
"dim"       return DIM;
"point"     return POINT;
"line"      return LINE;
"segment"   return SEGMENT;
"circle"    return CIRCLE;

"med"       return MED;
"distance"  return DISTANCE;
"intersect" return INTERSECT;
"draw"      return DRAW;

"circleprecision" return CIRCLEPRECISION;

[_a-zA-Z]+          { yylval.string_value=strdup(yytext); return ID;}
[0-9]+("."[0-9]+)?  { yylval.float_value=atof(yytext); return NUM;}
[-+*/=(),;] return *yytext;

"/*"([^*]|("*"[^/]))*"*/"

[ \t]+

\n        line_number++;

%%

