%option noyywrap
%{

/* januar2004.lex 
   resenje prakticnog dela ispitnog roka januar 2004.
   Autor : Filip Maric
*/

#include "types.h"
#include "y.tab.h"
#include <stdlib.h>
#include <string.h>

%}

REAL "-"?[0-9]+("."[0-9]+)?
ID   [_A-Za-z][_A-Za-z0-9]*

%%
"REAL"     {return REAL_TYPE;}
"COMPLEX"  {return COMPLEX_TYPE;}
"real"     {return REAL_PART; }
"imag"     {return IMAG_PART; }

{REAL}     {yylval.float_value=atof(yytext); return REAL_CONSTANT;}
{REAL}"i"  {yylval.float_value=atof(yytext); return IMAG_CONSTANT;}
"i"        {yylval.float_value=1.0; return IMAG_CONSTANT;}
{ID}       {yylval.string_value=strdup(yytext); return VARIABLE;}
[-+*/=;(),]     {return *yytext;}

[\n\t ]

%%
