%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define yyerror printf
extern char* yytext;

enum VRSTAIZRAZA {MULTIPLIKATIVNI,ADITIVNI,PROM,BROJ};

typedef struct _IZRAZ
{  int vrednost;
   char string[255];
   int vrsta;
} IZRAZ;

#define YYSTYPE IZRAZ*

int vrednosti[26];
char pamtiprom;
%}

%left PLUS MINUS
%left PUTA PODELJENO
%token PROM BROJ
%start poc

%%

poc : '(' ')' ;

nizdodela : nizdodela dodela
          |
          ;


dodela : PROM  { pamtiprom=yytext[0]; } '=' izraz ';'
                         { if ($3->vrsta==BROJ)
                              printf("%c=%d;\n",pamtiprom,$3->vrednost);
                           else
                              printf("%c=%s=%d;\n",pamtiprom,$3->string,$3->vrednost);
                           vrednosti[pamtiprom-'a']=$3->vrednost;
                         }
izraz : izraz PLUS izraz
               { $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                 $$->vrsta=ADITIVNI;
                 $$->vrednost=$1->vrednost+$3->vrednost;
                 sprintf($$->string,"%s+%s",$1->string,$3->string);
               }
      | izraz MINUS izraz
               { $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                 $$->vrsta=ADITIVNI;
                 $$->vrednost=$1->vrednost-$3->vrednost;
                 sprintf($$->string,"%s-%s",$1->string,$3->string);
               }
      | izraz PUTA izraz
               {  $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                  $$->vrsta=MULTIPLIKATIVNI;
                  $$->vrednost=$1->vrednost*$3->vrednost;
                  if ($1->vrsta==ADITIVNI)
                      sprintf($$->string,"(%s)",$1->string);
                  else
                      sprintf($$->string,"%s",$1->string);
                  if ($3->vrsta==ADITIVNI)
                      sprintf($$->string,"%s*(%s)",$$->string,$3->string);
                  else
                      sprintf($$->string,"%s*%s",$$->string,$3->string);
               }
      | izraz PODELJENO izraz
               {  $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                  $$->vrsta=MULTIPLIKATIVNI;
                  if ($3->vrednost==0)
                  {    yyerror("Deljenje nulom!");
                       exit(1);
                  }
                  $$->vrednost=$1->vrednost/$3->vrednost;
                  if ($1->vrsta==ADITIVNI)
                      sprintf($$->string,"(%s)",$1->string);
                  else
                      sprintf($$->string,"%s",$1->string);
                  if ($3->vrsta==ADITIVNI)
                      sprintf($$->string,"%s/(%s)",$$->string,$3->string);
                  else
                      sprintf($$->string,"%s/%s",$$->string,$3->string);
               }
      | '(' izraz ')'
              {  $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                 $$->vrsta = $2->vrsta;
                 $$->vrednost = $2->vrednost;
                 strcpy($$->string,$2->string);
              }

     |  BROJ  {   $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                  $$->vrsta=BROJ;
                  $$->vrednost=atoi(yytext);
                  strcpy($$->string,yytext);
              }
     |  PROM  {   $$=(IZRAZ*)malloc(sizeof(IZRAZ));
                  $$->vrsta=PROM;
                  $$->vrednost=vrednosti[yytext[0]-'a'];
                  itoa($$->vrednost,$$->string,10);
              }
   ;


%%

main()
{ int i;
  for (i=0; i<26; i++)
     vrednosti[i]=0;
    yyparse();
}
