#include "scalar.hpp"

scalar::scalar(const string& s)
{	
  _type = STRING;
  _string_value = s;
		
}

scalar::scalar(int i)
{	
  _type = INT;
  _int_value = i;
		
}

int scalar::GetIntValue() const
{
  switch(_type)
    {
    case INT:
      return _int_value;
    case STRING:
      return atoi(_string_value.c_str());	
    }
}

string scalar::GetStringValue() const
{
  switch(_type)
    {
    case INT:
      {
	char s[10];
	sprintf(s, "%d", _int_value);
	return string(s);
      }		    
    case STRING:
      return _string_value;

    }
}

scalar* scalar::Copy() const
{
  return new scalar(*this);
}

void scalar::Print(ostream& ostr) const
{
  switch(_type)
    {
    case INT:
      ostr<<_int_value;
      break;
    case STRING:
      ostr<<_string_value;
      break;
    }
}

ostream& operator<<(ostream& ostr, const scalar& s)
{
  s.Print(ostr);
  return ostr;
}


