%option noyywrap

%{
#include "scalar.hpp"
#include "list.hpp"
#include "pii-2005.03.tab.hpp"
#include <cstring>
#include <cstdlib>
%}

ID [_A-Za-z][_A-Za-z0-9]*
DIGIT [0-9]

%%

{DIGIT}*          { yylval.int_value = atoi(yytext);  return NUM_LITERAL;}
\"[^\"]*\"        { yylval.string_value = strdup(yytext+1); 
                    yylval.string_value[strlen(yylval.string_value)-1] = '\0'; 
                    return STRING_LITERAL;}
\${ID}            { yylval.string_value = strdup(yytext); return SCALAR_ID; }
@{ID}             { yylval.string_value = strdup(yytext); return LIST_ID; }
print             { return PRINT; }
push              { return PUSH; }
pop               { return POP; }
[-+*/x.()\[\];=,] { return *yytext; }
[ \t\n]
%%
