#!/usr/bin/perl
open(SUBJECTS, "subjects");
while(<SUBJECTS>) {
	chomp;
	@subs = split(/\t/, $_);
	$subjects{$subs[0]} = $subs[1];
}

open(TEACHERS, "teachers");
while(<TEACHERS>) {
	chomp;
	@subs = split(/\t/, $_);
	$teachers{$subs[0]} = $subs[1];
}

print <<END;
<html>
<title>Matematicki fakultet</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<head>
<link rel="stylesheet" type="text/css" href="matf.css" />
<link rel="stylesheet" type="text/css" href="matf_timetable.css" />
</head>
<body>
<div style="width : 950px; margin-left : auto">
<h2  align='center'>
<a href="">
Raspored casova
</a>
</h2>
<table class='timetable' cellspacing='1px' align='center'>
<tr><th></th>
<th class='timetable'>Ponedeljak</th>
<th class='timetable'>Utorak</th>
<th class='timetable'>Sreda</th>
<th class='timetable'>Cetvrtak</th>
<th class='timetable'>Petak</th>
</tr>

END

$cnt = 0;
while($line = <STDIN>) {
	if ($line =~ /^([^_]*)_([^_]*)_([^_]*)_(pon|uto|sre|cet|pet)_([0-9]+)_(.+)$/) {
		$teacher = $1;
		$room = $6;
		$key = $4."_".$5;
		if ($matrix{$key}) {
			$entry = "<span><a href='$2.html'>$2</a></span>, ".$matrix{$key};
			$matrix{$key} = $entry;
		} else {
			$entry = "<span><a href='$2.html'>$2</a></span>";
			$entry .= "<br>";
			$entry .= "<span><a href='$1.html'>$teachers{$1}</a></span>";	
			$entry .= "<br>";
			$3 =~ /([^.]+)[.]([^.]+)[.][0-9]+/;
			$entry .= "<span class='timetable_";
			if ($2 eq "v") { $entry .= "vezbe"; } elsif ($2 eq "p") { $entry .= "predavanja"; } else { $entry .= "praktikum"; }
			$entry .= "'>$subjects{$1}</span>";
			$entry .= "<br>";
			$entry .= "<span><a href='$room.html'>Sala $room</a></span>";
			$matrix{$key} = $entry;
		}
	} else {
		die("error line: $line");
	}
}

@days = ("pon", "uto", "sre", "cet", "pet");
for ($i = 8; $i < 21; $i++) {
print "<tr>\n";
print "<th class='timetable' width='40'>".$i."-".($i+1)."</td> ";
	foreach $day (@days) {
		$entry = $matrix{$day."_".$i};
		print "<td class='timetable'>$entry</td> ";
	}

print "\n</tr>\n";
}
print "</table>

<p align='center'>
<span class='timetable_predavanja'>predavanja</span>&nbsp;&nbsp;
<span class='timetable_vezbe'>vezbe</span>&nbsp;&nbsp
<span class='timetable_praktikum'>lab</span></p>
<hr>
<hr style='margin-top : 2px; margin-bottom : -8px'> <p align='center' class='small'>
Matematicki fakultet, Studentski Trg 16, 11000 Beograd
</p>
</div>
</body>
</html>";



