#ifndef __FUNKCIJA_H_
#define __FUNKCIJA_H_

#include <vector>
#include <string>
#include <map>
using namespace std;
class Izraz;

class Funkcija {
public:
	Funkcija(vector<string>* parametri, Izraz* izraz);

	~Funkcija();

	int Pozovi(const vector<int>& vrednosti);

	static void DefinisiFunkciju(const string& ime,
				     vector<string>* parametri,
				     Izraz* izraz);
	static int Pozovi(const string& ime, const vector<int>& vrednosti);

	static void ObrisiFunkcije();

private:
	vector<string>* parametri_;
	Izraz* izraz_;

	static map<string, Funkcija*> definisane_funkcije;
};
#endif
