# ime pocetne datoteke sajta
$index = $ARGV[0] ? $ARGV[0] : "index.html";

# pocetni direktorijum
$homedir = "www";

# Pozivamo funkcija koja obradjuje datoteku
# Funkcija rekurzivno obilazi ceo sajt
do_file($homedir."/".$index);

# Sortiramo i ispisujemo izracunatu statistiku
# Hash %out sadrzi broj izlaznih linkova za datu stranicu
# Hash %in  sadrzi broj ulaznih linkova ka svakoj stranici
print "Page\tout\tin\n";
foreach $k (sort {$in{$b} cmp $in{$a}} keys(%out))
{
	print $k."\t".$out{$k}."\t".$in{$k}."\n";
}


# Rekurzivna funkcija koja obradjuje datu stranicu 
sub do_file
{
	my $file = shift;
	print "Analyzing : $file\n";
	
	# Inicijalizujemo broj izlaznih linkova
	$out{$file} = 0;
	
	# Otvaramo i citamo datoteku
	open(FILE, $file) or die("Can't open $file");
	my $content = join('', <FILE>);
	
	
	# Pronalazimo linkove u datoteci
	while($content =~ /<a\s+href=\"(.+?)\">/ig)
	{
		# Gradimo punu putanju linkovane datoteke
		$link = $homedir."/".$1;
		
		print "Found $link in $file\n";
		
		# Uvecavamo broj izlaznih linkova za stranicu koju 
		# obradjujemo
		$out{$file}++;
		
		
		# Azuriramo broj ulaznih linkova za stranicu ka kojoj 
		# vodi upravo pronadjeni link
		if (!exists $in{$link})
		{	$in{$link} = 1;	}
		else
		{	$in{$link}++;	}
		
		# Rekurzivno obradjujemo linkovanu stranicu, ukoliko
		# vec nije obradjena
		if (!exists $out{$link})
		{	do_file($link)	}
		
	}
	
}
