#include "function.hpp"
#include "syntree.hpp"

//Destruktor 
Function::~Function()
{
	delete _code; 
}

// Registar funkcija
map<string, Function*> Function::_functions;

// Poziv funkcije za date vrednosti argumenata
int Function::Call(const vector<int>& values)
{
	// Proveravamo korektnost broja argumenata
	if (values.size() != _args.size())
	    throw "Wrong number of arguments in function call";
	
	// Formalnim argumentima dodeljujemo lokalne promenljive
	map<string, int> variables;
	for (size_t i = 0; i<values.size(); i++)
	    variables[_args[i]] = values[i];
	
	// Vrsimo interpretaciju koda
	_code->Interpret(variables);
	
	// Rezultat se nalazi u promenljivoj sa imenom _result
	return variables[_result];
}

