# Glavni program 

while ($input = <STDIN>)
{	
	# Uklanjamo \n sa kraja procitane linije 
	chop $input;

	print $input." = ";

	# Vrsimo izracunavanje vrednosti 
	advance();
	print E()."\n";
}


# Leksicki analizator 
# Funkcija vraca sledeci token iz niske input
# Tokeni su predstavljeni niskama karaktera
sub yylex()
{
	my $token;
	
	if ($input =~ /^\(/)
	{	$token = "LP"; 
	}
	elsif ($input =~ /^\)/)
	{	$token = "RP";
	}
	elsif ($input =~ /^\+/)
	{	$token = "PLUS";
	}
	elsif ($input =~ /^\*/)
	{	$token = "TIMES";
	}
	elsif ($input =~ /^(\d+)/)
	{
		$token = "NUM";
		$yylval = $1;
	}
	else 
	{
		$token = "EOI";
	}
	
	$input = $';
	
	return $token;
}

# Funkcija cita sledeci token iz ulazne niske
sub advance
{
	$token = yylex();
}


# Rekurzivni spust na osnovu LL(1) gramatike 
#	E -> T E'
#
#       EP -> + T E'  {PLUS}
#	| eps	      {RP, EOI}
#
#       T -> F T'     {NUM, LP}
#
#       T'-> * F T'   {TIMES}
#       | eps         {RP, PLUS, EOI}
#
#	F -> ( E )    {LP}
#	| NUM 	      {NUM}

sub E
{
	my $val = T() + EP();
	return $val;
}

sub EP
{
	if ($token eq "PLUS")
	{

		advance();
		my $val = T()+EP();	
	        return $val;
	}
	elsif ($token eq "RP" || $token eq "EOI")
        {
		return 0;
	}
	else
	{	die("Ocekivano ), + ili kraj ulaza");	}
}

sub T
{
	my $val = F()*TP(); 
	return $val;
}

sub TP
{	
	if ($token eq "TIMES")
	{	
		my $val;
		advance();
		$val = F()*TP();
		return $val;
	}
	elsif ($token eq "RP" || $token eq "PLUS" || $token eq "EOI")
	{
		return 1;
	}
	else 
	{	die("Ocekivano ), +, * ili kraj ulaza");	}
}			

sub F
{	
	if ($token eq "NUM")
	{	
		my $val = $yylval;
		advance();
		return $val;
	} 
	elsif ($token eq "LP")
	{	
		my $val;

		advance();
		$val = E();
		if ($token == "RP")
		{	advance();	}
		else 
		{	die("Ocekivano )");	}

		return $val;
	}
	else 
	{	die("Ocekivano ( ili broj");	}
}
