/*
	F1: F1 => F2
	  | F2
	  	  
	F2: F2 /\ F3
	  | F3
	
	F3: F3 \/ F4
	  | F4
	
	F4: T 
	  | F 
	  | ( F1 )
	  
	  
	FIRST			FOLLOW
F1	T, N, (			$$, )
F1'	=>, eps			$$, )
F2	T, N, (			=>, $$, )
F2'	/\, eps			=>, $$, )
F3	T, N, (			/\, =>, $$, )
F3'	\/, eps			/\, =>, $$, )
F4	T, N, (			\/, /\, =>, $$, )

	  
        F1: F2 F1'		{T, N, (}
          
        F1': => F2 F1'		{=>}
           | eps		{$$, )}
           
        F2: F3 F2'		{T, N, (}
            
        F2': /\ F3 F2'		{/\}
           | eps		{=>, $$, )}
           
        F3: F4 F3'		{T, N, (}
        
        F3': \/ F4 F3'		{\/}
           | eps		{/\, =>, $$, )}
           
        F4 : T			{T}
           | N			{N}
           | ( F1 )		{(}
	  
*/

#define IMPL 1
#define AND  2
#define OR   3
#define T    4
#define F    5
#define LP   6
#define RP   7

#define error(s) printf(s), exit(1);

int lookahead;
#define advance() (lookahead = yylex())

int F1();
int F1P();
int F2();
int F2P();
int F3();
int F3P();
int F4();

int F1()
{	int vf2, vf1p;
	printf("F1 : F2 F1p\n");
	vf2 = F2(); 
	vf1p = F1P();
	
	return (vf1p == -1 ) ? vf2 : (!vf2 || vf1p);
}


int F1P()
{
	if (lookahead == IMPL)
	{	int vf2, vf1p;
		printf("F1p : => F2 F1p\n");
		advance();
		vf2 = F2(); 
		vf1p = F1P();

		return (vf1p == -1 ) ? vf2 : (!vf2 || vf1p);
	}
	else
		if (lookahead == RP || lookahead == 0)
		{
			printf("F1p : eps\n");
			return -1;
		}
		else
			error("Ocekivano $$ ili )\n");
}

int F2()
{	int vf3, vf2p;

	printf("F2 : F3 F2p\n");

	vf3 = F3();
	vf2p = F2P();
	
	return vf3 && vf2p;
}

int F2P()
{
	printf("Called F2P\n");
	if (lookahead == AND)
	{	int vf3, vf2p;
		printf("F2p : /\\ F3 F2p\n");
		
		advance();
		vf3 = F3();
		vf2p = F2P();
	
		return 	vf3 && vf2p;
	}
	else
		if (lookahead == IMPL || lookahead == RP || lookahead == 0)
		{
			printf("F2p : eps\n");
			return 1;
		}
		else
			error("Ocekivano $$ ili ) ili =>\n");
}

int F3()
{	int vf4, vf3p;

	printf("F3 : F4 F3p\n");

	vf4 = F4();
	vf3p = F3P();
	
	return vf4 || vf3p;
}

int F3P()
{
	if (lookahead == OR)
	{	int vf4, vf3p;
		printf("F3p : \\/ F4 F3p\n");
		
		advance();
		vf4 = F4();
		vf3p = F3P();
		
		return vf4 || vf3p;
	}
	else
		if (lookahead == AND || lookahead == IMPL || lookahead == RP || lookahead == 0)
		{
			printf("F3p : eps\n");
			return 0;
		}
		else
			error("Ocekivano $$ ili ) ili => ili /\\\n");
}

int F4()
{
	printf("F4\n");
	if (lookahead == T)
	{	advance();
		return 1;
	} else if (lookahead == F)
	{	advance();
		return 0;
	} else if (lookahead == LP)
	{	int vf1;
		advance();
		vf1 = F1();
		if (lookahead == RP)
		{	advance();
			return vf1;
		}
		else
			error("Ocekivano )\n");
	}
	else 
		error("Ocekivano T, N ili (\n");
	
}

int yylex()
{
	int c;
	while(isspace(c=getchar()));
	
	switch(c)
	{
		case 'T' : 
			return T;
		case 'F' : 
			return F;
		case '(' : 
			return LP;
		case ')' : 
			return RP;
		case '=' :
			if ((c=getchar()) != '>')
				return 0;
			else
				return IMPL;
		case '\\' :
			if ((c=getchar()) != '/')
				return 0;
			else
				return OR;
		case '/':
			if ((c=getchar()) != '\\')
				return 0;
			else
				return AND;
		
	}
	return 0;
}


main()
{
	advance();
	printf("%d\n", F1());
}