%option noyywrap
%{

#include <string>
using namespace std;

#include "pii.2005.09.tab.hpp"

unsigned btoi(char* s, int b);
%}

%%

[0-9]+		{	yylval.int_attr = btoi(yytext, 10);	return INT_CONST; }
0x[0-9A-Fa-f]+	{	yylval.int_attr = btoi(yytext+2, 16);	return INT_CONST; }
0b[0-1]+	{	yylval.int_attr = btoi(yytext+2, 2);	return INT_CONST; }
print		{	return PRINT;		}
$[a-zA-Z_][a-zA-Z0-9_]*	{	yylval.str_attr = new string(yytext); return INT_ID;	}
[-+*/&|~(),;=]		{	return *yytext;		}
">>"		{	return RSHIFT;	}
"<<"		{	return LSHIFT;	}
[ \n\t]

%%

unsigned btoi(char* s, int b)
{
	int val;
	for (val = 0; *s; s++)
	{
		if ('0'<=*s && *s<='9')
			val = b*val + *s-'0';
		else if ('a'<=*s && *s<='f')
			val = b*val + *s-'a'+10;
		else if ('A'<=*s && *s<='F')
			val = b*val + *s-'A'+10;
	}

	return val;
}


