#!/usr/bin/perl

#Dati direktorijum sadrzi html prezentacije studenata matematickog fakulteta koje se 
#nalaze u posebnim direktorijumima koji su nazvani na osnovu broja indeksa studenta.
#Svaka prezentacija se sastoji iz vise html datoteka koje se nalaze
#unutar studentovog direktorijuma i njegovih eventualnih poddirektorijuma
#Program racuna odredjene statistike za svaku pojedinacnu prezentaciju 
#(broj reci van etiketa, broj linkova, broj slika, ...)

#Pocetni direktorijum se zadaje kao argument komandne linije
#Ukoliko se ne navede, podrazumeva se tekuci
$startdir = ($#ARGV>=0) ? $ARGV[0] : ".";

#Listamo pocetni direktorijum koristeci ls -l
open (STARTDIR, "ls -l $startdir|");
while (<STARTDIR>)
{	#Uklanjamo \n
	chop;

	#Delimo stavku na kolone
	@dir_data = split(/[ \t]/,$_);

	#Kolona sa indeksom 0 predstavlja prava (privilegije) - 
	#  direktorijumu se prepoznaju po pocetnom slovu d
	#Kolona sa indeksom 8 predstavlja ime
        #  zahtevamo da je u pitanju indeks studenta
	if ($dir_data[0] =~ /^d/  && 
            $dir_data[8] =~ /m[rmvnl]\d{5}/)
        {
	
		$num_of_words = 0;
		$num_of_links = 0;
		$num_of_images = 0;

		print "Student : $dir_data[8]\n";

		#Direktorijum listamo rekurzivno koristeci ls -R1
		$dir = $startdir."/".$dir_data[8];
		open(DIR,"ls -R1  ".$dir."|");
		while (<DIR>)
		{	#poddirektorijume prepoznajemo po : na kraju
			if (/(.+):$/)
			{	$dir = $1;	}

			#Za svaku htm ili html datoteku racunamo statistiku
			if (/.html?$/)
			{	$filename = "$dir/$_";
				#print "File : $filename\n";
				open(FILE, $filename) or die("Cannot open $filename");	
				while(<FILE>)
				{	#slike
					if (/<img/)
					{	$num_of_images++;	}
	
					#linkovi
					if (/<a\s+href/)
					{	$num_of_links++;	}	
					
					#izbacujemo etikete
					s/<[^>]+>|//g;
					
					#reci
					$num_of_words += length(split(/\s+/,$_));
				}
				
			}
		}
		print "Words : $num_of_words\tLinks : $num_of_links\tImages : $num_of_images \n";
	}
}
