%option noyywrap

%{

#include "y.tab.h"
#include <string.h>
#include <stdlib.h>

/*	Funkcija konverzije pozitivnih 
	celih brojeva iz osnove 12 u osnovu 10 */
int convert_12_to_10(char* s)
{
	int i, n = 0;
	for (i=0; s[i]!='\0'; i++)
		n = 12*n + s[i]-(('0'<=s[i] && s[i]<='9')?'0':'a'-10);
		
	return n;
}

%}

%%

0z[0-9]+	{ char* p_num = yytext;
		  yylval.int_value = atoi(p_num+2);
		  return NUM;
		}

[0-9ab]+	{ yylval.int_value = convert_12_to_10(yytext);
		  return NUM;
		}

[!#$%&']+	{	yylval.str_value = strdup(yytext);	
			return ID;
		}		
[-+*/^()=;]	{ 	return *yytext;	}
domorodacki	{	return DOM;	}
zemaljski	{	return ZEM;	}
[\n\t ]
%%
