%option noyywrap
%{  
#include "y.tab.h"
#include <string.h>
%}


%%
"while"                 return WHILE;
"if"                    return IF;
"else"                  return ELSE;
"print"                 return PRINT;
"++"                    return PP;
"--"			return MM;
"=="                    return EQ;
"<="                    return LEQ;
">="                    return GEQ;
[-+*/().{}<>=;]         return *yytext;
[_a-zA-Z][_a-zA-Z0-9]*  {yylval.str_value=strdup(yytext); return ID;}
[1-9][0-9]*|"0"         {yylval.str_value=strdup(yytext); return NUM;}
[ \t\n]
%%
