%x body_mod
%x center_mod
%x nepoznata_etiketa_mod

%{
#include <string.h>

#define DUZINA_REDA 80
#define MAX_NIVO_NAZUBLJENOSTI 16

int pozicija_u_redu=0;

void ispisi(char* rec);
void ispisi_razmak();
void ispisi_novi_red();
void centriraj(char* rec);

int stack[MAX_NIVO_NAZUBLJENOSTI];
int sp=0;
int brojac_liste=0;

%}

RAZMAK [ \t\n]
%%
"<BODY>"      { BEGIN(body_mod); }

<body_mod>{RAZMAK}*"\n"{RAZMAK}*"\n"{RAZMAK}* { ispisi_novi_red(); }

<body_mod>{RAZMAK}+     { ispisi_razmak(); }

<body_mod>"<P>"         { fprintf(yyout,"\n\n"); 
                          pozicija_u_redu=0;
                        }

<body_mod>"<BR>"        { ispisi_novi_red();
                        }


<body_mod>"<CENTER>"    { BEGIN(center_mod); }
<center_mod>"</CENTER>" { BEGIN(body_mod); }
<center_mod>\n
<center_mod>.*          { centriraj(yytext); }

<body_mod>"<OL>"        { if (sp>MAX_NIVO_NAZUBLJENOSTI)
                          {   printf("Greska : preveliki nivo nazubljenosti\n");
                              exit(1);
                          }
                          stack[sp++]=brojac_liste;
                          brojac_liste=1;
                        }

<body_mod>"</OL>"       { if (sp<1)
                            printf("Greska, neuparena etiketa <\OL>");
                          else
                            brojac_liste=stack[--sp];
                        }

<body_mod>"<LI>"        { if (sp==0)
                             printf("Greska : <LI> bez <OL>\n");
                          if (pozicija_u_redu!=0)
                             fprintf(yyout,"\n");
                          fprintf(yyout,"%d.",brojac_liste++);
                          pozicija_u_redu=2;
                        }


<body_mod>"<A HREF=\""[^>]*"\">" { char adresa[80];
                                   yytext[strlen(yytext)-2]='\0';
                                   sprintf(adresa,"[%s]",yytext+9);
                                   ispisi(adresa);
                                 }


 
<body_mod>"</BODY>"     { BEGIN(INITIAL); }


<body_mod>"<"[^>]*">"
<body_mod>"</"[^>]*">"




<body_mod>[^ \t\n<>]+     {ispisi(yytext);}
<body_mod>[<>] { ispisi(yytext); }
.
"\n"

%%

void ispisi(char* rec)
{  int duzina_reci=strlen(rec);
   if (pozicija_u_redu+duzina_reci<DUZINA_REDA)
   {   fprintf(yyout,"%s",rec);
       pozicija_u_redu+=duzina_reci;
   }
   else
   {   fprintf(yyout,"\n%s",rec);
       pozicija_u_redu=duzina_reci;
   }
	
}

void ispisi_razmak()
{   if (pozicija_u_redu>0)
       if (pozicija_u_redu<DUZINA_REDA)
       {   fprintf(yyout," ");
           pozicija_u_redu++;
       } 
       else 
       {  fprintf(yyout,"\n");
          pozicija_u_redu=0;
       }
}


void ispisi_novi_red()
{ if (pozicija_u_redu!=0)
  {    fprintf(yyout,"\n");
       pozicija_u_redu=0;
  }
}
                       



void centriraj(char* tekst)
{  int i;
   int duzina_teksta=strlen(tekst);

   if (pozicija_u_redu>0)
        fprintf(yyout,"\n");

   while (duzina_teksta>80)
   { for (i=0; i<80; i++)
        fprintf(yyout,"%c",tekst[i]);

     fprintf(yyout,"\n");
     tekst+=80;
     duzina_teksta-=80;
   
   }

   for (i=0; i<(80-duzina_teksta)/2; i++)
      fprintf(yyout," ");
   fprintf(yyout,"%s\n\n",tekst);
   pozicija_u_redu=0;
   
}

main(int argc, char* argv[])
{
   if (argc!=2)
      printf("Upotreba %s ime_datoteke",argv[0]);
   else
   {   char ime_dat[256];
       char* tackica=strrchr(argv[1],'.');
       if (tackica!=NULL && strcmp(tackica+1,"html")==0)
          *tackica='\0';
     
              
       sprintf(ime_dat,"%s.htm",argv[1]);
       yyin=fopen(ime_dat,"r");
        
       sprintf(ime_dat,"%s.txt",argv[1]);
       yyout=fopen(ime_dat,"w");
       yylex();
   }
}



