@input = <STDIN>;
$input = join('', @input);

advance(); 
################################################
expect("DOMAIN_SIZE");
expect("LBRACE");
$domain_size = $yylval;
# print "Domain size: $domain_size\n";
expect("NUM");
expect("RBRACE");
################################################

################################################
expect("RELATIONS");
expect("LBRACE");
while(1) {
	if (match("RBRACE")) {
		last;
	}

	$name = $yylval;

	expect("ID");
	expect("EQ");
	expect("LBRACE");

	if (match("RBRACE")) {
		last;
	}

	@pairs = ();

	while(1) {
		expect("LPAREN");
		$a = $yylval;
		expect("NUM");
		expect("COMMA");
		$b = $yylval;
		expect("NUM");
		expect("RPAREN");		
		push(@pairs, $a);
		push(@pairs, $b);

		if (match("RBRACE")) {
			last;
		}
		expect("COMMA");
	}
	expect("RBRACE");
	expect("SEMI");
	$relations{$name} = [@pairs];
#	print "$name: @{$relations{$name}}\n";
}
expect("RBRACE"); 
################################################

################################################
expect("QUERIES");
expect("LBRACE");
while(1) {
	if (match("RBRACE")) {
		last;
	}
	if (query()) {
		print "TRUE\n";
	} else {
		print "FALSE\n";
	}
	advance();
}
expect("RBRACE");
###############################################




################################################
# query -> q1 q'	  {NOT, LP, ID}
# q' -> or q1 q'	  {OR}
#   |  eps		  {RP, SEMI}
# q1 -> q2 q1'		  {NOT, LP, ID}
# q1' -> and q2 q1'	  {AND}
#   |  eps		  {RP, OR, SEMI}
# q2 -> not q2		  {NOT}
#    | ( query )	  {(}
#    | atom		  {ID}
# atom -> ID ( NUM, NUM ) {ID}
################################################

sub query() {
#	print "q -> q1 q'\n";
	my $q1v = q1();
	my $qpv = qp();
	return $q1v || $qpv;
}

sub qp() {
	if (match("OR")) {
#		print "q' -> or q1 q'\n";
		advance();
		my $q1v = q1();
		my $qpv = qp();
		return $q1v || $qpv;
	} elsif (match("SEMI") || match("RPAREN")) {
#		print "q' -> eps\n";
		return 0;
	} else {
		die "Expected: OR, SEMI, RPAREN\n";
	}
}

sub q1() {
#	print "q1 -> q2 q1'\n";
	my $q2v = q2();
	my $q1pv = q1p();
	return $q2v && $q1pv;
}

sub q1p() {
	if (match("AND")) {
#		print "q1' -> and q2 q1'\n";
		advance();
		my $q2v = q2();
		my $q1pv = q1p();
		return $q2v && $q1pv;
	} elsif (match("SEMI") || match("OR")  || match("RPAREN")) {
#		print "q1' -> eps\n";
		return 1;
	} else {
		die "Expected: AND, OR, SEMI, RPAREN\n";
	}
}

sub q2() {
	if (match("LPAREN")) {
#		print "q2 -> ( q )\n";
		advance();
		my $qv = query();
		expect("RPAREN");
		return $qv;
	} elsif (match("NOT")) {
#		print "q2 -> not q2\n";
		advance();
		my $q2v = q2();
		return !$q2v;
	} elsif (match("ID")) {
#		print "q2 -> atom\n";
		my $av = atom();
		return $av;
	} else {
		die "Expected: LPAREN, NOT, ID\n";
	}
}

sub atom() {
#	print "atom -> (NUM, NUM)\n";

	$name = $yylval;
	expect("ID");
	expect("LPAREN");	
	$a = $yylval;
	expect("NUM");
	expect("COMMA");
	$b = $yylval;
	expect("NUM");
	expect("RPAREN");
	
	@relation = @{$relations{$name}};
	for ($i = 0; $i < $#relation; $i += 2) {
		if ($a == $relation[$i] && $b == $relation[$i+1]) {
			return 1;
		}
	}
	return 0;
}


################################################
sub advance() {
	$token = yylex();
}
################################################

################################################
sub match() {
	return $token eq shift();
}
################################################

################################################
sub expect() {	
	$expected = shift();
	if ($token ne $expected) {
		die("Expected: $expected");
	}
	advance();
}
################################################

################################################
sub yylex() {
	$input =~ s/^\s+//;
	if ($input =~ /^domain_size/) {
		$token = "DOMAIN_SIZE";
	} elsif ($input =~ /^relations/) {
		$token = "RELATIONS";
	} elsif ($input =~ /^queries/) {
		$token = "QUERIES";
	} elsif ($input =~ "^{") {
		$token = "LBRACE";
	} elsif ($input =~ "^}") {
		$token = "RBRACE";
	} elsif ($input =~ /^\(/) {
		$token = "LPAREN";
	} elsif ($input =~ /^\)/) {
		$token = "RPAREN";
	} elsif ($input =~ "^;") {
		$token = "SEMI";
	} elsif ($input =~ "^,") {
		$token = "COMMA";
	} elsif ($input =~ "^:=") {
		$token = "EQ";
	} elsif ($input =~ /^(\d+)/) {
		$token = "NUM";
		$yylval = $1;
	} elsif ($input =~ /^and/) {
		$token = "AND";
	} elsif ($input =~ /^or/) {
		$token = "OR";
	} elsif ($input =~ /^not/) {
		$token = "NOT";
	} elsif ($input =~ /^([a-z]+)/) {
		$token = "ID";
		$yylval = $1;
	} else {
		$token = "EOF";
	}
	$input = $';
	return $token;
}
################################################

