#include "funkcija.h"
#include "izrazi.h"

map<string, Funkcija*> Funkcija::definisane_funkcije;

Funkcija::Funkcija(vector<string>* parametri, Izraz* izraz)
	: parametri_(parametri), izraz_(izraz) {
}

Funkcija::~Funkcija() {
	delete parametri_;
	delete izraz_;
}

int Funkcija::Pozovi(const vector<int>& vrednosti) {
	map<string, int> promenljive;
	if (vrednosti.size() != parametri_->size())
		throw "Neodgovarajuci broj argumenata pri pozivu funkcije";

	for (size_t i = 0; i < parametri_->size(); i++)
		promenljive[(*parametri_)[i]] = vrednosti[i];
	
	return izraz_->Vrednost(promenljive);
}

void Funkcija::DefinisiFunkciju(const string& ime,
			     vector<string>* parametri,
			     Izraz* izraz) {
	map<string, Funkcija*>::const_iterator i = definisane_funkcije.find(ime);
	if (i != definisane_funkcije.end())
		delete i->second;
	definisane_funkcije[ime] = new Funkcija(parametri, izraz);
}

int Funkcija::Pozovi(const string& ime, const vector<int>& vrednosti) {
	map<string, Funkcija*>::const_iterator i = definisane_funkcije.find(ime);
	if (i == definisane_funkcije.end())
		throw "Poziv nedefinisane funkcije";
	return i->second->Pozovi(vrednosti);
}

void Funkcija::ObrisiFunkcije() {
	map<string, Funkcija*>::iterator i;
	for (i = definisane_funkcije.begin(); i != definisane_funkcije.end(); i++)
		delete i->second;
}
