%{

#define YYDEBUG 0

#include "Vrednost.h"

map<string, Vrednost*> promenjive;

#define yyerror printf
int yylex();
int yyparse();

%}


%union{
	char*     _str;
	int       _num;
	Vrednost* _vrednost;
	set<int>* _skup;
}

%left '+'
%left '*'
%token <_str> ID
%token <_num> NUM
%type  <_vrednost> izraz
%type  <_skup> skup
%type  <_skup> niz_brojeva

%%

datoteka : datoteka ID '=' izraz ';' 
	{ 	map<string, Vrednost*>::iterator stara_vrednost = promenjive.find($2);
		if (stara_vrednost != promenjive.end())
			delete stara_vrednost->second;
		promenjive[$2] = $4; }
	 |
	 ;

izraz : izraz '+' izraz 
	{ $$ = $1->Plus($3); delete $1; delete $3; }
      | izraz '*' izraz
	{ $$ = $1->Puta($3); delete $1; delete $3; }
      | ID
	{ $$ = promenjive[$1]->Clone(); }
      | NUM
	{ $$ = new Broj($1); }
      | skup
	{ $$ = new Skup($1); }
      | '(' izraz ')'
	{ $$ = $2; }
      ;

skup : '{' niz_brojeva '}' { $$ = $2; }
     | '{' '}' { $$ = new set<int>(); }
     ;	

niz_brojeva : niz_brojeva ',' NUM
		{ $$->insert($3); }
	| NUM 
		{ $$ = new set<int>(); 
		  $$->insert($1); 
		}
	;


%%


main()
{

	yydebug = 0;

	yyparse();
	map<string, Vrednost*>::iterator i;
	for (i = promenjive.begin(); i != promenjive.end(); i++)
	{
		cout<<i->first<<":";
		i->second->Print(cout);
		cout<<endl;
	}
}
