  typedef enum {DIM_T, POINT_T, SEGMENT_T, LINE_T, CIRCLE_T} GeomObjectType;

  typedef struct _point
  {     GeomObjectType  type;
	float x, y;
  } point;
  
  typedef struct _segment
  {    GeomObjectType  type; 
       point a,b;
  } segment;
  
  typedef struct _line
  {    GeomObjectType  type; 
       point a, vector;
  } line;

  typedef struct _circle
  {  GeomObjectType  type; 
     float x,y,r;
  } circle;
  
  typedef struct _number
  {  GeomObjectType type;
     float value;
  } number;
  
  typedef union _geom_object
  {   GeomObjectType  type;
      point p;
      segment s;
      circle c;
      line l;
      number num;
  } geom_object;

  geom_object* make_point   (geom_object* a, geom_object* b);
  geom_object* make_segment (geom_object* a, geom_object* b);
  geom_object* make_circle  (geom_object* a, geom_object* b);
  geom_object* med          (geom_object* a);
  geom_object* intersect    (geom_object* a, geom_object* b);
  geom_object* distance     (geom_object* a, geom_object* b);
  void         draw         (geom_object* a);
