#include "pii-03.04.h"
#include <stdlib.h>
#include <math.h>

geom_object* make_point(geom_object* a, geom_object* b)
{  geom_object* c;
   if (a->type==DIM_T && b->type==DIM_T)
    {     c=(geom_object*)malloc(sizeof(geom_object));
          c->type=POINT_T;
          c->p.x=a->num.value;          
          c->p.y=b->num.value;          
    }
    else
         c=NULL;
    return c;
}


geom_object* make_segment(geom_object* a, geom_object* b)
{  geom_object* c;
   if (a->type==POINT_T && b->type==POINT_T)
    {     c=(geom_object*)malloc(sizeof(geom_object));
          c->type=SEGMENT_T;
          c->s.a=a->p;          
          c->s.b=b->p;
    }
    else
         c=NULL;
    return c;
}


geom_object* make_circle(geom_object* a, geom_object* b)
{  geom_object* c;
   if (a->type==POINT_T && b->type==DIM_T)
    {     c=(geom_object*)malloc(sizeof(geom_object));
          c->type=CIRCLE_T;
          c->c.x=a->p.x;          
          c->c.y=a->p.y;
          c->c.r=b->num.value;          
    }
    else
         c=NULL;
    return c;
}

geom_object* distance(geom_object* a, geom_object* b)
{  geom_object* c;
   float x,y;
   if (a->type==POINT_T && b->type==POINT_T)
    {     c=(geom_object*)malloc(sizeof(geom_object));
          c->type=DIM_T;
          x=b->p.x-a->p.x;
          y=b->p.y-a->p.y;
          c->num.value=sqrt(x*x+y*y);          
    }
    else
         c=NULL;
    return c;
}

geom_object* med(geom_object* seg)
{  geom_object* c;
   if (seg->type==SEGMENT_T)
   {     c=(geom_object*)malloc(sizeof(geom_object));
         c->type=LINE_T;
         c->l.a.x=(seg->s.a.x+seg->s.b.x)/2.0;
         c->l.a.y=(seg->s.a.y+seg->s.b.y)/2.0;
         c->l.vector.y=seg->s.a.x-seg->s.b.x;
         c->l.vector.x=seg->s.b.y-seg->s.a.y;
   }
   else
         c=NULL;
   return c;

}

geom_object* intersect(geom_object* a, geom_object* b)
{  geom_object* c;
   if (a->type==LINE_T && b->type==LINE_T)
    {    float det_s,det_1,t;
         c=(geom_object*)malloc(sizeof(geom_object));
         c->type=POINT_T;

         det_s=a->l.vector.x*b->l.vector.y-
               b->l.vector.x*a->l.vector.y;

         if (det_s==0.0)
                 return NULL;
           
         det_1 =  (a->l.a.y-b->l.a.y)*a->l.vector.x
                - (a->l.a.x-b->l.a.x)*a->l.vector.y;
         t = det_1/det_s;

          c->p.x=b->l.a.x+t*b->l.vector.x;          
          c->p.y=b->l.a.y+t*b->l.vector.y;          
    }
    else
         c=NULL;
    return c;
}

void draw(geom_object* o)
{   switch(o->type)
    {    case POINT_T:
              printf("plot(%g,%g,'o');\n",o->p.x, o->p.y);
              break;
         case SEGMENT_T:
              printf("plot([%g,%g],[%g,%g]);\n",o->s.a.x, o->s.b.x, o->s.a.y, o->s.b.y);
              break;
         case CIRCLE_T:
              printf("fi=linspace(0,2*pi);");
              printf("x=%g+%g*cos(fi);",o->c.x, o->c.r);
              printf("y=%g+%g*sin(fi);",o->c.y, o->c.r);
              printf("plot(x,y,'r');\n");
              break; 
    }
}
